/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class OracleHierarchicalExpression
extends ASTNodeAccessImpl
implements Expression {
    boolean connectFirst = false;
    private Expression startExpression;
    private Expression connectExpression;
    private boolean noCycle = false;

    public Expression getStartExpression() {
        return this.startExpression;
    }

    public void setStartExpression(Expression startExpression) {
        this.startExpression = startExpression;
    }

    public Expression getConnectExpression() {
        return this.connectExpression;
    }

    public void setConnectExpression(Expression connectExpression) {
        this.connectExpression = connectExpression;
    }

    public boolean isNoCycle() {
        return this.noCycle;
    }

    public void setNoCycle(boolean noCycle) {
        this.noCycle = noCycle;
    }

    public boolean isConnectFirst() {
        return this.connectFirst;
    }

    public void setConnectFirst(boolean connectFirst) {
        this.connectFirst = connectFirst;
    }

    @Override
    public <T, S> T accept(ExpressionVisitor<T> expressionVisitor, S context) {
        return expressionVisitor.visit(this, context);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.isConnectFirst()) {
            b.append(" CONNECT BY ");
            if (this.isNoCycle()) {
                b.append("NOCYCLE ");
            }
            b.append(this.connectExpression.toString());
            if (this.startExpression != null) {
                b.append(" START WITH ").append(this.startExpression);
            }
        } else {
            if (this.startExpression != null) {
                b.append(" START WITH ").append(this.startExpression);
            }
            b.append(" CONNECT BY ");
            if (this.isNoCycle()) {
                b.append("NOCYCLE ");
            }
            b.append(this.connectExpression.toString());
        }
        return b.toString();
    }

    public OracleHierarchicalExpression withStartExpression(Expression startExpression) {
        this.setStartExpression(startExpression);
        return this;
    }

    public OracleHierarchicalExpression withConnectExpression(Expression connectExpression) {
        this.setConnectExpression(connectExpression);
        return this;
    }

    public OracleHierarchicalExpression withNoCycle(boolean noCycle) {
        this.setNoCycle(noCycle);
        return this;
    }

    public OracleHierarchicalExpression withConnectFirst(boolean connectFirst) {
        this.setConnectFirst(connectFirst);
        return this;
    }

    public <E extends Expression> E getStartExpression(Class<E> type) {
        return (E)((Expression)type.cast(this.getStartExpression()));
    }

    public <E extends Expression> E getConnectExpression(Class<E> type) {
        return (E)((Expression)type.cast(this.getConnectExpression()));
    }
}

