/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.registry.ApplicationPolicyProvider;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSecurity;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.DataSourceHandlerUtils;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DatabaseNativeAuthModelConfigurator
implements IObjectPropertyConfigurator<DBAAuthModel<?>, DBPDataSourceContainer> {
    protected Label usernameLabel;
    protected Text usernameText;
    protected Label passwordLabel;
    protected Composite passPlaceholder;
    protected Text passwordText;
    protected Button savePasswordCheck;
    protected Button showPasswordButton;
    protected DBPDataSourceContainer dataSource;
    protected final boolean canEditCredentialsPerPolicy = !ApplicationPolicyProvider.getInstance().isPolicyEnabled("connection.credentials.save.restricted");

    public void createControl(@NotNull Composite authPanel, DBAAuthModel<?> object, @NotNull Runnable propertyChangeListener) {
        boolean userNameApplicable = true;
        boolean userPasswordApplicable = true;
        if (object instanceof AuthModelDatabaseNative) {
            AuthModelDatabaseNative amd = (AuthModelDatabaseNative)object;
            userNameApplicable = amd.isUserNameApplicable();
            userPasswordApplicable = amd.isUserPasswordApplicable();
        }
        if (!userNameApplicable) {
            return;
        }
        this.usernameLabel = UIUtils.createLabel((Composite)authPanel, (String)UIConnectionMessages.dialog_connection_auth_label_username);
        this.usernameLabel.setLayoutData((Object)new GridData(32));
        this.createUserNameControls(authPanel, propertyChangeListener);
        if (userPasswordApplicable) {
            this.createPasswordControls(authPanel, propertyChangeListener);
        }
    }

    protected void createUserNameControls(Composite authPanel, Runnable propertyChangeListener) {
        this.usernameText = new Text(authPanel, 2048);
        this.usernameText.setLayoutData((Object)this.makeAuthControlLayoutData(authPanel));
        this.usernameText.addModifyListener(e -> propertyChangeListener.run());
    }

    @NotNull
    private GridData makeAuthControlLayoutData(Composite authPanel) {
        int fontHeight = UIUtils.getFontHeight((Control)authPanel);
        GridData gd = new GridData(32);
        gd.widthHint = fontHeight * 20;
        return gd;
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        this.dataSource = dataSource;
        if (dataSource instanceof DataSourceDescriptor) {
            DataSourceDescriptor dsd = (DataSourceDescriptor)dataSource;
            if (dataSource.isSharedCredentials()) {
                DataSourceHandlerUtils.resolveSharedCredentials((DBPDataSourceContainer)dsd, null);
            }
        }
        if (this.usernameText != null && !this.usernameText.isDisposed()) {
            this.usernameText.setText(CommonUtils.notEmpty((String)dataSource.getConnectionConfiguration().getUserName()));
        }
        if (this.passwordText != null && !this.passwordText.isDisposed()) {
            this.passwordText.setText(CommonUtils.notEmpty((String)dataSource.getConnectionConfiguration().getUserPassword()));
            if (this.canEditCredentialsPerPolicy) {
                this.passwordText.setEnabled(dataSource.isSavePassword());
                if (this.savePasswordCheck != null) {
                    this.savePasswordCheck.setSelection(dataSource.isSavePassword() || this.isForceSaveCredentials());
                }
                if (this.showPasswordButton != null) {
                    this.showPasswordButton.setEnabled(dataSource.isSavePassword() || this.isForceSaveCredentials());
                }
            } else {
                if (this.savePasswordCheck != null) {
                    this.savePasswordCheck.setSelection(false);
                    this.savePasswordCheck.setEnabled(false);
                }
                if (this.showPasswordButton != null) {
                    this.showPasswordButton.setEnabled(false);
                }
            }
        }
        if (dataSource.isTemporary()) {
            if (this.passwordText != null) {
                this.passwordText.setEnabled(true);
            }
            if (this.savePasswordCheck != null) {
                this.savePasswordCheck.setSelection(true);
                this.savePasswordCheck.setEnabled(false);
            }
            if (this.showPasswordButton != null) {
                this.showPasswordButton.setEnabled(false);
            }
        }
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        boolean resetPassword;
        boolean bl = resetPassword = !this.canEditCredentialsPerPolicy || this.savePasswordCheck != null && !this.savePasswordCheck.getSelection();
        if (dataSource.isSharedCredentials()) {
            resetPassword = false;
        }
        if (this.usernameText != null) {
            dataSource.getConnectionConfiguration().setUserName(GeneralUtils.trimAllWhitespaces((String)this.usernameText.getText()));
        }
        if (this.passwordText != null && this.isPasswordApplicable() && !resetPassword) {
            dataSource.getConnectionConfiguration().setUserPassword(GeneralUtils.trimAllWhitespaces((String)this.passwordText.getText()));
        } else {
            dataSource.getConnectionConfiguration().setUserPassword(null);
        }
        if (!this.canEditCredentialsPerPolicy) {
            dataSource.setSavePassword(dataSource.isSharedCredentials());
        } else if (this.savePasswordCheck != null) {
            dataSource.setSavePassword(this.savePasswordCheck.getSelection());
        }
    }

    public void resetSettings(@NotNull DBPDataSourceContainer dataSource) {
        this.loadSettings(dataSource);
    }

    protected boolean isPasswordApplicable() {
        return this.passwordText != null;
    }

    public boolean isComplete() {
        return true;
    }

    protected boolean isForceSaveCredentials() {
        return false;
    }

    protected Text createPasswordText(Composite parent, String label) {
        if (label != null) {
            UIUtils.createControlLabel((Composite)parent, (String)label);
        }
        Composite ph = UIUtils.createPlaceholder((Composite)parent, (int)1);
        ph.setLayoutData((Object)new GridData(32));
        this.passwordText = new Text(ph, 0x400800);
        this.passwordText.setLayoutData((Object)this.makeAuthControlLayoutData(ph));
        return this.passwordText;
    }

    protected void createPasswordControls(Composite parent, Runnable propertyChangeListener) {
        this.passwordLabel = UIUtils.createLabel((Composite)parent, (String)this.getPasswordFieldLabel());
        this.passwordLabel.setLayoutData((Object)new GridData(32));
        this.passPlaceholder = UIUtils.createComposite((Composite)parent, (int)2);
        this.passPlaceholder.setLayoutData((Object)new GridData(768));
        this.createPasswordText(this.passPlaceholder, null);
        this.passwordText.addModifyListener(e -> propertyChangeListener.run());
        UIServiceSecurity serviceSecurity = (UIServiceSecurity)DBWorkbench.getService(UIServiceSecurity.class);
        boolean supportsPasswordView = serviceSecurity != null;
        int colCount = 1;
        if (supportsPasswordView) {
            ++colCount;
        }
        Composite panel = UIUtils.createComposite((Composite)this.passPlaceholder, (int)colCount);
        GridData gd = new GridData(32);
        panel.setLayoutData((Object)gd);
        if (this.canEditCredentialsPerPolicy) {
            this.savePasswordCheck = UIUtils.createCheckbox((Composite)panel, (String)UIConnectionMessages.dialog_connection_wizard_final_checkbox_save_password, (String)UIConnectionMessages.dialog_connection_wizard_final_checkbox_save_password, (this.dataSource == null || this.dataSource.isSavePassword() || this.isForceSaveCredentials() ? 1 : 0) != 0, (int)1);
            this.savePasswordCheck.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                this.passwordText.setEnabled(this.savePasswordCheck.getSelection());
                if (this.showPasswordButton != null) {
                    this.showPasswordButton.setEnabled(this.savePasswordCheck.getSelection());
                }
            }));
            this.savePasswordCheck.setEnabled(!this.isForceSaveCredentials());
        }
        if (supportsPasswordView && this.canEditCredentialsPerPolicy) {
            this.showPasswordButton = UIUtils.createPushButton((Composite)panel, null, (String)UIConnectionMessages.dialog_connection_auth_label_show_password, (DBPImage)UIIcon.SHOW_ALL_DETAILS, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.showPasswordText(serviceSecurity)));
        }
    }

    protected String getPasswordFieldLabel() {
        return UIConnectionMessages.dialog_connection_auth_label_password;
    }

    private void showPasswordText(UIServiceSecurity serviceSecurity) {
        boolean passHidden;
        boolean bl = passHidden = (this.passwordText.getStyle() & 0x400000) == 0x400000;
        if (passHidden && this.dataSource.getRegistry().getDataSource(this.dataSource.getId()) != null && !serviceSecurity.validatePassword(this.dataSource.getProject(), "Enter project password", "Enter project password to unlock connection password view", true)) {
            return;
        }
        this.passwordText = UIUtils.recreateTextControl((Text)this.passwordText, (int)(passHidden ? 2048 : 0x400800));
    }
}

