/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.DB2Utils;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2TableKeyColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2TableReference;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2TableCache;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public final class DB2TableReferenceCache
extends JDBCCompositeCache<DB2Schema, DB2Table, DB2TableReference, DB2TableKeyColumn> {
    public static final String SQL_REF_TAB = " SELECT R.*      , KCU.COLNAME      , KCU.COLSEQ   FROM SYSCAT.REFERENCES R       ,SYSCAT.KEYCOLUSE KCU  WHERE R.REFTABSCHEMA = ?    AND R.REFTABNAME = ?    AND KCU.CONSTNAME = R.REFKEYNAME    AND KCU.TABSCHEMA = R.REFTABSCHEMA    AND KCU.TABNAME   = R.REFTABNAME  ORDER BY R.REFKEYNAME         , KCU.COLSEQ WITH UR";
    public static final String SQL_REF_ALL = " SELECT R.*      , KCU.COLNAME      , KCU.COLSEQ   FROM SYSCAT.REFERENCES R       ,SYSCAT.KEYCOLUSE KCU  WHERE R.REFTABSCHEMA = ?    AND KCU.CONSTNAME = R.REFKEYNAME    AND KCU.TABSCHEMA = R.REFTABSCHEMA    AND KCU.TABNAME   = R.REFTABNAME  ORDER BY R.REFKEYNAME         , KCU.COLSEQ WITH UR";

    public DB2TableReferenceCache(DB2TableCache tableCache) {
        super((JDBCStructCache)tableCache, DB2Table.class, (Object)"REFTABNAME", (Object)"CONSTNAME");
    }

    @NotNull
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull DB2Schema db2Schema, @Nullable DB2Table forTable) throws SQLException {
        String sql = forTable != null ? SQL_REF_TAB : SQL_REF_ALL;
        JDBCPreparedStatement dbStat = session.prepareStatement(sql);
        dbStat.setString(1, db2Schema.getName());
        if (forTable != null) {
            dbStat.setString(2, forTable.getName());
        }
        return dbStat;
    }

    @Nullable
    protected DB2TableReference fetchObject(@NotNull JDBCSession session, @NotNull DB2Schema db2Schema, @NotNull DB2Table db2Table, @NotNull String constName, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
        String ownerSchemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TABSCHEMA");
        String ownerTableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABNAME");
        DB2Table ownerTable = DB2Utils.findTableBySchemaNameAndName(session.getProgressMonitor(), db2Schema.getDataSource(), ownerSchemaName, ownerTableName);
        if (ownerTable == null) {
            log.error((Object)("Cannot find reference owner table " + ownerSchemaName + "." + ownerTableName));
            return null;
        }
        return new DB2TableReference(session.getProgressMonitor(), ownerTable, (ResultSet)dbResult);
    }

    @Nullable
    protected DB2TableKeyColumn[] fetchObjectRow(@NotNull JDBCSession session, @NotNull DB2Table db2Table, @NotNull DB2TableReference db2TableReference, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
        String colName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLNAME");
        DB2TableColumn tableColumn = db2Table.getAttribute(session.getProgressMonitor(), colName);
        if (tableColumn == null) {
            log.debug((Object)("DB2TableReferenceCache : Column '" + colName + "' not found in table '" + db2Table.getName() + "' ??"));
            return null;
        }
        return new DB2TableKeyColumn[]{new DB2TableKeyColumn((AbstractTableConstraint<DB2Table, ? extends DB2TableKeyColumn>)db2TableReference, tableColumn, JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"COLSEQ"))};
    }

    protected void cacheChildren(@NotNull DBRProgressMonitor monitor, @NotNull DB2TableReference constraint, @NotNull List<DB2TableKeyColumn> rows) {
        constraint.setAttributeReferences(rows);
    }
}

