/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.databricks;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericExecutionContext;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class DatabricksExecutionContext
extends GenericExecutionContext {
    private static final Log log = Log.getLog(DatabricksExecutionContext.class);
    @Nullable
    private String activeCatalogName;

    DatabricksExecutionContext(JDBCRemoteInstance instance, String purpose) {
        super(instance, purpose);
    }

    @Nullable
    public GenericCatalog getDefaultCatalog() {
        if (CommonUtils.isEmpty((String)this.activeCatalogName)) {
            return super.getDefaultCatalog();
        }
        return this.getDataSource().getCatalog(this.activeCatalogName);
    }

    public void setDefaultCatalog(@NotNull DBRProgressMonitor monitor, @NotNull GenericCatalog catalog, @Nullable GenericSchema schema) throws DBCException {
        try {
            super.setDefaultCatalog(monitor, catalog, schema);
            this.activeCatalogName = catalog.getName();
        }
        catch (DBCException e) {
            log.debug((Object)"Error setting default catalog for Databricks", (Throwable)e);
        }
    }

    public boolean refreshDefaults(DBRProgressMonitor monitor, boolean useBootstrapSettings) throws DBException {
        boolean isRefreshed = super.refreshDefaults(monitor, useBootstrapSettings);
        Throwable throwable = null;
        Object var5_6 = null;
        try (JDBCSession session = this.openSession(monitor, DBCExecutionPurpose.META, "Query current catalog");){
            try {
                Throwable throwable2 = null;
                Object var8_12 = null;
                try (JDBCStatement dbStat = session.createStatement();){
                    Throwable throwable3 = null;
                    Object var11_17 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery("SELECT CURRENT_CATALOG()");){
                        String currentCatalog;
                        if (dbResult != null && dbResult.next() && CommonUtils.isNotEmpty((String)(currentCatalog = dbResult.getString(1))) && !CommonUtils.equalObjects((Object)currentCatalog, (Object)this.activeCatalogName)) {
                            this.activeCatalogName = currentCatalog;
                            isRefreshed = true;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                log.debug((Object)"Failed to get current catalog", (Throwable)e);
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        return isRefreshed;
    }
}

