/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TDoubleDoubleHashMap;
import gnu.trove.TDoubleDoubleIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TDoubleDoubleHashMapDecorator
extends AbstractMap<Double, Double> {
    protected final TDoubleDoubleHashMap _map;

    public TDoubleDoubleHashMapDecorator(TDoubleDoubleHashMap map2) {
        this._map = map2;
    }

    @Override
    public Double put(Double key, Double value2) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value2)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i2 = that.size();
            while (i2-- > 0) {
                Map.Entry e = it.next();
                Object key = e.getKey();
                Object val = e.getValue();
                if (key instanceof Double && val instanceof Double) {
                    double k = this.unwrapKey(key);
                    double v = this.unwrapValue(val);
                    if (this._map.containsKey(k) && v == this._map.get(k)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Double get(Object object) {
        return this.get((Double)object);
    }

    public Double get(Double key) {
        double k = this.unwrapKey(key);
        double v = this._map.get(k);
        if (v == 0.0) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public Double remove(Double key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Double remove(Object object) {
        return this.remove((Double)object);
    }

    @Override
    public Set<Map.Entry<Double, Double>> entrySet() {
        return new AbstractSet<Map.Entry<Double, Double>>(){

            @Override
            public int size() {
                return TDoubleDoubleHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TDoubleDoubleHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TDoubleDoubleHashMapDecorator.this.containsKey(k) && TDoubleDoubleHashMapDecorator.this.get(k).equals(v);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<Double, Double>> iterator() {
                return new Iterator<Map.Entry<Double, Double>>(){
                    private final TDoubleDoubleIterator it;
                    {
                        this.it = TDoubleDoubleHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<Double, Double> next() {
                        this.it.advance();
                        final Double key = TDoubleDoubleHashMapDecorator.this.wrapKey(this.it.key());
                        final Double v = TDoubleDoubleHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<Double, Double>(){
                            private Double val;
                            {
                                this.val = v;
                            }

                            @Override
                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            @Override
                            public Double getKey() {
                                return key;
                            }

                            @Override
                            public Double getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Double setValue(Double value2) {
                                this.val = value2;
                                return TDoubleDoubleHashMapDecorator.this.put(key, value2);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Map.Entry<Double, Double> o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<Double, Double>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TDoubleDoubleHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends Double, ? extends Double> map2) {
        Iterator<Map.Entry<? extends Double, ? extends Double>> it = map2.entrySet().iterator();
        int i2 = map2.size();
        while (i2-- > 0) {
            Map.Entry<? extends Double, ? extends Double> e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected Double wrapKey(double k) {
        return new Double(k);
    }

    protected double unwrapKey(Object key) {
        return (Double)key;
    }

    protected Double wrapValue(double k) {
        return new Double(k);
    }

    protected double unwrapValue(Object value2) {
        return (Double)value2;
    }
}

