/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.psi.internal;

import io.github.detekt.psi.internal.KotlinNoImportClassesKt;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u0003J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0011\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lio/github/detekt/psi/internal/FullQualifiedNameGuesser;", "", "packageName", "", "imports", "", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "resolvedNames", "", "getResolvedNames", "()Ljava/util/Map;", "resolvedNames$delegate", "Lkotlin/Lazy;", "starImports", "getStarImports", "()Ljava/util/List;", "starImports$delegate", "getFullQualifiedName", "", "name", "findName", "detekt-psi-utils"})
@SourceDebugExtension(value={"SMAP\nFullQualifiedNameGuesser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullQualifiedNameGuesser.kt\nio/github/detekt/psi/internal/FullQualifiedNameGuesser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1#2:73\n1863#3,2:74\n*S KotlinDebug\n*F\n+ 1 FullQualifiedNameGuesser.kt\nio/github/detekt/psi/internal/FullQualifiedNameGuesser\n*L\n55#1:74,2\n*E\n"})
public final class FullQualifiedNameGuesser {
    @Nullable
    private final String packageName;
    @NotNull
    private final Lazy resolvedNames$delegate;
    @NotNull
    private final Lazy starImports$delegate;

    public FullQualifiedNameGuesser(@Nullable String packageName2, @NotNull List<? extends KtImportDirective> imports) {
        Intrinsics.checkNotNullParameter(imports, "imports");
        this.packageName = packageName2;
        this.resolvedNames$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> FullQualifiedNameGuesser.resolvedNames_delegate$lambda$4(imports));
        this.starImports$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> FullQualifiedNameGuesser.starImports_delegate$lambda$7(imports));
    }

    public FullQualifiedNameGuesser(@NotNull KtFile root) {
        String string2;
        Intrinsics.checkNotNullParameter(root, "root");
        FullQualifiedNameGuesser fullQualifiedNameGuesser = this;
        Object object = root.getPackageDirective();
        if (object != null && (object = ((KtPackageDirective)object).getQualifiedName()) != null) {
            CharSequence charSequence;
            CharSequence charSequence2 = (CharSequence)object;
            if (StringsKt.isBlank(charSequence2)) {
                FullQualifiedNameGuesser fullQualifiedNameGuesser2 = fullQualifiedNameGuesser;
                boolean bl = false;
                charSequence = null;
                fullQualifiedNameGuesser = fullQualifiedNameGuesser2;
            } else {
                charSequence = charSequence2;
            }
            string2 = (String)charSequence;
        } else {
            string2 = null;
        }
        KtImportList ktImportList = root.getImportList();
        List<KtImportDirective> list = ktImportList != null ? ktImportList.getImports() : null;
        if (list == null) {
            list = kotlin.collections.CollectionsKt.emptyList();
        }
        fullQualifiedNameGuesser(string2, list);
    }

    private final Map<String, String> getResolvedNames() {
        Lazy lazy = this.resolvedNames$delegate;
        return (Map)lazy.getValue();
    }

    private final List<String> getStarImports() {
        Lazy lazy = this.starImports$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public final Set<String> getFullQualifiedName(@NotNull String name2) {
        Set set;
        Intrinsics.checkNotNullParameter(name2, "name");
        String resolvedName = this.findName(name2);
        if (resolvedName != null) {
            set = SetsKt.setOf(resolvedName);
        } else {
            Set set2;
            Set $this$getFullQualifiedName_u24lambda_u249 = set2 = (Set)new LinkedHashSet();
            boolean bl = false;
            CollectionsKt.addIfNotNull($this$getFullQualifiedName_u24lambda_u249, KotlinNoImportClassesKt.getDefaultImportClasses().get(name2));
            if (this.packageName != null) {
                $this$getFullQualifiedName_u24lambda_u249.add(this.packageName + '.' + name2);
            }
            if (Character.isLowerCase(StringsKt.first(name2))) {
                $this$getFullQualifiedName_u24lambda_u249.add(name2);
            }
            Iterable $this$forEach$iv = this.getStarImports();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                $this$getFullQualifiedName_u24lambda_u249.add(it + '.' + name2);
            }
            set = set2;
        }
        return set;
    }

    private final String findName(String name2) {
        String searchName = StringsKt.substringBefore$default(name2, '.', null, 2, null);
        String string2 = this.getResolvedNames().get(searchName);
        if (string2 == null) {
            return null;
        }
        String resolvedName = string2;
        return Intrinsics.areEqual(name2, searchName) ? resolvedName : resolvedName + '.' + StringsKt.substringAfter$default(name2, '.', null, 2, null);
    }

    private static final boolean resolvedNames_delegate$lambda$4$lambda$1(KtImportDirective it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isAllUnder();
    }

    private static final Pair resolvedNames_delegate$lambda$4$lambda$3(KtImportDirective ktImportDirective) {
        Pair<Object, Object> pair;
        Intrinsics.checkNotNullParameter(ktImportDirective, "import");
        Object object = ktImportDirective.getImportedFqName();
        if (object != null && (object = ((FqName)object).toString()) != null) {
            Object fqImport = object;
            boolean bl = false;
            Object object2 = ktImportDirective.getAlias();
            if (object2 == null || (object2 = ((KtImportAlias)object2).getName()) == null) {
                object2 = StringsKt.substringAfterLast$default((String)fqImport, '.', null, 2, null);
            }
            pair = TuplesKt.to(object2, fqImport);
        } else {
            pair = null;
        }
        return pair;
    }

    private static final Map resolvedNames_delegate$lambda$4(List $imports) {
        return MapsKt.toMap(SequencesKt.mapNotNull(SequencesKt.filterNot(kotlin.collections.CollectionsKt.asSequence($imports), FullQualifiedNameGuesser::resolvedNames_delegate$lambda$4$lambda$1), FullQualifiedNameGuesser::resolvedNames_delegate$lambda$4$lambda$3));
    }

    private static final boolean starImports_delegate$lambda$7$lambda$5(KtImportDirective it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isAllUnder();
    }

    private static final String starImports_delegate$lambda$7$lambda$6(KtImportDirective ktImportDirective) {
        Intrinsics.checkNotNullParameter(ktImportDirective, "import");
        FqName fqName = ktImportDirective.getImportedFqName();
        return fqName != null ? fqName.toString() : null;
    }

    private static final List starImports_delegate$lambda$7(List $imports) {
        return SequencesKt.toList(SequencesKt.mapNotNull(SequencesKt.filter(kotlin.collections.CollectionsKt.asSequence($imports), FullQualifiedNameGuesser::starImports_delegate$lambda$7$lambda$5), FullQualifiedNameGuesser::starImports_delegate$lambda$7$lambda$6));
    }
}

