/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.report.xml;

import io.github.detekt.report.xml.Xml10EscapeSymbolsInitializer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/github/detekt/report/xml/XmlEscape;", "", "<init>", "()V", "REFERENCE_HEXA_PREFIX", "", "REFERENCE_SUFFIX", "", "escapeXml", "", "text", "detekt-report-xml"})
public final class XmlEscape {
    @NotNull
    public static final XmlEscape INSTANCE = new XmlEscape();
    @NotNull
    private static final char[] REFERENCE_HEXA_PREFIX;
    private static final char REFERENCE_SUFFIX = ';';

    private XmlEscape() {
    }

    @NotNull
    public final String escapeXml(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        Xml10EscapeSymbolsInitializer.XmlEscapeSymbols symbols2 = Xml10EscapeSymbolsInitializer.INSTANCE.initializeXml10();
        byte level = 2;
        StringBuilder strBuilder = null;
        int offset2 = 0;
        int max = text.length();
        int readOffset = offset2;
        int i2 = offset2;
        while (i2 < max) {
            int codepoint = Character.codePointAt(text, i2);
            boolean codepointValid = symbols2.getCODEPOINT_VALIDATOR().isValid(codepoint);
            if (codepoint <= 159 && level < symbols2.getESCAPE_LEVELS()[codepoint] && codepointValid) {
                ++i2;
                continue;
            }
            if (codepoint > 159 && level < symbols2.getESCAPE_LEVELS()[160] && codepointValid) {
                if (Character.charCount(codepoint) > 1) {
                    ++i2;
                }
                ++i2;
                continue;
            }
            if (strBuilder == null) {
                strBuilder = new StringBuilder(max + 20);
            }
            if (i2 - readOffset > 0) {
                strBuilder.append(text, readOffset, i2);
            }
            if (Character.charCount(codepoint) > 1) {
                ++i2;
            }
            readOffset = i2 + 1;
            if (!codepointValid) {
                ++i2;
                continue;
            }
            int codepointIndex = ArraysKt.binarySearch$default(symbols2.getSORTED_CODEPOINTS(), codepoint, 0, 0, 6, null);
            if (codepointIndex >= 0) {
                strBuilder.append(symbols2.getSORTED_CERS_BY_CODEPOINT()[codepointIndex]);
                ++i2;
                continue;
            }
            strBuilder.append(REFERENCE_HEXA_PREFIX);
            strBuilder.append(Integer.toHexString(codepoint));
            strBuilder.append(';');
            ++i2;
        }
        if (strBuilder == null) {
            return text;
        }
        if (max - readOffset > 0) {
            strBuilder.append(text, readOffset, max);
        }
        String string2 = strBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    static {
        char[] cArray = "&#x".toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
        REFERENCE_HEXA_PREFIX = cArray;
    }
}

