/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.api;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0016\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\f\u0012\u0006\u0010\u0006\u001a\u00020\f\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\rJ\u0006\u0010\u0015\u001a\u00020\fJ\u0006\u0010\u0016\u001a\u00020\fJ\f\u0010\u0017\u001a\u00020\f*\u00020\u0005H\u0002J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J;\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\b2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0013R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006\""}, d2={"Lio/gitlab/arturbosch/detekt/api/Metric;", "", "type", "", "value", "", "threshold", "isDouble", "", "conversionFactor", "<init>", "(Ljava/lang/String;IIZI)V", "", "(Ljava/lang/String;DDI)V", "getType", "()Ljava/lang/String;", "getValue", "()I", "getThreshold", "()Z", "getConversionFactor", "doubleValue", "doubleThreshold", "convertAsDouble", "toString", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "detekt-api"})
public final class Metric {
    @NotNull
    private final String type;
    private final int value;
    private final int threshold;
    private final boolean isDouble;
    private final int conversionFactor;

    public Metric(@NotNull String type2, int value2, int threshold, boolean isDouble, int conversionFactor) {
        Intrinsics.checkNotNullParameter(type2, "type");
        this.type = type2;
        this.value = value2;
        this.threshold = threshold;
        this.isDouble = isDouble;
        this.conversionFactor = conversionFactor;
    }

    public /* synthetic */ Metric(String string2, int n, int n2, boolean bl, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 8) != 0) {
            bl = false;
        }
        if ((n4 & 0x10) != 0) {
            n3 = 100;
        }
        this(string2, n, n2, bl, n3);
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    public final int getValue() {
        return this.value;
    }

    public final int getThreshold() {
        return this.threshold;
    }

    public final boolean isDouble() {
        return this.isDouble;
    }

    public final int getConversionFactor() {
        return this.conversionFactor;
    }

    public Metric(@NotNull String type2, double value2, double threshold, int conversionFactor) {
        Intrinsics.checkNotNullParameter(type2, "type");
        this(type2, (int)(value2 * (double)conversionFactor), (int)(threshold * (double)conversionFactor), true, conversionFactor);
    }

    public /* synthetic */ Metric(String string2, double d, double d2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 100;
        }
        this(string2, d, d2, n);
    }

    public final double doubleValue() {
        return this.convertAsDouble(this.value);
    }

    public final double doubleThreshold() {
        return this.convertAsDouble(this.threshold);
    }

    private final double convertAsDouble(int $this$convertAsDouble) {
        if (!this.isDouble) {
            throw new IllegalStateException("This metric was not marked as double!".toString());
        }
        return (double)$this$convertAsDouble / (double)this.conversionFactor;
    }

    @NotNull
    public String toString() {
        return this.isDouble ? "" + this.doubleValue() + '/' + this.doubleThreshold() : "" + this.value + '/' + this.threshold;
    }

    @NotNull
    public final String component1() {
        return this.type;
    }

    public final int component2() {
        return this.value;
    }

    public final int component3() {
        return this.threshold;
    }

    public final boolean component4() {
        return this.isDouble;
    }

    public final int component5() {
        return this.conversionFactor;
    }

    @NotNull
    public final Metric copy(@NotNull String type2, int value2, int threshold, boolean isDouble, int conversionFactor) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return new Metric(type2, value2, threshold, isDouble, conversionFactor);
    }

    public static /* synthetic */ Metric copy$default(Metric metric, String string2, int n, int n2, boolean bl, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            string2 = metric.type;
        }
        if ((n4 & 2) != 0) {
            n = metric.value;
        }
        if ((n4 & 4) != 0) {
            n2 = metric.threshold;
        }
        if ((n4 & 8) != 0) {
            bl = metric.isDouble;
        }
        if ((n4 & 0x10) != 0) {
            n3 = metric.conversionFactor;
        }
        return metric.copy(string2, n, n2, bl, n3);
    }

    public int hashCode() {
        int result2 = this.type.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.value);
        result2 = result2 * 31 + Integer.hashCode(this.threshold);
        result2 = result2 * 31 + Boolean.hashCode(this.isDouble);
        result2 = result2 * 31 + Integer.hashCode(this.conversionFactor);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Metric)) {
            return false;
        }
        Metric metric = (Metric)other;
        if (!Intrinsics.areEqual(this.type, metric.type)) {
            return false;
        }
        if (this.value != metric.value) {
            return false;
        }
        if (this.threshold != metric.threshold) {
            return false;
        }
        if (this.isDouble != metric.isDouble) {
            return false;
        }
        return this.conversionFactor == metric.conversionFactor;
    }
}

