/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/cli/ReportPath;", "", "kind", "", "path", "Ljava/nio/file/Path;", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;)V", "getKind", "()Ljava/lang/String;", "getPath", "()Ljava/nio/file/Path;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "detekt-cli"})
public final class ReportPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String kind;
    @NotNull
    private final Path path;
    private static final int NUM_OF_PARTS_UNIX = 2;
    private static final int NUM_OF_PARTS_WINDOWS = 3;
    @NotNull
    private static final String REPORT_PATH_SEPARATOR = ":";

    public ReportPath(@NotNull String kind, @NotNull Path path) {
        Intrinsics.checkNotNullParameter(kind, "kind");
        Intrinsics.checkNotNullParameter(path, "path");
        this.kind = kind;
        this.path = path;
    }

    @NotNull
    public final String getKind() {
        return this.kind;
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @NotNull
    public final String component1() {
        return this.kind;
    }

    @NotNull
    public final Path component2() {
        return this.path;
    }

    @NotNull
    public final ReportPath copy(@NotNull String kind, @NotNull Path path) {
        Intrinsics.checkNotNullParameter(kind, "kind");
        Intrinsics.checkNotNullParameter(path, "path");
        return new ReportPath(kind, path);
    }

    public static /* synthetic */ ReportPath copy$default(ReportPath reportPath, String string2, Path path, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = reportPath.kind;
        }
        if ((n & 2) != 0) {
            path = reportPath.path;
        }
        return reportPath.copy(string2, path);
    }

    @NotNull
    public String toString() {
        return "ReportPath(kind=" + this.kind + ", path=" + this.path + ')';
    }

    public int hashCode() {
        int result2 = this.kind.hashCode();
        result2 = result2 * 31 + ((Object)this.path).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ReportPath)) {
            return false;
        }
        ReportPath reportPath = (ReportPath)other;
        if (!Intrinsics.areEqual(this.kind, reportPath.kind)) {
            return false;
        }
        return Intrinsics.areEqual(this.path, reportPath.path);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/gitlab/arturbosch/detekt/cli/ReportPath$Companion;", "", "<init>", "()V", "NUM_OF_PARTS_UNIX", "", "NUM_OF_PARTS_WINDOWS", "REPORT_PATH_SEPARATOR", "", "from", "Lio/gitlab/arturbosch/detekt/cli/ReportPath;", "input", "detekt-cli"})
    @SourceDebugExtension(value={"SMAP\nReportPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReportPath.kt\nio/gitlab/arturbosch/detekt/cli/ReportPath$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,31:1\n1#2:32\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReportPath from(@NotNull String input2) {
            String string2;
            Intrinsics.checkNotNullParameter(input2, "input");
            String[] stringArray = new String[]{ReportPath.REPORT_PATH_SEPARATOR};
            List parts = StringsKt.split$default((CharSequence)input2, stringArray, false, 0, 6, null);
            int partsSize = parts.size();
            switch (partsSize) {
                case 2: {
                    string2 = (String)parts.get(1);
                    break;
                }
                case 3: {
                    string2 = CollectionsKt.joinToString$default(CollectionsKt.slice(parts, RangesKt.until(1, partsSize)), ReportPath.REPORT_PATH_SEPARATOR, null, null, 0, null, null, 62, null);
                    break;
                }
                default: {
                    throw new IllegalStateException(("Input '" + input2 + "' must consist of two parts for Unix OSs or three for Windows (report-id:path).").toString());
                }
            }
            String path = string2;
            String kind = (String)parts.get(0);
            if (!(((CharSequence)kind).length() > 0)) {
                boolean $i$a$-require-ReportPath$Companion$from$32 = false;
                String $i$a$-require-ReportPath$Companion$from$32 = "The kind of report must not be empty (path - " + path + ')';
                throw new IllegalArgumentException($i$a$-require-ReportPath$Companion$from$32.toString());
            }
            if (!(((CharSequence)path).length() > 0)) {
                boolean bl = false;
                String string3 = "The path of the report must not be empty (kind - " + kind + ')';
                throw new IllegalArgumentException(string3.toString());
            }
            Path path2 = Paths.get(path, new String[0]);
            Intrinsics.checkNotNullExpressionValue(path2, "get(...)");
            return new ReportPath(kind, path2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

