/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core;

import io.gitlab.arturbosch.detekt.core.BindingContextKt;
import io.gitlab.arturbosch.detekt.core.DetektMessageCollector;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.NoScopeRecordCliBindingTrace;
import org.jetbrains.kotlin.cli.jvm.compiler.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\u001aF\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0018\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b\u0012\u0004\u0012\u00020\f0\nH\u0000\u00a8\u0006\r"}, d2={"generateBindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "classpath", "", "", "files", "Lorg/jetbrains/kotlin/psi/KtFile;", "debugPrinter", "Lkotlin/Function1;", "Lkotlin/Function0;", "", "detekt-core"})
public final class BindingContextKt {
    @NotNull
    public static final BindingContext generateBindingContext(@NotNull KotlinCoreEnvironment environment, @NotNull List<String> classpath, @NotNull List<? extends KtFile> files2, @NotNull Function1<? super Function0<String>, Unit> debugPrinter) {
        Intrinsics.checkNotNullParameter(environment, "environment");
        Intrinsics.checkNotNullParameter(classpath, "classpath");
        Intrinsics.checkNotNullParameter(files2, "files");
        Intrinsics.checkNotNullParameter(debugPrinter, "debugPrinter");
        if (classpath.isEmpty()) {
            BindingContext bindingContext = BindingContext.EMPTY;
            Intrinsics.checkNotNullExpressionValue(bindingContext, "EMPTY");
            return bindingContext;
        }
        DetektMessageCollector messageCollector = new DetektMessageCollector(CompilerMessageSeverity.ERROR, debugPrinter);
        AnalyzerWithCompilerReport analyzer2 = new AnalyzerWithCompilerReport(messageCollector, CommonConfigurationKeysKt.getLanguageVersionSettings(environment.getConfiguration()), false);
        analyzer2.analyzeAndReport((Collection<? extends KtFile>)files2, () -> BindingContextKt.generateBindingContext$lambda$0(environment, files2));
        return analyzer2.getAnalysisResult().getBindingContext();
    }

    private static final AnalysisResult generateBindingContext$lambda$0(KotlinCoreEnvironment $environment, List $files) {
        return TopDownAnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration$default($environment.getProject(), $files, new NoScopeRecordCliBindingTrace($environment.getProject()), $environment.getConfiguration(), new Function1<GlobalSearchScope, JvmPackagePartProvider>((Object)$environment){

            public final JvmPackagePartProvider invoke(GlobalSearchScope p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ((KotlinCoreEnvironment)this.receiver).createPackagePartProvider(p0);
            }
        }, generateBindingContext.1.2.INSTANCE, null, null, null, null, null, 1984, null);
    }
}

