/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.baseline;

import io.github.detekt.tooling.api.Baseline;
import io.github.detekt.tooling.api.BaselineProvider;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.core.baseline.BaselineHandler;
import io.gitlab.arturbosch.detekt.core.baseline.DefaultBaseline;
import io.gitlab.arturbosch.detekt.core.baseline.DefaultBaselineKt;
import io.gitlab.arturbosch.detekt.core.baseline.XmlExtensionsKt;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J,\u0010\u000f\u001a\u00020\u00102\u0010\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\u000b0\u0012j\u0002`\u00132\u0010\u0010\u0014\u001a\f\u0012\u0004\u0012\u00020\u000b0\u0012j\u0002`\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0014\u0010\u001d\u001a\u00020\u0019*\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R$\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006 "}, d2={"Lio/gitlab/arturbosch/detekt/core/baseline/BaselineFormat;", "Lio/github/detekt/tooling/api/BaselineProvider;", "<init>", "()V", "positions", "Lkotlin/Pair;", "", "Ljavax/xml/stream/XMLStreamException;", "getPositions", "(Ljavax/xml/stream/XMLStreamException;)Lkotlin/Pair;", "id", "", "Lio/github/detekt/tooling/api/FindingId;", "finding", "Lio/gitlab/arturbosch/detekt/api/Finding;", "of", "Lio/gitlab/arturbosch/detekt/core/baseline/DefaultBaseline;", "manuallySuppressedIssues", "", "Lio/github/detekt/tooling/api/FindingsIdList;", "currentIssues", "read", "sourcePath", "Ljava/nio/file/Path;", "write", "", "targetPath", "baseline", "Lio/github/detekt/tooling/api/Baseline;", "save", "Ljavax/xml/stream/XMLStreamWriter;", "InvalidState", "detekt-core"})
@SourceDebugExtension(value={"SMAP\nBaselineFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaselineFormat.kt\nio/gitlab/arturbosch/detekt/core/baseline/BaselineFormat\n+ 2 XmlExtensions.kt\nio/gitlab/arturbosch/detekt/core/baseline/XmlExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n20#2,11:81\n37#2,3:92\n37#2,3:95\n40#2,2:100\n37#2,3:102\n40#2,2:107\n40#2,2:109\n31#2,2:111\n1863#3,2:98\n1863#3,2:105\n*S KotlinDebug\n*F\n+ 1 BaselineFormat.kt\nio/gitlab/arturbosch/detekt/core/baseline/BaselineFormat\n*L\n59#1:81,11\n60#1:92,3\n64#1:95,3\n64#1:100,2\n72#1:102,3\n72#1:107,2\n60#1:109,2\n59#1:111,2\n65#1:98,2\n73#1:105,2\n*E\n"})
public final class BaselineFormat
implements BaselineProvider {
    private final Pair<Integer, Integer> getPositions(XMLStreamException $this$positions) {
        return TuplesKt.to($this$positions.getLocation().getLineNumber(), $this$positions.getLocation().getColumnNumber());
    }

    @Override
    @NotNull
    public String id(@NotNull Finding finding) {
        Intrinsics.checkNotNullParameter(finding, "finding");
        return DefaultBaselineKt.getBaselineId(finding);
    }

    @Override
    @NotNull
    public DefaultBaseline of(@NotNull Set<String> manuallySuppressedIssues, @NotNull Set<String> currentIssues) {
        Intrinsics.checkNotNullParameter(manuallySuppressedIssues, "manuallySuppressedIssues");
        Intrinsics.checkNotNullParameter(currentIssues, "currentIssues");
        return new DefaultBaseline(manuallySuppressedIssues, currentIssues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public DefaultBaseline read(@NotNull Path sourcePath) {
        Intrinsics.checkNotNullParameter(sourcePath, "sourcePath");
        try {
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(sourcePath, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue(inputStream, "newInputStream(...)");
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                SAXParserFactory sAXParserFactory;
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                SAXParserFactory $this$read_u24lambda_u241_u24lambda_u240 = sAXParserFactory = SAXParserFactory.newInstance();
                boolean bl2 = false;
                $this$read_u24lambda_u241_u24lambda_u240.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                SAXParser reader = sAXParserFactory.newSAXParser();
                BaselineHandler handler2 = new BaselineHandler();
                reader.parse(it, (DefaultHandler)handler2);
                DefaultBaseline defaultBaseline = handler2.createBaseline$detekt_core();
                return defaultBaseline;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (SAXParseException error) {
            Pair<Integer, Integer> pair = TuplesKt.to(error.getLineNumber(), error.getColumnNumber());
            int line = ((Number)pair.component1()).intValue();
            int column = ((Number)pair.component2()).intValue();
            throw new InvalidState("Error on position " + line + ':' + column + " while reading the baseline xml file!", error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull Path targetPath, @NotNull Baseline baseline) {
        Intrinsics.checkNotNullParameter(targetPath, "targetPath");
        Intrinsics.checkNotNullParameter(baseline, "baseline");
        try {
            Object object = targetPath;
            OpenOption[] openOptionArray = new OpenOption[]{};
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            object = XmlExtensionsKt.addFinalNewLine(new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n));
            object2 = null;
            try {
                Object it = (Writer)object;
                boolean bl = false;
                this.save(XmlExtensionsKt.prettyPrinter(XmlExtensionsKt.streamXml((Writer)it)), baseline);
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                object2 = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        catch (XMLStreamException error) {
            Pair<Integer, Integer> pair = this.getPositions(error);
            int line = ((Number)pair.component1()).intValue();
            int column = ((Number)pair.component2()).intValue();
            throw new InvalidState("Error on position " + line + ':' + column + " while writing the baseline xml file!", error);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void save(XMLStreamWriter $this$save, Baseline baseline) {
        String it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        void $this$tag_u24lambda_u241$iv;
        void $this$tag$iv;
        void var23_23;
        boolean $i$f$tag;
        String name$iv;
        void $this$tag$iv2;
        void var15_15;
        XMLStreamWriter xMLStreamWriter;
        XMLStreamWriter $this$document_u24default$iv = $this$save;
        Object version$iv = null;
        Object encoding$iv = null;
        boolean $i$f$document = false;
        XMLStreamWriter $this$document_u24lambda_u240$iv = xMLStreamWriter = $this$document_u24default$iv;
        boolean bl = false;
        $this$document_u24lambda_u240$iv.writeStartDocument();
        XMLStreamWriter $this$save_u24lambda_u248 = $this$document_u24lambda_u240$iv;
        boolean bl2 = false;
        XMLStreamWriter xMLStreamWriter2 = $this$save_u24lambda_u248;
        String name$iv2 = "SmellBaseline";
        boolean $i$f$tag2 = false;
        void $this$tag_u24lambda_u241$iv2 = var15_15 = $this$tag$iv2;
        boolean bl3 = false;
        $this$tag_u24lambda_u241$iv2.writeStartElement(name$iv2);
        void $this$save_u24lambda_u248_u24lambda_u247 = $this$tag_u24lambda_u241$iv2;
        boolean bl4 = false;
        if (baseline.getManuallySuppressedIssues().isEmpty()) {
            $this$save_u24lambda_u248_u24lambda_u247.writeEmptyElement("ManuallySuppressedIssues");
        } else {
            void var20_20 = $this$save_u24lambda_u248_u24lambda_u247;
            name$iv = "ManuallySuppressedIssues";
            $i$f$tag = false;
            $this$tag_u24lambda_u241$iv = var23_23 = $this$tag$iv;
            $i$a$-apply-XmlExtensionsKt$tag$1$iv = false;
            $this$tag_u24lambda_u241$iv.writeStartElement(name$iv);
            void $this$save_u24lambda_u248_u24lambda_u247_u24lambda_u244 = $this$tag_u24lambda_u241$iv;
            boolean bl5 = false;
            $this$forEach$iv = baseline.getManuallySuppressedIssues();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl6 = false;
                XmlExtensionsKt.tag((XMLStreamWriter)$this$save_u24lambda_u248_u24lambda_u247_u24lambda_u244, "ID", it);
            }
            $this$tag_u24lambda_u241$iv.writeEndElement();
        }
        if (baseline.getCurrentIssues().isEmpty()) {
            $this$save_u24lambda_u248_u24lambda_u247.writeEmptyElement("CurrentIssues");
        } else {
            $this$tag$iv = $this$save_u24lambda_u248_u24lambda_u247;
            name$iv = "CurrentIssues";
            $i$f$tag = false;
            $this$tag_u24lambda_u241$iv = var23_23 = $this$tag$iv;
            $i$a$-apply-XmlExtensionsKt$tag$1$iv = false;
            $this$tag_u24lambda_u241$iv.writeStartElement(name$iv);
            void $this$save_u24lambda_u248_u24lambda_u247_u24lambda_u246 = $this$tag_u24lambda_u241$iv;
            boolean bl7 = false;
            $this$forEach$iv = baseline.getCurrentIssues();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl8 = false;
                XmlExtensionsKt.tag((XMLStreamWriter)$this$save_u24lambda_u248_u24lambda_u247_u24lambda_u246, "ID", it);
            }
            $this$tag_u24lambda_u241$iv.writeEndElement();
        }
        $this$tag_u24lambda_u241$iv2.writeEndElement();
        $this$document_u24lambda_u240$iv.writeEndDocument();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lio/gitlab/arturbosch/detekt/core/baseline/BaselineFormat$InvalidState;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "msg", "", "error", "", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "detekt-core"})
    public static final class InvalidState
    extends IllegalStateException {
        public InvalidState(@NotNull String msg, @NotNull Throwable error) {
            Intrinsics.checkNotNullParameter(msg, "msg");
            Intrinsics.checkNotNullParameter(error, "error");
            super(msg, error);
        }
    }
}

