/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.config;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Notification;
import io.gitlab.arturbosch.detekt.core.config.validation.ConfigValidationKt;
import io.gitlab.arturbosch.detekt.core.config.validation.ValidatableConfiguration;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J'\u0010\u000f\u001a\u0002H\u0010\"\b\b\u0000\u0010\u0010*\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u0002H\u0010H\u0016\u00a2\u0006\u0002\u0010\u0013J!\u0010\u0014\u001a\u0004\u0018\u0001H\u0010\"\b\b\u0000\u0010\u0010*\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\u0015J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u00012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0006H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\t\u0010\u001e\u001a\u00020\u0001H\u00c2\u0003J\t\u0010\u001f\u001a\u00020\u0001H\u00c2\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c2\u0003J-\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u00012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\"\u001a\u00020\u001d2\b\u0010#\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020\u0007H\u00d6\u0001R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006'"}, d2={"Lio/gitlab/arturbosch/detekt/core/config/AllRulesConfig;", "Lio/gitlab/arturbosch/detekt/api/Config;", "Lio/gitlab/arturbosch/detekt/core/config/validation/ValidatableConfiguration;", "originalConfig", "defaultConfig", "deprecatedRuleIds", "", "", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;Lio/gitlab/arturbosch/detekt/api/Config;Ljava/util/Set;)V", "parentPath", "getParentPath", "()Ljava/lang/String;", "subConfig", "key", "valueOrDefault", "T", "", "default", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "valueOrNull", "(Ljava/lang/String;)Ljava/lang/Object;", "validate", "", "Lio/gitlab/arturbosch/detekt/api/Notification;", "baseline", "excludePatterns", "Lkotlin/text/Regex;", "isDeprecated", "", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "detekt-core"})
@SourceDebugExtension(value={"SMAP\nAllRulesConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AllRulesConfig.kt\nio/gitlab/arturbosch/detekt/core/config/AllRulesConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n1#2:46\n*E\n"})
public final class AllRulesConfig
implements Config,
ValidatableConfiguration {
    @NotNull
    private final Config originalConfig;
    @NotNull
    private final Config defaultConfig;
    @NotNull
    private final Set<String> deprecatedRuleIds;

    public AllRulesConfig(@NotNull Config originalConfig, @NotNull Config defaultConfig, @NotNull Set<String> deprecatedRuleIds) {
        Intrinsics.checkNotNullParameter(originalConfig, "originalConfig");
        Intrinsics.checkNotNullParameter(defaultConfig, "defaultConfig");
        Intrinsics.checkNotNullParameter(deprecatedRuleIds, "deprecatedRuleIds");
        this.originalConfig = originalConfig;
        this.defaultConfig = defaultConfig;
        this.deprecatedRuleIds = deprecatedRuleIds;
    }

    public /* synthetic */ AllRulesConfig(Config config, Config config2, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        this(config, config2, set);
    }

    @Override
    @Nullable
    public String getParentPath() {
        String string2 = this.originalConfig.getParentPath();
        if (string2 == null) {
            string2 = this.defaultConfig.getParentPath();
        }
        return string2;
    }

    @Override
    @NotNull
    public AllRulesConfig subConfig(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return new AllRulesConfig(this.originalConfig.subConfig(key), this.defaultConfig.subConfig(key), this.deprecatedRuleIds);
    }

    @Override
    @NotNull
    public <T> T valueOrDefault(@NotNull String key, @NotNull T t) {
        Object object;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(t, "default");
        if (Intrinsics.areEqual(key, "active")) {
            if (this.isDeprecated()) {
                object = false;
            } else {
                Boolean bl = this.originalConfig.valueOrDefault(key, true);
                object = bl;
                Intrinsics.checkNotNull(bl, "null cannot be cast to non-null type T of io.gitlab.arturbosch.detekt.core.config.AllRulesConfig.valueOrDefault");
            }
        } else {
            object = this.originalConfig.valueOrDefault(key, this.defaultConfig.valueOrDefault(key, t));
        }
        return (T)object;
    }

    @Override
    @Nullable
    public <T> T valueOrNull(@NotNull String key) {
        Object object;
        Intrinsics.checkNotNullParameter(key, "key");
        if (Intrinsics.areEqual(key, "active")) {
            if (this.isDeprecated()) {
                object = false;
            } else {
                object = this.originalConfig.valueOrNull(key);
                if (object == null) {
                    object = true;
                }
            }
        } else {
            object = this.originalConfig.valueOrNull(key);
            if (object == null) {
                object = this.defaultConfig.valueOrNull(key);
            }
        }
        return object;
    }

    @Override
    @NotNull
    public List<Notification> validate(@NotNull Config baseline, @NotNull Set<Regex> excludePatterns) {
        Intrinsics.checkNotNullParameter(baseline, "baseline");
        Intrinsics.checkNotNullParameter(excludePatterns, "excludePatterns");
        return ConfigValidationKt.validateConfig(this.originalConfig, baseline, excludePatterns);
    }

    private final boolean isDeprecated() {
        boolean bl;
        String string2 = this.getParentPath();
        if (string2 != null) {
            String it = string2;
            boolean bl2 = false;
            bl = this.deprecatedRuleIds.contains(it);
        } else {
            bl = false;
        }
        return bl;
    }

    private final Config component1() {
        return this.originalConfig;
    }

    private final Config component2() {
        return this.defaultConfig;
    }

    private final Set<String> component3() {
        return this.deprecatedRuleIds;
    }

    @NotNull
    public final AllRulesConfig copy(@NotNull Config originalConfig, @NotNull Config defaultConfig, @NotNull Set<String> deprecatedRuleIds) {
        Intrinsics.checkNotNullParameter(originalConfig, "originalConfig");
        Intrinsics.checkNotNullParameter(defaultConfig, "defaultConfig");
        Intrinsics.checkNotNullParameter(deprecatedRuleIds, "deprecatedRuleIds");
        return new AllRulesConfig(originalConfig, defaultConfig, deprecatedRuleIds);
    }

    public static /* synthetic */ AllRulesConfig copy$default(AllRulesConfig allRulesConfig, Config config, Config config2, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            config = allRulesConfig.originalConfig;
        }
        if ((n & 2) != 0) {
            config2 = allRulesConfig.defaultConfig;
        }
        if ((n & 4) != 0) {
            set = allRulesConfig.deprecatedRuleIds;
        }
        return allRulesConfig.copy(config, config2, set);
    }

    @NotNull
    public String toString() {
        return "AllRulesConfig(originalConfig=" + this.originalConfig + ", defaultConfig=" + this.defaultConfig + ", deprecatedRuleIds=" + this.deprecatedRuleIds + ')';
    }

    public int hashCode() {
        int result2 = this.originalConfig.hashCode();
        result2 = result2 * 31 + this.defaultConfig.hashCode();
        result2 = result2 * 31 + ((Object)this.deprecatedRuleIds).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AllRulesConfig)) {
            return false;
        }
        AllRulesConfig allRulesConfig = (AllRulesConfig)other;
        if (!Intrinsics.areEqual(this.originalConfig, allRulesConfig.originalConfig)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.defaultConfig, allRulesConfig.defaultConfig)) {
            return false;
        }
        return Intrinsics.areEqual(this.deprecatedRuleIds, allRulesConfig.deprecatedRuleIds);
    }
}

