/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.config;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Notification;
import io.gitlab.arturbosch.detekt.core.config.validation.ConfigValidationKt;
import io.gitlab.arturbosch.detekt.core.config.validation.ValidatableConfiguration;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\bH\u0016J'\u0010\r\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u0002H\u000eH\u0016\u00a2\u0006\u0002\u0010\u0011J!\u0010\u0012\u001a\u0004\u0018\u0001H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f2\u0006\u0010\f\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\bH\u0016J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lio/gitlab/arturbosch/detekt/core/config/CompositeConfig;", "Lio/gitlab/arturbosch/detekt/api/Config;", "Lio/gitlab/arturbosch/detekt/core/config/validation/ValidatableConfiguration;", "lookFirst", "lookSecond", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;Lio/gitlab/arturbosch/detekt/api/Config;)V", "parentPath", "", "getParentPath", "()Ljava/lang/String;", "subConfig", "key", "valueOrDefault", "T", "", "default", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "valueOrNull", "(Ljava/lang/String;)Ljava/lang/Object;", "toString", "validate", "", "Lio/gitlab/arturbosch/detekt/api/Notification;", "baseline", "excludePatterns", "", "Lkotlin/text/Regex;", "detekt-core"})
public final class CompositeConfig
implements Config,
ValidatableConfiguration {
    @NotNull
    private final Config lookFirst;
    @NotNull
    private final Config lookSecond;

    public CompositeConfig(@NotNull Config lookFirst, @NotNull Config lookSecond) {
        Intrinsics.checkNotNullParameter(lookFirst, "lookFirst");
        Intrinsics.checkNotNullParameter(lookSecond, "lookSecond");
        this.lookFirst = lookFirst;
        this.lookSecond = lookSecond;
    }

    @Override
    @Nullable
    public String getParentPath() {
        String string2 = this.lookFirst.getParentPath();
        if (string2 == null) {
            string2 = this.lookSecond.getParentPath();
        }
        return string2;
    }

    @Override
    @NotNull
    public Config subConfig(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return new CompositeConfig(this.lookFirst.subConfig(key), this.lookSecond.subConfig(key));
    }

    @Override
    @NotNull
    public <T> T valueOrDefault(@NotNull String key, @NotNull T t) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(t, "default");
        if (this.lookFirst.valueOrNull(key) != null) {
            return this.lookFirst.valueOrDefault(key, t);
        }
        return this.lookSecond.valueOrDefault(key, t);
    }

    @Override
    @Nullable
    public <T> T valueOrNull(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        Object t = this.lookFirst.valueOrNull(key);
        if (t == null) {
            t = this.lookSecond.valueOrNull(key);
        }
        return t;
    }

    @NotNull
    public String toString() {
        return "CompositeConfig(lookFirst=" + this.lookFirst + ", lookSecond=" + this.lookSecond + ')';
    }

    @Override
    @NotNull
    public List<Notification> validate(@NotNull Config baseline, @NotNull Set<Regex> excludePatterns) {
        Intrinsics.checkNotNullParameter(baseline, "baseline");
        Intrinsics.checkNotNullParameter(excludePatterns, "excludePatterns");
        return CollectionsKt.plus((Collection)ConfigValidationKt.validateConfig(this.lookFirst, baseline, excludePatterns), (Iterable)ConfigValidationKt.validateConfig(this.lookSecond, baseline, excludePatterns));
    }
}

