/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.config;

import io.github.detekt.tooling.api.MaxIssuesReached;
import io.github.detekt.tooling.api.spec.RulesSpec;
import io.gitlab.arturbosch.detekt.api.Config;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/core/config/MaxIssueCheck;", "", "rulesSpec", "Lio/github/detekt/tooling/api/spec/RulesSpec;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/github/detekt/tooling/api/spec/RulesSpec;Lio/gitlab/arturbosch/detekt/api/Config;)V", "policy", "Lio/github/detekt/tooling/api/spec/RulesSpec$MaxIssuePolicy;", "meetsPolicy", "", "numberOfIssues", "", "check", "", "detekt-core"})
public final class MaxIssueCheck {
    @NotNull
    private final RulesSpec rulesSpec;
    @NotNull
    private final Config config;
    @NotNull
    private final RulesSpec.MaxIssuePolicy policy;

    /*
     * WARNING - void declaration
     */
    public MaxIssueCheck(@NotNull RulesSpec rulesSpec, @NotNull Config config) {
        Integer configuredMaxIssues;
        Integer n;
        void $this$policy_u24lambda_u240;
        Intrinsics.checkNotNullParameter(rulesSpec, "rulesSpec");
        Intrinsics.checkNotNullParameter(config, "config");
        this.rulesSpec = rulesSpec;
        this.config = config;
        MaxIssueCheck maxIssueCheck = this;
        MaxIssueCheck maxIssueCheck2 = this;
        boolean bl = false;
        maxIssueCheck2.policy = Intrinsics.areEqual($this$policy_u24lambda_u240.rulesSpec.getMaxIssuePolicy(), RulesSpec.MaxIssuePolicy.NonSpecified.INSTANCE) ? ((n = (configuredMaxIssues = (Integer)$this$policy_u24lambda_u240.config.subConfig("build").valueOrNull("maxIssues"))) == null ? $this$policy_u24lambda_u240.rulesSpec.getMaxIssuePolicy() : (n == 0 ? (RulesSpec.MaxIssuePolicy)RulesSpec.MaxIssuePolicy.NoneAllowed.INSTANCE : (new IntRange(1, Integer.MAX_VALUE).contains(n) ? (RulesSpec.MaxIssuePolicy)new RulesSpec.MaxIssuePolicy.AllowAmount(configuredMaxIssues) : (RulesSpec.MaxIssuePolicy)RulesSpec.MaxIssuePolicy.AllowAny.INSTANCE))) : $this$policy_u24lambda_u240.rulesSpec.getMaxIssuePolicy();
    }

    private final boolean meetsPolicy(int numberOfIssues) {
        boolean bl;
        RulesSpec.MaxIssuePolicy maxIssuePolicy = this.policy;
        if (Intrinsics.areEqual(maxIssuePolicy, RulesSpec.MaxIssuePolicy.AllowAny.INSTANCE)) {
            bl = true;
        } else if (Intrinsics.areEqual(maxIssuePolicy, RulesSpec.MaxIssuePolicy.NoneAllowed.INSTANCE) || Intrinsics.areEqual(maxIssuePolicy, RulesSpec.MaxIssuePolicy.NonSpecified.INSTANCE)) {
            bl = numberOfIssues == 0;
        } else if (maxIssuePolicy instanceof RulesSpec.MaxIssuePolicy.AllowAmount) {
            bl = numberOfIssues <= ((RulesSpec.MaxIssuePolicy.AllowAmount)this.policy).getAmount();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public final void check(int numberOfIssues) {
        if (!this.meetsPolicy(numberOfIssues)) {
            throw new MaxIssuesReached("Analysis failed with " + numberOfIssues + " weighted issues.");
        }
    }
}

