/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.config.validation;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigValidator;
import io.gitlab.arturbosch.detekt.api.Notification;
import io.gitlab.arturbosch.detekt.api.SetupContext;
import io.gitlab.arturbosch.detekt.core.config.YamlConfig;
import io.gitlab.arturbosch.detekt.core.config.validation.ValidationSettings;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/core/config/validation/AbstractYamlConfigValidator;", "Lio/gitlab/arturbosch/detekt/api/ConfigValidator;", "<init>", "()V", "validate", "", "Lio/gitlab/arturbosch/detekt/api/Notification;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "configToValidate", "Lio/gitlab/arturbosch/detekt/core/config/YamlConfig;", "settings", "Lio/gitlab/arturbosch/detekt/core/config/validation/ValidationSettings;", "detekt-core"})
public abstract class AbstractYamlConfigValidator
implements ConfigValidator {
    @Override
    @NotNull
    public Collection<Notification> validate(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        if (!(config instanceof YamlConfig)) {
            boolean bl = false;
            String yamlConfigClass = Reflection.getOrCreateKotlinClass(YamlConfig.class).getSimpleName();
            String actualClass = config.getClass().getSimpleName();
            String string2 = "Only supported config is the " + yamlConfigClass + ". Actual type is " + actualClass;
            throw new IllegalArgumentException(string2.toString());
        }
        ValidationSettings settings = new ValidationSettings(((YamlConfig)config).subConfig("config").valueOrDefault("checkExhaustiveness", false));
        return this.validate((YamlConfig)config, settings);
    }

    @NotNull
    public abstract Collection<Notification> validate(@NotNull YamlConfig var1, @NotNull ValidationSettings var2);

    @Override
    public void init(@NotNull Config config) {
        ConfigValidator.DefaultImpls.init((ConfigValidator)this, config);
    }

    @Override
    public void init(@NotNull SetupContext context) {
        ConfigValidator.DefaultImpls.init((ConfigValidator)this, context);
    }

    @Override
    @NotNull
    public String getId() {
        return ConfigValidator.DefaultImpls.getId(this);
    }

    @Override
    public int getPriority() {
        return ConfigValidator.DefaultImpls.getPriority(this);
    }
}

