/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.config.validation;

import io.github.detekt.tooling.api.InvalidConfig;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigValidator;
import io.gitlab.arturbosch.detekt.api.Extension;
import io.gitlab.arturbosch.detekt.api.Notification;
import io.gitlab.arturbosch.detekt.api.internal.SimpleNotification;
import io.gitlab.arturbosch.detekt.core.JunkKt;
import io.gitlab.arturbosch.detekt.core.ProcessingSettings;
import io.gitlab.arturbosch.detekt.core.config.YamlConfig;
import io.gitlab.arturbosch.detekt.core.config.validation.AbstractYamlConfigValidator;
import io.gitlab.arturbosch.detekt.core.config.validation.DefaultPropertiesConfigValidator;
import io.gitlab.arturbosch.detekt.core.config.validation.DeprecatedPropertiesConfigValidator;
import io.gitlab.arturbosch.detekt.core.config.validation.DeprecationsKt;
import io.gitlab.arturbosch.detekt.core.config.validation.InvalidPropertiesConfigValidator;
import io.gitlab.arturbosch.detekt.core.config.validation.MissingRulesConfigValidator;
import io.gitlab.arturbosch.detekt.core.config.validation.ValidatableConfiguration;
import io.gitlab.arturbosch.detekt.core.extensions.LoadingKt;
import io.gitlab.arturbosch.detekt.core.reporting.ColorizerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a,\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0000\u001a,\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u00132\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u001a-\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u0015*\u0002H\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0019H\u0002\u00a2\u0006\u0002\u0010\u001a\u001a\f\u0010\u001b\u001a\u00020\u0001*\u00020\fH\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001c"}, d2={"DEFAULT_PROPERTY_EXCLUDES", "", "getDEFAULT_PROPERTY_EXCLUDES", "()Ljava/lang/String;", "checkConfiguration", "", "settings", "Lio/gitlab/arturbosch/detekt/core/ProcessingSettings;", "baseline", "Lio/gitlab/arturbosch/detekt/api/Config;", "validateConfig", "", "Lio/gitlab/arturbosch/detekt/api/Notification;", "config", "excludePatterns", "", "Lkotlin/text/Regex;", "validateYamlConfig", "configToValidate", "Lio/gitlab/arturbosch/detekt/core/config/YamlConfig;", "transformIf", "T", "condition", "", "transform", "Lkotlin/Function0;", "(Ljava/lang/Object;ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "renderMessage", "detekt-core"})
@SourceDebugExtension(value={"SMAP\nConfigValidation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigValidation.kt\nio/gitlab/arturbosch/detekt/core/config/validation/ConfigValidationKt\n+ 2 Loading.kt\nio/gitlab/arturbosch/detekt/core/extensions/LoadingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Loading.kt\nio/gitlab/arturbosch/detekt/core/extensions/LoadingKt$loadExtensions$1\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n11#2,7:120\n18#2:130\n19#2:135\n20#2,2:137\n22#2,4:141\n827#3:127\n855#3,2:128\n774#3:131\n865#3:132\n866#3:134\n1053#3:136\n2642#3:139\n1368#3:145\n1454#3,5:146\n1557#3:151\n1628#3,3:152\n1863#3,2:155\n774#3:157\n865#3,2:158\n1368#3:161\n1454#3,5:162\n1557#3:167\n1628#3,3:168\n14#4:133\n1#5:140\n1#5:160\n*S KotlinDebug\n*F\n+ 1 ConfigValidation.kt\nio/gitlab/arturbosch/detekt/core/config/validation/ConfigValidationKt\n*L\n45#1:120,7\n45#1:130\n45#1:135\n45#1:137,2\n45#1:141,4\n45#1:127\n45#1:128,2\n45#1:131\n45#1:132\n45#1:134\n45#1:136\n45#1:139\n46#1:145\n46#1:146,5\n47#1:151\n47#1:152,3\n47#1:155,2\n48#1:157\n48#1:158,2\n99#1:161\n99#1:162,5\n100#1:167\n100#1:168,3\n45#1:133\n45#1:140\n*E\n"})
public final class ConfigValidationKt {
    @NotNull
    private static final String DEFAULT_PROPERTY_EXCLUDES;

    @NotNull
    public static final String getDEFAULT_PROPERTY_EXCLUDES() {
        return DEFAULT_PROPERTY_EXCLUDES;
    }

    /*
     * WARNING - void declaration
     */
    public static final void checkConfiguration(@NotNull ProcessingSettings settings, @NotNull Config baseline) {
        Intrinsics.checkNotNullParameter(settings, "settings");
        Intrinsics.checkNotNullParameter(baseline, "baseline");
        Boolean shouldValidate = settings.getSpec().getConfigSpec().getShouldValidateBeforeAnalysis();
        if (shouldValidate == null) {
            Config props = settings.getConfig().subConfig("config");
            shouldValidate = props.valueOrDefault("validation", true);
        }
        if (shouldValidate.booleanValue()) {
            void $this$filterTo$iv$iv;
            Object element$iv2;
            void $this$forEach$iv;
            Iterator $this$mapTo$iv$iv;
            Object list$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            void $this$onEach$iv$iv;
            Iterable $this$sortedBy$iv$iv;
            void $this$filterTo$iv$iv$iv;
            Iterable $this$filter$iv$iv;
            Extension it$iv;
            void $this$filterNotTo$iv$iv$iv;
            Iterable $this$filterNot$iv$iv;
            boolean $i$f$loadExtensions = false;
            ServiceLoader<ConfigValidator> serviceLoader = ServiceLoader.load(ConfigValidator.class, settings.getPluginLoader());
            Intrinsics.checkNotNullExpressionValue(serviceLoader, "load(...)");
            Iterable iterable = serviceLoader;
            boolean $i$f$filterNot = false;
            void var8_13 = $this$filterNot$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv$iv : $this$filterNotTo$iv$iv$iv) {
                it$iv = (Extension)element$iv$iv$iv;
                boolean bl = false;
                if (settings.getSpec().getExtensionsSpec().getDisabledExtensions().contains(it$iv.getId())) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            $this$filterNot$iv$iv = (List)destination$iv$iv$iv;
            boolean $i$f$filter = false;
            $this$filterNotTo$iv$iv$iv = $this$filter$iv$iv;
            destination$iv$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv$iv;
                Object t = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Extension it = (Extension)t;
                if (!true) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            $this$filter$iv$iv = (List)destination$iv$iv$iv;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv$iv = CollectionsKt.asReversed(CollectionsKt.sortedWith($this$sortedBy$iv$iv, new Comparator(){

                public final int compare(T a2, T b2) {
                    Extension it = (Extension)a2;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPriority());
                    it = (Extension)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getPriority());
                }
            }));
            boolean $i$f$onEach = false;
            void $this$onEach_u24lambda_u2419$iv$iv = $this$filterTo$iv$iv$iv = $this$onEach$iv$iv;
            boolean $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv$iv22 = false;
            for (Object element$iv$iv : $this$onEach_u24lambda_u2419$iv$iv) {
                it$iv = (Extension)element$iv$iv;
                boolean bl = false;
                it$iv.init(settings.getConfig());
                it$iv.init(settings);
            }
            $this$onEach$iv$iv = $this$filterTo$iv$iv$iv;
            Iterable it$iv2 = (List)$this$onEach$iv$iv;
            boolean bl = false;
            settings.debug(new Function0<String>(it$iv2){
                final /* synthetic */ List<T> $it;
                {
                    this.$it = $it;
                }

                public final String invoke() {
                    return "Loaded extensions: " + LoadingKt.getLIST_ITEM_SPACING() + CollectionsKt.joinToString$default(this.$it, LoadingKt.getLIST_ITEM_SPACING(), null, null, 0, null, null, 62, null);
                }
            });
            List<DefaultPropertiesConfigValidator> validators = CollectionsKt.plus((Collection)((List)$this$onEach$iv$iv), new DefaultPropertiesConfigValidator(settings, baseline));
            Iterable $this$flatMap$iv = validators;
            boolean $i$f$flatMap = false;
            it$iv2 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ConfigValidator it = (ConfigValidator)element$iv$iv;
                boolean bl2 = false;
                list$iv$iv = it.validate(settings.getConfig());
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            List notifications = (List)destination$iv$iv;
            Iterable $this$map$iv = notifications;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv$iv22 = $this$mapTo$iv$iv.iterator();
            while ($i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv$iv22.hasNext()) {
                void p0;
                Object item$iv$iv = $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv$iv22.next();
                list$iv$iv = (Notification)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean $i$f$checkConfiguration$stub_for_inlining = false;
                boolean bl3 = false;
                collection.add(p0.getMessage());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                String p0 = (String)element$iv2;
                boolean $i$f$checkConfiguration$stub_for_inlining$1 = false;
                boolean bl4 = false;
                settings.info(p0);
            }
            Iterable $this$filter$iv = notifications;
            $i$f$filter = false;
            element$iv2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Notification p0 = (Notification)element$iv$iv;
                boolean $i$f$checkConfiguration$stub_for_inlining$2 = false;
                boolean bl5 = false;
                if (!p0.isError()) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List errors = (List)destination$iv$iv2;
            if (!((Collection)errors).isEmpty()) {
                String problems = CollectionsKt.joinToString$default(notifications, JunkKt.getNL(), null, null, 0, null, ConfigValidationKt::checkConfiguration$lambda$3, 30, null);
                String propsString = errors.size() == 1 ? "property" : "properties";
                String title2 = ColorizerKt.red("Run failed with " + errors.size() + " invalid config " + propsString + '.');
                throw new InvalidConfig(title2 + JunkKt.getNL() + problems);
            }
        }
    }

    @NotNull
    public static final List<Notification> validateConfig(@NotNull Config config, @NotNull Config baseline, @NotNull Set<Regex> excludePatterns) {
        List<Notification> list;
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(baseline, "baseline");
        Intrinsics.checkNotNullParameter(excludePatterns, "excludePatterns");
        if (!(!Intrinsics.areEqual(baseline, Config.Companion.getEmpty()))) {
            boolean $i$a$-require-ConfigValidationKt$validateConfig$32 = false;
            String $i$a$-require-ConfigValidationKt$validateConfig$32 = "Cannot validate configuration based on an empty baseline config.";
            throw new IllegalArgumentException($i$a$-require-ConfigValidationKt$validateConfig$32.toString());
        }
        if (!(baseline instanceof YamlConfig)) {
            boolean bl = false;
            String yamlConfigClass = Reflection.getOrCreateKotlinClass(YamlConfig.class).getSimpleName();
            String actualClass = baseline.getClass().getSimpleName();
            String string2 = "Only supported baseline config is the " + yamlConfigClass + ". Actual type is " + actualClass;
            throw new IllegalArgumentException(string2.toString());
        }
        if (Intrinsics.areEqual(config, Config.Companion.getEmpty())) {
            return CollectionsKt.emptyList();
        }
        Config config2 = config;
        if (config2 instanceof YamlConfig) {
            list = ConfigValidationKt.validateYamlConfig((YamlConfig)config, (YamlConfig)baseline, excludePatterns);
        } else if (config2 instanceof ValidatableConfiguration) {
            list = ((ValidatableConfiguration)((Object)config)).validate(baseline, excludePatterns);
        } else {
            throw new IllegalStateException(("Unsupported config type for validation: '" + Reflection.getOrCreateKotlinClass(config.getClass()) + "'.").toString());
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Notification> validateYamlConfig(YamlConfig configToValidate, YamlConfig baseline, Set<Regex> excludePatterns) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Map<String, String> deprecatedProperties = DeprecationsKt.loadDeprecations();
        boolean warningsAsErrors = configToValidate.subConfig("config").valueOrDefault("warningsAsErrors", false);
        Object object = new AbstractYamlConfigValidator[]{new InvalidPropertiesConfigValidator(baseline, deprecatedProperties.keySet(), excludePatterns), new DeprecatedPropertiesConfigValidator(deprecatedProperties), new MissingRulesConfigValidator(baseline, excludePatterns)};
        List<AbstractYamlConfigValidator> validators = CollectionsKt.listOf(object);
        object = validators;
        boolean $i$f$flatMap = false;
        void var8_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ConfigValidator it = (ConfigValidator)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.validate(configToValidate);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void notification;
            list$iv$iv = (Notification)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ConfigValidationKt.transformIf(notification, warningsAsErrors && notification.getLevel() == Notification.Level.Warning, () -> ConfigValidationKt.validateYamlConfig$lambda$8$lambda$7((Notification)notification)));
        }
        return (List)destination$iv$iv;
    }

    private static final <T> T transformIf(T $this$transformIf, boolean condition, Function0<? extends T> transform2) {
        return condition ? transform2.invoke() : $this$transformIf;
    }

    @NotNull
    public static final String renderMessage(@NotNull Notification $this$renderMessage) {
        String string2;
        Intrinsics.checkNotNullParameter($this$renderMessage, "<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$renderMessage.getLevel().ordinal()]) {
            case 1: {
                string2 = ColorizerKt.red($this$renderMessage.getMessage());
                break;
            }
            case 2: {
                string2 = ColorizerKt.yellow($this$renderMessage.getMessage());
                break;
            }
            case 3: {
                string2 = $this$renderMessage.getMessage();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    private static final CharSequence checkConfiguration$lambda$3(Notification it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return "\t- " + ConfigValidationKt.renderMessage(it);
    }

    private static final Notification validateYamlConfig$lambda$8$lambda$7(Notification $notification) {
        return new SimpleNotification($notification.getMessage(), Notification.Level.Error);
    }

    static {
        String[] stringArray = new String[]{".*>excludes", ".*>includes", ".*>active", ".*>.*>excludes", ".*>.*>includes", ".*>.*>active", ".*>.*>autoCorrect", ".*>severity", ".*>.*>severity", "build>weights", ".*>.*>ignoreAnnotated", ".*>.*>ignoreFunction"};
        DEFAULT_PROPERTY_EXCLUDES = CollectionsKt.joinToString$default(SetsKt.setOf(stringArray), ",", null, null, 0, null, null, 62, null);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Notification.Level.values().length];
            try {
                nArray[Notification.Level.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Notification.Level.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Notification.Level.Info.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

