/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.config.validation;

import io.gitlab.arturbosch.detekt.api.Notification;
import io.gitlab.arturbosch.detekt.api.internal.SimpleNotification;
import io.gitlab.arturbosch.detekt.core.config.YamlConfig;
import io.gitlab.arturbosch.detekt.core.config.validation.AbstractYamlConfigValidator;
import io.gitlab.arturbosch.detekt.core.config.validation.ValidationSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016JB\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\u00132\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\u00132\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0002JF\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\u00132\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/gitlab/arturbosch/detekt/core/config/validation/InvalidPropertiesConfigValidator;", "Lio/gitlab/arturbosch/detekt/core/config/validation/AbstractYamlConfigValidator;", "baseline", "Lio/gitlab/arturbosch/detekt/core/config/YamlConfig;", "deprecatedProperties", "", "", "excludePatterns", "Lkotlin/text/Regex;", "<init>", "(Lio/gitlab/arturbosch/detekt/core/config/YamlConfig;Ljava/util/Set;Ljava/util/Set;)V", "validate", "", "Lio/gitlab/arturbosch/detekt/api/Notification;", "configToValidate", "settings", "Lio/gitlab/arturbosch/detekt/core/config/validation/ValidationSettings;", "testKeys", "", "", "", "parentPath", "checkProp", "propertyName", "propertyPath", "Companion", "detekt-core"})
@SourceDebugExtension(value={"SMAP\nInvalidPropertiesConfigValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InvalidPropertiesConfigValidator.kt\nio/gitlab/arturbosch/detekt/core/config/validation/InvalidPropertiesConfigValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1755#2,3:91\n*S KotlinDebug\n*F\n+ 1 InvalidPropertiesConfigValidator.kt\nio/gitlab/arturbosch/detekt/core/config/validation/InvalidPropertiesConfigValidator\n*L\n28#1:91,3\n*E\n"})
public final class InvalidPropertiesConfigValidator
extends AbstractYamlConfigValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final YamlConfig baseline;
    @NotNull
    private final Set<String> deprecatedProperties;
    @NotNull
    private final Set<Regex> excludePatterns;

    public InvalidPropertiesConfigValidator(@NotNull YamlConfig baseline, @NotNull Set<String> deprecatedProperties, @NotNull Set<Regex> excludePatterns) {
        Intrinsics.checkNotNullParameter(baseline, "baseline");
        Intrinsics.checkNotNullParameter(deprecatedProperties, "deprecatedProperties");
        Intrinsics.checkNotNullParameter(excludePatterns, "excludePatterns");
        this.baseline = baseline;
        this.deprecatedProperties = deprecatedProperties;
        this.excludePatterns = excludePatterns;
    }

    @Override
    @NotNull
    public Collection<Notification> validate(@NotNull YamlConfig configToValidate, @NotNull ValidationSettings settings) {
        Intrinsics.checkNotNullParameter(configToValidate, "configToValidate");
        Intrinsics.checkNotNullParameter(settings, "settings");
        return InvalidPropertiesConfigValidator.testKeys$default(this, configToValidate.getProperties(), this.baseline.getProperties(), null, 4, null);
    }

    private final List<Notification> testKeys(Map<String, ? extends Object> configToValidate, Map<String, ? extends Object> baseline, String parentPath) {
        List notifications = new ArrayList();
        for (String prop : configToValidate.keySet()) {
            boolean bl;
            String propertyPath;
            block4: {
                propertyPath = (parentPath == null ? "" : parentPath + '>') + prop;
                Iterable $this$any$iv = this.excludePatterns;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Regex it = (Regex)element$iv;
                        boolean bl2 = false;
                        if (!it.matches(propertyPath)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            boolean isExcluded = bl;
            boolean isDeprecated = this.deprecatedProperties.contains(propertyPath);
            if (isExcluded || isDeprecated) continue;
            notifications.addAll((Collection)this.checkProp(prop, propertyPath, configToValidate, baseline));
        }
        return notifications;
    }

    static /* synthetic */ List testKeys$default(InvalidPropertiesConfigValidator invalidPropertiesConfigValidator, Map map2, Map map3, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return invalidPropertiesConfigValidator.testKeys(map2, map3, string2);
    }

    private final List<Notification> checkProp(String propertyName, String propertyPath, Map<String, ? extends Object> configToValidate, Map<String, ? extends Object> baseline) {
        if (!baseline.containsKey(propertyName)) {
            return CollectionsKt.listOf(Companion.propertyDoesNotExists$detekt_core(propertyPath));
        }
        if (configToValidate.get(propertyName) instanceof String && baseline.get(propertyName) instanceof List) {
            return CollectionsKt.listOf(Companion.propertyShouldBeAnArray$detekt_core(propertyPath));
        }
        Object object = configToValidate.get(propertyName);
        Map next = object instanceof Map ? (Map)object : null;
        Object object2 = baseline.get(propertyName);
        Map nextBase = object2 instanceof Map ? (Map)object2 : null;
        return next == null && nextBase != null ? CollectionsKt.listOf(Companion.nestedConfigurationExpected$detekt_core(propertyPath)) : (baseline.containsKey(propertyName) && next != null && nextBase == null ? CollectionsKt.listOf(Companion.unexpectedNestedConfiguration$detekt_core(propertyPath)) : (next != null && nextBase != null ? this.testKeys(next, nextBase, propertyPath) : CollectionsKt.emptyList()));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ\u0015\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\nJ\u0015\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\fJ\u0015\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/core/config/validation/InvalidPropertiesConfigValidator$Companion;", "", "<init>", "()V", "propertyDoesNotExists", "Lio/gitlab/arturbosch/detekt/api/Notification;", "prop", "", "propertyDoesNotExists$detekt_core", "nestedConfigurationExpected", "nestedConfigurationExpected$detekt_core", "unexpectedNestedConfiguration", "unexpectedNestedConfiguration$detekt_core", "propertyShouldBeAnArray", "propertyShouldBeAnArray$detekt_core", "detekt-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Notification propertyDoesNotExists$detekt_core(@NotNull String prop) {
            Intrinsics.checkNotNullParameter(prop, "prop");
            return new SimpleNotification("Property '" + prop + "' is misspelled or does not exist.", null, 2, null);
        }

        @NotNull
        public final Notification nestedConfigurationExpected$detekt_core(@NotNull String prop) {
            Intrinsics.checkNotNullParameter(prop, "prop");
            return new SimpleNotification("Nested config expected for '" + prop + "'.", null, 2, null);
        }

        @NotNull
        public final Notification unexpectedNestedConfiguration$detekt_core(@NotNull String prop) {
            Intrinsics.checkNotNullParameter(prop, "prop");
            return new SimpleNotification("Unexpected nested config for '" + prop + "'.", null, 2, null);
        }

        @NotNull
        public final Notification propertyShouldBeAnArray$detekt_core(@NotNull String prop) {
            Intrinsics.checkNotNullParameter(prop, "prop");
            return new SimpleNotification("Property '" + prop + "' should be a YAML array instead of a comma-separated String.", Notification.Level.Warning);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

