/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.settings;

import io.github.detekt.parser.KotlinEnvironmentUtilsKt;
import io.github.detekt.tooling.api.spec.CompilerSpec;
import io.github.detekt.tooling.api.spec.LoggingSpec;
import io.github.detekt.tooling.api.spec.ProjectSpec;
import io.gitlab.arturbosch.detekt.core.settings.EnvironmentAware;
import io.gitlab.arturbosch.detekt.core.settings.EnvironmentAwareKt;
import io.gitlab.arturbosch.detekt.core.settings.NullPrintStream;
import java.io.Closeable;
import java.io.PrintStream;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.config.CompilerConfiguration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00060\u0001j\u0002`\u00022\u00020\u00032\u00020\u0004B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0016\u001a\u00020\u00178VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lio/gitlab/arturbosch/detekt/core/settings/EnvironmentFacade;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "Ljava/io/Closeable;", "Lio/gitlab/arturbosch/detekt/core/settings/EnvironmentAware;", "projectSpec", "Lio/github/detekt/tooling/api/spec/ProjectSpec;", "compilerSpec", "Lio/github/detekt/tooling/api/spec/CompilerSpec;", "loggingSpec", "Lio/github/detekt/tooling/api/spec/LoggingSpec;", "<init>", "(Lio/github/detekt/tooling/api/spec/ProjectSpec;Lio/github/detekt/tooling/api/spec/CompilerSpec;Lio/github/detekt/tooling/api/spec/LoggingSpec;)V", "disposable", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "getDisposable", "()Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "classpath", "", "", "getClasspath", "()Ljava/util/List;", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "getEnvironment", "()Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "environment$delegate", "Lkotlin/Lazy;", "close", "", "detekt-core"})
public final class EnvironmentFacade
implements AutoCloseable,
Closeable,
EnvironmentAware {
    @NotNull
    private final ProjectSpec projectSpec;
    @NotNull
    private final CompilerSpec compilerSpec;
    @NotNull
    private final LoggingSpec loggingSpec;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final List<String> classpath;
    @NotNull
    private final Lazy environment$delegate;

    public EnvironmentFacade(@NotNull ProjectSpec projectSpec, @NotNull CompilerSpec compilerSpec, @NotNull LoggingSpec loggingSpec) {
        Intrinsics.checkNotNullParameter(projectSpec, "projectSpec");
        Intrinsics.checkNotNullParameter(compilerSpec, "compilerSpec");
        Intrinsics.checkNotNullParameter(loggingSpec, "loggingSpec");
        this.projectSpec = projectSpec;
        this.compilerSpec = compilerSpec;
        this.loggingSpec = loggingSpec;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue(disposable, "newDisposable(...)");
        this.disposable = disposable;
        this.classpath = EnvironmentAwareKt.classpathEntries(this.compilerSpec);
        this.environment$delegate = LazyKt.lazy(() -> EnvironmentFacade.environment_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public Disposable getDisposable() {
        return this.disposable;
    }

    @Override
    @NotNull
    public List<String> getClasspath() {
        return this.classpath;
    }

    @Override
    @NotNull
    public KotlinCoreEnvironment getEnvironment() {
        Lazy lazy = this.environment$delegate;
        return (KotlinCoreEnvironment)lazy.getValue();
    }

    @Override
    public void close() {
        Disposer.dispose(this.getDisposable());
    }

    private static final KotlinCoreEnvironment environment_delegate$lambda$0(EnvironmentFacade this$0) {
        PrintStream printStream = this$0.loggingSpec.getDebug() ? EnvironmentAwareKt.access$asPrintStream(this$0.loggingSpec.getErrorChannel()) : (PrintStream)NullPrintStream.INSTANCE;
        CompilerConfiguration compilerConfiguration = KotlinEnvironmentUtilsKt.createCompilerConfiguration(CollectionsKt.toList((Iterable)this$0.projectSpec.getInputPaths()), this$0.getClasspath(), EnvironmentAwareKt.parseLanguageVersion(this$0.compilerSpec), EnvironmentAwareKt.parseJvmTarget(this$0.compilerSpec), this$0.compilerSpec.getJdkHome(), printStream);
        return KotlinEnvironmentUtilsKt.createKotlinCoreEnvironment(compilerConfiguration, this$0.getDisposable(), this$0.loggingSpec.getDebug() ? EnvironmentAwareKt.access$asPrintStream(this$0.loggingSpec.getErrorChannel()) : (PrintStream)NullPrintStream.INSTANCE);
    }
}

