/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.tooling;

import io.github.detekt.tooling.api.DefaultConfigurationProvider;
import io.github.detekt.tooling.api.spec.ExtensionsSpec;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.core.tooling.DefaultConfigProviderKt;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/core/tooling/DefaultConfigProvider;", "Lio/github/detekt/tooling/api/DefaultConfigurationProvider;", "<init>", "()V", "extensionsSpec", "Lio/github/detekt/tooling/api/spec/ExtensionsSpec;", "init", "", "get", "Lio/gitlab/arturbosch/detekt/api/Config;", "copy", "targetLocation", "Ljava/nio/file/Path;", "detekt-core"})
public final class DefaultConfigProvider
implements DefaultConfigurationProvider {
    private ExtensionsSpec extensionsSpec;

    @Override
    public void init(@NotNull ExtensionsSpec extensionsSpec) {
        Intrinsics.checkNotNullParameter(extensionsSpec, "extensionsSpec");
        this.extensionsSpec = extensionsSpec;
    }

    @Override
    @NotNull
    public Config get() {
        ExtensionsSpec extensionsSpec = this.extensionsSpec;
        if (extensionsSpec == null) {
            Intrinsics.throwUninitializedPropertyAccessException("extensionsSpec");
            extensionsSpec = null;
        }
        return DefaultConfigProviderKt.access$getDefaultConfiguration(extensionsSpec);
    }

    @Override
    public void copy(@NotNull Path targetLocation) {
        Intrinsics.checkNotNullParameter(targetLocation, "targetLocation");
        ExtensionsSpec extensionsSpec = this.extensionsSpec;
        if (extensionsSpec == null) {
            Intrinsics.throwUninitializedPropertyAccessException("extensionsSpec");
            extensionsSpec = null;
        }
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.copy(DefaultConfigProviderKt.access$configInputStream(extensionsSpec), targetLocation, copyOptionArray);
    }
}

