/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.core.tooling;

import io.github.detekt.tooling.api.spec.ExtensionsSpec;
import io.github.detekt.tooling.api.spec.ProcessingSpec;
import io.github.detekt.utils.ResourcesKt;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.core.config.YamlConfig;
import io.gitlab.arturbosch.detekt.core.settings.ExtensionFacade;
import io.gitlab.arturbosch.detekt.core.tooling.DefaultConfigProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\f\u0010\t\u001a\u00020\n*\u00020\u0003H\u0002\u001a\n\u0010\t\u001a\u00020\n*\u00020\u000b\u00a8\u0006\f"}, d2={"configInputStream", "Ljava/io/InputStream;", "extensionsSpec", "Lio/github/detekt/tooling/api/spec/ExtensionsSpec;", "getSafeResourcesAsStreams", "Lkotlin/sequences/Sequence;", "Ljava/lang/ClassLoader;", "name", "", "getDefaultConfiguration", "Lio/gitlab/arturbosch/detekt/api/Config;", "Lio/github/detekt/tooling/api/spec/ProcessingSpec;", "detekt-core"})
@SourceDebugExtension(value={"SMAP\nDefaultConfigProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultConfigProvider.kt\nio/gitlab/arturbosch/detekt/core/tooling/DefaultConfigProviderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,61:1\n1#2:62\n1317#3,2:63\n*S KotlinDebug\n*F\n+ 1 DefaultConfigProvider.kt\nio/gitlab/arturbosch/detekt/core/tooling/DefaultConfigProviderKt\n*L\n40#1:63,2\n*E\n"})
public final class DefaultConfigProviderKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final InputStream configInputStream(ExtensionsSpec extensionsSpec) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        InputStream inputStream = ResourcesKt.getSafeResourceAsStream(DefaultConfigProvider.class, "/default-detekt-config.yml");
        if (inputStream == null) {
            String string2 = "Required value was null.";
            throw new IllegalArgumentException(string2.toString());
        }
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            long l = ByteStreamsKt.copyTo$default(it, outputStream, 0, 2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        Sequence<InputStream> $this$forEach$iv = DefaultConfigProviderKt.getSafeResourcesAsStreams(new ExtensionFacade(extensionsSpec.getPlugins()).getPluginLoader(), "config/config.yml");
        boolean $i$f$forEach = false;
        Iterator<InputStream> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            InputStream element$iv;
            InputStream inputStream2 = element$iv = iterator2.next();
            boolean bl = false;
            outputStream.write(10);
            Closeable closeable2 = inputStream2;
            Throwable throwable3 = null;
            try {
                InputStream it = (InputStream)closeable2;
                boolean bl2 = false;
                ByteStreamsKt.copyTo$default(it, outputStream, 0, 2, null);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable3 = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally(closeable2, throwable3);
            }
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    private static final Sequence<InputStream> getSafeResourcesAsStreams(ClassLoader $this$getSafeResourcesAsStreams, String name2) {
        Enumeration<URL> enumeration = $this$getSafeResourcesAsStreams.getResources(name2);
        Intrinsics.checkNotNullExpressionValue(enumeration, "getResources(...)");
        return SequencesKt.map(SequencesKt.asSequence(CollectionsKt.iterator(enumeration)), DefaultConfigProviderKt::getSafeResourcesAsStreams$lambda$3);
    }

    private static final Config getDefaultConfiguration(ExtensionsSpec $this$getDefaultConfiguration) {
        InputStream inputStream = DefaultConfigProviderKt.configInputStream($this$getDefaultConfiguration);
        Charset charset = Charsets.UTF_8;
        return YamlConfig.Companion.load(new InputStreamReader(inputStream, charset));
    }

    @NotNull
    public static final Config getDefaultConfiguration(@NotNull ProcessingSpec $this$getDefaultConfiguration) {
        Intrinsics.checkNotNullParameter($this$getDefaultConfiguration, "<this>");
        return DefaultConfigProviderKt.getDefaultConfiguration($this$getDefaultConfiguration.getExtensionsSpec());
    }

    private static final InputStream getSafeResourcesAsStreams$lambda$3(URL it) {
        Intrinsics.checkNotNull(it);
        return ResourcesKt.openSafeStream(it);
    }

    public static final /* synthetic */ Config access$getDefaultConfiguration(ExtensionsSpec $receiver) {
        return DefaultConfigProviderKt.getDefaultConfiguration($receiver);
    }

    public static final /* synthetic */ InputStream access$configInputStream(ExtensionsSpec extensionsSpec) {
        return DefaultConfigProviderKt.configInputStream(extensionsSpec);
    }
}

