/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.MethodSignatureKt;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/EqualsWithHashCodeExist;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "queue", "Lkotlin/collections/ArrayDeque;", "Lio/gitlab/arturbosch/detekt/rules/bugs/EqualsWithHashCodeExist$ViolationHolder;", "visitFile", "", "file", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "visitClassOrObject", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "ViolationHolder", "detekt-rules-errorprone"})
public final class EqualsWithHashCodeExist
extends Rule {
    @NotNull
    private final Issue issue;
    @NotNull
    private final ArrayDeque<ViolationHolder> queue;

    public EqualsWithHashCodeExist(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("EqualsWithHashCodeExist", Severity.Defect, "Always override hashCode when you override equals. All hash-based collections depend on objects meeting the equals-contract. Two equal objects must produce the same hashcode. When inheriting equals or hashcode, override the inherited and call the super method for clarification.", Debt.Companion.getFIVE_MINS());
        this.queue = new ArrayDeque(5);
    }

    public /* synthetic */ EqualsWithHashCodeExist(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitFile(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        this.queue.clear();
        super.visitFile(file2);
    }

    @Override
    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkNotNullParameter(classOrObject, "classOrObject");
        if (classOrObject instanceof KtClass && classOrObject.isData()) {
            return;
        }
        this.queue.addFirst(new ViolationHolder(false, false, 3, null));
        super.visitClassOrObject(classOrObject);
        if (this.queue.removeFirst().violation()) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.atName(classOrObject), "A class should always override hashCode when overriding equals and the other way around.", null, null, 24, null));
        }
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        if (!function2.isTopLevel()) {
            if (MethodSignatureKt.isEqualsFunction(function2)) {
                this.queue.first().setEquals(true);
            }
            if (MethodSignatureKt.isHashCodeFunction(function2)) {
                this.queue.first().setHashCode(true);
            }
        }
    }

    public EqualsWithHashCodeExist() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\r\u001a\u00020\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0002\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0004\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/EqualsWithHashCodeExist$ViolationHolder;", "", "equals", "", "hashCode", "<init>", "(ZZ)V", "getEquals", "()Z", "setEquals", "(Z)V", "getHashCode", "setHashCode", "violation", "component1", "component2", "copy", "other", "", "toString", "", "detekt-rules-errorprone"})
    private static final class ViolationHolder {
        private boolean equals;
        private boolean hashCode;

        public ViolationHolder(boolean equals2, boolean hashCode) {
            this.equals = equals2;
            this.hashCode = hashCode;
        }

        public /* synthetic */ ViolationHolder(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            this(bl, bl2);
        }

        public final boolean getEquals() {
            return this.equals;
        }

        public final void setEquals(boolean bl) {
            this.equals = bl;
        }

        public final boolean getHashCode() {
            return this.hashCode;
        }

        public final void setHashCode(boolean bl) {
            this.hashCode = bl;
        }

        public final boolean violation() {
            return this.equals && !this.hashCode || !this.equals && this.hashCode;
        }

        public final boolean component1() {
            return this.equals;
        }

        public final boolean component2() {
            return this.hashCode;
        }

        @NotNull
        public final ViolationHolder copy(boolean equals2, boolean hashCode) {
            return new ViolationHolder(equals2, hashCode);
        }

        public static /* synthetic */ ViolationHolder copy$default(ViolationHolder violationHolder, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = violationHolder.equals;
            }
            if ((n & 2) != 0) {
                bl2 = violationHolder.hashCode;
            }
            return violationHolder.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "ViolationHolder(equals=" + this.equals + ", hashCode=" + this.hashCode + ')';
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.equals);
            result2 = result2 * 31 + Boolean.hashCode(this.hashCode);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ViolationHolder)) {
                return false;
            }
            ViolationHolder violationHolder = (ViolationHolder)other;
            if (this.equals != violationHolder.equals) {
                return false;
            }
            return this.hashCode == violationHolder.hashCode;
        }

        public ViolationHolder() {
            this(false, false, 3, null);
        }
    }
}

