/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/IteratorHasNextCallsNextMethod;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitClassOrObject", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "callsNextMethod", "", "method", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nIteratorHasNextCallsNextMethod.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IteratorHasNextCallsNextMethod.kt\nio/gitlab/arturbosch/detekt/rules/bugs/IteratorHasNextCallsNextMethod\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,65:1\n266#2:66\n277#2,10:67\n299#2:77\n*S KotlinDebug\n*F\n+ 1 IteratorHasNextCallsNextMethod.kt\nio/gitlab/arturbosch/detekt/rules/bugs/IteratorHasNextCallsNextMethod\n*L\n62#1:66\n62#1:67,10\n62#1:77\n*E\n"})
public final class IteratorHasNextCallsNextMethod
extends Rule {
    @NotNull
    private final Issue issue;

    public IteratorHasNextCallsNextMethod(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("IteratorHasNextCallsNextMethod", Severity.Defect, "The `hasNext()` method of an Iterator implementation should not call the `next()` method. The state of the iterator should not be changed inside the `hasNext()` method. The `hasNext()` method is not supposed to have any side effects.", Debt.Companion.getTEN_MINS());
    }

    public /* synthetic */ IteratorHasNextCallsNextMethod(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
        KtNamedDeclaration hasNextMethod;
        Intrinsics.checkNotNullParameter(classOrObject, "classOrObject");
        if (KtPsiUtilKt.getSuperNames(classOrObject).contains("Iterator") && (hasNextMethod = KtPsiUtilKt.findFunctionByName(classOrObject, "hasNext")) != null && this.callsNextMethod(hasNextMethod)) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.atName(classOrObject), "Calling hasNext() on an Iterator should have no side-effects. Calling next() is a side effect.", null, null, 24, null));
        }
        super.visitClassOrObject(classOrObject);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean callsNextMethod(KtNamedDeclaration method) {
        void $this$anyDescendantOfType$iv;
        PsiElement psiElement = method;
        Function1<KtCallExpression, Boolean> predicate$iv = IteratorHasNextCallsNextMethod::callsNextMethod$lambda$0;
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtCallExpression && ((Boolean)this.$predicate.invoke(element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    private static final boolean callsNextMethod$lambda$0(KtCallExpression it) {
        Intrinsics.checkNotNullParameter(it, "it");
        KtExpression ktExpression = it.getCalleeExpression();
        return Intrinsics.areEqual(ktExpression != null ? ktExpression.getText() : null, "next");
    }

    public IteratorHasNextCallsNextMethod() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

