/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.AnnotationExcluder;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.bugs.LateinitUsage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR'\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0013\u001a\u00020\f8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0012\u0012\u0004\b\u0014\u0010\u000e\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/LateinitUsage;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "excludeAnnotatedProperties", "", "Lkotlin/text/Regex;", "getExcludeAnnotatedProperties$annotations", "()V", "getExcludeAnnotatedProperties", "()Ljava/util/List;", "excludeAnnotatedProperties$delegate", "Lkotlin/properties/ReadOnlyProperty;", "ignoreOnClassesPattern", "getIgnoreOnClassesPattern$annotations", "getIgnoreOnClassesPattern", "()Lkotlin/text/Regex;", "ignoreOnClassesPattern$delegate", "properties", "", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitProperty", "", "property", "visit", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nLateinitUsage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LateinitUsage.kt\nio/gitlab/arturbosch/detekt/rules/bugs/LateinitUsage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n827#2:78\n855#2,2:79\n827#2:81\n855#2,2:82\n1863#2,2:84\n1557#2:86\n1628#2,3:87\n*S KotlinDebug\n*F\n+ 1 LateinitUsage.kt\nio/gitlab/arturbosch/detekt/rules/bugs/LateinitUsage\n*L\n70#1:78\n70#1:79,2\n71#1:81\n71#1:82,2\n72#1:84,2\n45#1:86\n45#1:87,3\n*E\n"})
public final class LateinitUsage
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty excludeAnnotatedProperties$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreOnClassesPattern$delegate;
    @NotNull
    private final List<KtProperty> properties;

    public LateinitUsage(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Defect, "Usage of `lateinit` detected. Using `lateinit` for property initialization is error prone, try using constructor injection or delegation.", Debt.Companion.getTWENTY_MINS());
        this.excludeAnnotatedProperties$delegate = ConfigPropertyKt.config(CollectionsKt.emptyList(), LateinitUsage::excludeAnnotatedProperties_delegate$lambda$1);
        this.ignoreOnClassesPattern$delegate = ConfigPropertyKt.config("", ignoreOnClassesPattern.2.INSTANCE);
        this.properties = new ArrayList();
    }

    public /* synthetic */ LateinitUsage(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<Regex> getExcludeAnnotatedProperties() {
        return (List)this.excludeAnnotatedProperties$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="Allows you to provide a list of annotations that disable this check.")
    @Deprecated(message="Use `ignoreAnnotated` instead")
    private static /* synthetic */ void getExcludeAnnotatedProperties$annotations() {
    }

    private final Regex getIgnoreOnClassesPattern() {
        return (Regex)this.ignoreOnClassesPattern$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Configuration(description="Allows you to disable the rule for a list of classes")
    private static /* synthetic */ void getIgnoreOnClassesPattern$annotations() {
    }

    @Override
    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter(property, "property");
        if (KtModifierListKt.isLateinit(property)) {
            this.properties.add(property);
        }
    }

    @Override
    public void visit(@NotNull KtFile root) {
        KtProperty it;
        Iterable $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(root, "root");
        this.properties.clear();
        super.visit(root);
        AnnotationExcluder annotationExcluder = new AnnotationExcluder(root, this.getExcludeAnnotatedProperties(), this.getBindingContext());
        Iterable $this$filterNot$iv = this.properties;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (KtProperty)element$iv$iv;
            boolean bl = false;
            List<KtAnnotationEntry> list = it.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(list, "getAnnotationEntries(...)");
            if (annotationExcluder.shouldExclude(list)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            boolean bl;
            it = (KtProperty)element$iv$iv;
            boolean bl2 = false;
            Object object = KtPsiUtilKt.containingClass(it);
            if (object != null && (object = ((KtTypeParameterListOwnerStub)object).getName()) != null) {
                CharSequence charSequence = (CharSequence)object;
                bl = this.getIgnoreOnClassesPattern().matches(charSequence);
            } else {
                bl = false;
            }
            if (bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtProperty it2 = (KtProperty)element$iv;
            boolean bl = false;
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, it2, 0, 2, null), "Usages of lateinit should be avoided.", null, null, 24, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List excludeAnnotatedProperties_delegate$lambda$1(List list) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(list, "list");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Regex(StringsKt.replace$default(StringsKt.replace$default((String)it, ".", "\\.", false, 4, null), "*", ".*", false, 4, null)));
        }
        return (List)destination$iv$iv;
    }

    public LateinitUsage() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(LateinitUsage.class, "excludeAnnotatedProperties", "getExcludeAnnotatedProperties()Ljava/util/List;", 0)), Reflection.property1(new PropertyReference1Impl(LateinitUsage.class, "ignoreOnClassesPattern", "getIgnoreOnClassesPattern()Lkotlin/text/Regex;", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

