/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/MissingPackageDeclaration;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "packageDeclaration", "Lorg/jetbrains/kotlin/psi/KtPackageDirective;", "visitPackageDirective", "", "directive", "postVisit", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "detekt-rules-errorprone"})
public final class MissingPackageDeclaration
extends Rule {
    @NotNull
    private final Issue issue;
    @Nullable
    private KtPackageDirective packageDeclaration;

    public MissingPackageDeclaration(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Maintainability, "Kotlin source files should define a package.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ MissingPackageDeclaration(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitPackageDirective(@NotNull KtPackageDirective directive) {
        Intrinsics.checkNotNullParameter(directive, "directive");
        super.visitPackageDirective(directive);
        this.packageDeclaration = directive;
    }

    @Override
    protected void postVisit(@NotNull KtFile root) {
        Intrinsics.checkNotNullParameter(root, "root");
        super.postVisit(root);
        KtPackageDirective ktPackageDirective = this.packageDeclaration;
        CharSequence charSequence = ktPackageDirective != null ? ktPackageDirective.getText() : null;
        if (charSequence == null || StringsKt.isBlank(charSequence)) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, root, 0, 2, null), "The file does not contain a package declaration.", null, null, 24, null));
        }
    }

    public MissingPackageDeclaration() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

