/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@RequiresTypeResolution
@Deprecated(message="Rule deprecated as compiler performs this check by default")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0017\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/MissingWhenCase;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "allowElseExpression", "", "getAllowElseExpression$annotations", "()V", "getAllowElseExpression", "()Z", "allowElseExpression$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitWhenExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "checkMissingWhenExpression", "reportMissingCases", "missingCases", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "detekt-rules-errorprone"})
public final class MissingWhenCase
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty allowElseExpression$delegate;

    public MissingWhenCase(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("MissingWhenCase", Severity.Defect, "Check usage of `when` used as a statement and don't compare all enum or sealed class cases.", Debt.Companion.getTWENTY_MINS());
        this.allowElseExpression$delegate = ConfigPropertyKt.config(true);
    }

    public /* synthetic */ MissingWhenCase(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getAllowElseExpression() {
        return (Boolean)this.allowElseExpression$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="whether `else` can be treated as a valid case for enums and sealed classes")
    private static /* synthetic */ void getAllowElseExpression$annotations() {
    }

    @Override
    public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitWhenExpression(expression2);
        if (this.getAllowElseExpression() && expression2.getElseExpression() != null) {
            return;
        }
        this.checkMissingWhenExpression(expression2);
    }

    private final void checkMissingWhenExpression(KtWhenExpression expression2) {
        if (BindingContextUtilsKt.isUsedAsExpression(expression2, this.getBindingContext())) {
            return;
        }
        KtExpression ktExpression = expression2.getSubjectExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression subjectExpression = ktExpression;
        KotlinType subjectType = CallUtilKt.getType(subjectExpression, this.getBindingContext());
        ClassDescriptor enumClassDescriptor = WhenChecker.getClassDescriptorOfTypeIfEnum(subjectType);
        ClassDescriptor sealedClassDescriptor = WhenChecker.getClassDescriptorOfTypeIfSealed(subjectType);
        if (enumClassDescriptor != null || sealedClassDescriptor != null) {
            List<WhenMissingCase> missingCases = WhenChecker.INSTANCE.getMissingCases(expression2, this.getBindingContext());
            this.reportMissingCases(missingCases, expression2);
        }
    }

    private final void reportMissingCases(List<? extends WhenMissingCase> missingCases, KtWhenExpression expression2) {
        if (!((Collection)missingCases).isEmpty()) {
            String message = "When expression is missing cases: " + CollectionsKt.joinToString$default(missingCases, null, null, null, 0, null, null, 63, null) + '.';
            if (this.getAllowElseExpression()) {
                message = message + " Either add missing cases or a default `else` case.";
            }
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), message, null, null, 24, null));
        }
    }

    public MissingWhenCase() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(MissingWhenCase.class, "allowElseExpression", "getAllowElseExpression()Z", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

