/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.complexity.ComplexCondition$checkIfComplex$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/ComplexCondition;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "threshold", "", "getThreshold$annotations", "()V", "getThreshold", "()I", "threshold$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitIfExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitDoWhileExpression", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "visitWhileExpression", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "checkIfComplex", "condition", "Lorg/jetbrains/kotlin/psi/KtExpression;", "frequency", "source", "", "part", "detekt-rules-complexity"})
@SourceDebugExtension(value={"SMAP\nComplexCondition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComplexCondition.kt\nio/gitlab/arturbosch/detekt/rules/complexity/ComplexCondition\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n309#2,15:115\n229#2,2:130\n241#2:132\n328#2:133\n2669#3,7:134\n*S KotlinDebug\n*F\n+ 1 ComplexCondition.kt\nio/gitlab/arturbosch/detekt/rules/complexity/ComplexCondition\n*L\n76#1:115,15\n76#1:130,2\n76#1:132\n76#1:133\n79#1:134,7\n*E\n"})
public final class ComplexCondition
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty threshold$delegate;

    public ComplexCondition(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("ComplexCondition", Severity.Maintainability, "Complex conditions should be simplified and extracted into well-named methods if necessary.", Debt.Companion.getTWENTY_MINS());
        this.threshold$delegate = ConfigPropertyKt.config(4);
    }

    public /* synthetic */ ComplexCondition(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getThreshold() {
        return ((Number)this.threshold$delegate.getValue(this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="the number of conditions which will trigger the rule")
    private static /* synthetic */ void getThreshold$annotations() {
    }

    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KtExpression condition = expression2.getCondition();
        this.checkIfComplex(condition);
        super.visitIfExpression(expression2);
    }

    @Override
    public void visitDoWhileExpression(@NotNull KtDoWhileExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KtExpression condition = expression2.getCondition();
        this.checkIfComplex(condition);
        super.visitDoWhileExpression(expression2);
    }

    @Override
    public void visitWhileExpression(@NotNull KtWhileExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        KtExpression condition = expression2.getCondition();
        this.checkIfComplex(condition);
        super.visitWhileExpression(expression2);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkIfComplex(KtExpression condition) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        KtExpression ktExpression = condition;
        if (ktExpression == null) {
            return;
        }
        PsiElement $this$collectDescendantsOfType_u24default$iv = ktExpression;
        Function1 predicate$iv = checkIfComplex$$inlined$collectDescendantsOfType$default$1.INSTANCE;
        boolean $i$f$collectDescendantsOfType = false;
        PsiElement $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
        boolean $i$f$collectDescendantsOfType22 = false;
        PsiElement psiElement = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var12_14 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = new Function1<KtBinaryExpression, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(PsiElement it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (((Boolean)this.$predicate.invoke(it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtBinaryExpression) {
                    this.$action.invoke(element);
                }
            }
        });
        List binaryExpressions = (List)to$iv$iv$iv;
        if (binaryExpressions.size() > 1) {
            Iterable $this$reduce$iv = binaryExpressions;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void binExpr;
                KtBinaryExpression $i$f$collectDescendantsOfType22 = (KtBinaryExpression)iterator$iv.next();
                KtBinaryExpression acc = (KtBinaryExpression)accumulator$iv;
                boolean bl = false;
                accumulator$iv = binExpr.getText().length() > acc.getText().length() ? binExpr : acc;
            }
            KtBinaryExpression longestBinExpr = (KtBinaryExpression)accumulator$iv;
            String conditionString = longestBinExpr.getText();
            Intrinsics.checkNotNull(conditionString);
            int count2 = this.frequency(conditionString, "&&") + this.frequency(conditionString, "||") + 1;
            if (count2 >= this.getThreshold()) {
                this.report(new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, condition, 0, 2, null), new Metric("SIZE", count2, this.getThreshold(), false, 0, 24, null), "This condition is too complex (" + count2 + "). Defined complexity threshold for conditions is set to '" + this.getThreshold() + '\'', null, 16, null));
            }
        }
    }

    private final int frequency(String source2, String part) {
        if (((CharSequence)source2).length() == 0 || ((CharSequence)part).length() == 0) {
            return 0;
        }
        int count2 = 0;
        int pos = StringsKt.indexOf$default((CharSequence)source2, part, 0, false, 4, null);
        while (pos != -1) {
            pos += part.length();
            ++count2;
            pos = StringsKt.indexOf$default((CharSequence)source2, part, pos, false, 4, null);
        }
        return count2;
    }

    public ComplexCondition() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(ComplexCondition.class, "threshold", "getThreshold()I", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

