/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.github.detekt.metrics.LinesOfCodeKt;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0014H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000b0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00140\u0016j\b\u0012\u0004\u0012\u00020\u0014`\u00170\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/LargeClass;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "threshold", "", "getThreshold$annotations", "()V", "getThreshold", "()I", "threshold$delegate", "Lkotlin/properties/ReadOnlyProperty;", "classToLinesCache", "Ljava/util/IdentityHashMap;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "nestedClassTracking", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "preVisit", "", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "postVisit", "visitClassOrObject", "classOrObject", "detekt-rules-complexity"})
@SourceDebugExtension(value={"SMAP\nLargeClass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LargeClass.kt\nio/gitlab/arturbosch/detekt/rules/complexity/LargeClass\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n142#2:78\n1#3:79\n381#4,7:80\n1797#5,3:87\n*S KotlinDebug\n*F\n+ 1 LargeClass.kt\nio/gitlab/arturbosch/detekt/rules/complexity/LargeClass\n*L\n67#1:78\n68#1:80,7\n72#1:87,3\n*E\n"})
public final class LargeClass
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty threshold$delegate;
    @NotNull
    private final IdentityHashMap<KtClassOrObject, Integer> classToLinesCache;
    @NotNull
    private final IdentityHashMap<KtClassOrObject, HashSet<KtClassOrObject>> nestedClassTracking;

    public LargeClass(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("LargeClass", Severity.Maintainability, "One class should have one responsibility. Large classes tend to handle many things at once. Split up large classes into smaller classes that are easier to understand.", Debt.Companion.getTWENTY_MINS());
        this.threshold$delegate = ConfigPropertyKt.config(600);
        this.classToLinesCache = new IdentityHashMap();
        this.nestedClassTracking = new IdentityHashMap();
    }

    public /* synthetic */ LargeClass(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getThreshold() {
        return ((Number)this.threshold$delegate.getValue(this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="the size of class required to trigger the rule")
    private static /* synthetic */ void getThreshold$annotations() {
    }

    @Override
    protected void preVisit(@NotNull KtFile root) {
        Intrinsics.checkNotNullParameter(root, "root");
        this.classToLinesCache.clear();
        this.nestedClassTracking.clear();
    }

    @Override
    protected void postVisit(@NotNull KtFile root) {
        Intrinsics.checkNotNullParameter(root, "root");
        for (Map.Entry entry : ((Map)this.classToLinesCache).entrySet()) {
            KtClassOrObject clazz = (KtClassOrObject)entry.getKey();
            Integer lines = (Integer)entry.getValue();
            if (lines < this.getThreshold()) continue;
            Issue issue = this.getIssue();
            Intrinsics.checkNotNull(clazz);
            Entity entity = Entity.Companion.atName(clazz);
            Intrinsics.checkNotNull(lines);
            this.report(new ThresholdedCodeSmell(issue, entity, new Metric("SIZE", lines, this.getThreshold(), false, 0, 24, null), "Class " + clazz.getName() + " is too large. Consider splitting it into smaller pieces.", null, 16, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
        block4: {
            void $this$fold$iv;
            Cloneable answer$iv;
            Intrinsics.checkNotNullParameter(classOrObject, "classOrObject");
            int lines = LinesOfCodeKt.linesOfCode$default(classOrObject, null, 1, null);
            Integer n = lines;
            ((Map)this.classToLinesCache).put(classOrObject, n);
            Object $this$getStrictParentOfType$iv = classOrObject;
            boolean $i$f$getStrictParentOfType = false;
            Serializable serializable = PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClassOrObject.class, true);
            if (serializable != null) {
                Object object;
                KtClassOrObject it = serializable;
                boolean bl = false;
                Map $this$getOrPut$iv = this.nestedClassTracking;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(it);
                if (value$iv == null) {
                    boolean bl2 = false;
                    answer$iv = new HashSet();
                    $this$getOrPut$iv.put(it, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((HashSet)object).add(classOrObject);
            }
            super.visitClassOrObject(classOrObject);
            Collection<KtClassOrObject> collection = PsiTreeUtil.findChildrenOfType(classOrObject, KtClassOrObject.class);
            Intrinsics.checkNotNullExpressionValue(collection, "findChildrenOfType(...)");
            $this$getStrictParentOfType$iv = collection;
            Integer initial$iv = 0;
            boolean $i$f$fold = false;
            Integer accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void next;
                answer$iv = (KtClassOrObject)element$iv;
                int acc = ((Number)accumulator$iv).intValue();
                boolean bl = false;
                Integer n2 = this.classToLinesCache.get(next);
                accumulator$iv = acc + (n2 != null ? n2 : 0);
            }
            n = accumulator$iv;
            int it = ((Number)n).intValue();
            boolean bl = false;
            Serializable serializable2 = serializable = it > 0 ? n : null;
            if (serializable == null) break block4;
            it = ((Number)serializable).intValue();
            boolean bl3 = false;
            ((Map)this.classToLinesCache).put(classOrObject, lines - it);
        }
    }

    public LargeClass() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(LargeClass.class, "threshold", "getThreshold()I", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

