/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\f\u0010\u001c\u001a\u00020\u0013*\u00020\u001bH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\u00020\u00138BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0011\u0012\u0004\b\u0014\u0010\r\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/NamedArguments;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "threshold", "", "getThreshold$annotations", "()V", "getThreshold", "()I", "threshold$delegate", "Lkotlin/properties/ReadOnlyProperty;", "ignoreArgumentsMatchingNames", "", "getIgnoreArgumentsMatchingNames$annotations", "getIgnoreArgumentsMatchingNames", "()Z", "ignoreArgumentsMatchingNames$delegate", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "canNameArguments", "detekt-rules-complexity"})
@SourceDebugExtension(value={"SMAP\nNamedArguments.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamedArguments.kt\nio/gitlab/arturbosch/detekt/rules/complexity/NamedArguments\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n827#2:81\n855#2,2:82\n1611#2,9:84\n1863#2:93\n1864#2:95\n1620#2:96\n1782#2,4:97\n1734#2,3:101\n1#3:94\n*S KotlinDebug\n*F\n+ 1 NamedArguments.kt\nio/gitlab/arturbosch/detekt/rules/complexity/NamedArguments\n*L\n52#1:81\n52#1:82,2\n66#1:84,9\n66#1:93\n66#1:95\n66#1:96\n76#1:97,4\n77#1:101,3\n66#1:94\n*E\n"})
public final class NamedArguments
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty threshold$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreArgumentsMatchingNames$delegate;

    public NamedArguments(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("NamedArguments", Severity.Maintainability, "Named arguments are required for function calls with many arguments.", Debt.Companion.getFIVE_MINS());
        this.threshold$delegate = ConfigPropertyKt.config(3);
        this.ignoreArgumentsMatchingNames$delegate = ConfigPropertyKt.config(false);
    }

    public /* synthetic */ NamedArguments(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getThreshold() {
        return ((Number)this.threshold$delegate.getValue(this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="number of arguments that triggers this inspection")
    private static /* synthetic */ void getThreshold$annotations() {
    }

    private final boolean getIgnoreArgumentsMatchingNames() {
        return (Boolean)this.ignoreArgumentsMatchingNames$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Configuration(description="ignores when argument values are the same as the parameter names")
    private static /* synthetic */ void getIgnoreArgumentsMatchingNames$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        List<KtValueArgument> list = expression2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
        Iterable $this$filterNot$iv = list;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            KtValueArgument it = (KtValueArgument)element$iv$iv;
            boolean bl = false;
            if (it instanceof KtLambdaArgument) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List valueArguments = (List)destination$iv$iv;
        if (valueArguments.size() > this.getThreshold() && this.canNameArguments(expression2)) {
            String message = "This function call has " + valueArguments.size() + " arguments. To call a function with more than " + this.getThreshold() + " arguments you should set the name of each argument.";
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), message, null, null, 24, null));
        } else {
            super.visitCallExpression(expression2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final boolean canNameArguments(KtCallExpression $this$canNameArguments) {
        block13: {
            v0 = CallUtilKt.getResolvedCall($this$canNameArguments, this.getBindingContext());
            if (v0 == null) {
                return false;
            }
            resolvedCall = v0;
            if (!resolvedCall.getCandidateDescriptor().hasStableParameterNames()) {
                return false;
            }
            v1 = $this$canNameArguments.getValueArguments();
            Intrinsics.checkNotNullExpressionValue(v1, "getValueArguments(...)");
            $this$mapNotNull$iv = v1;
            $i$f$mapNotNull = false;
            var6_5 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var11_15 = $this$forEach$iv$iv$iv.iterator();
            while (var11_15.hasNext()) {
                block15: {
                    block16: {
                        block14: {
                            element$iv$iv = element$iv$iv$iv = var11_15.next();
                            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                            argument = (KtValueArgument)element$iv$iv;
                            $i$a$-mapNotNull-NamedArguments$canNameArguments$unnamedArguments$1 = false;
                            if (!argument.isNamed() && !(argument instanceof KtLambdaArgument)) break block14;
                            v2 = null;
                            break block15;
                        }
                        if (CallUtilKt.getParameterForArgument(resolvedCall, argument) != null) break block16;
                        v2 = null;
                        break block15;
                    }
                    if (!this.getIgnoreArgumentsMatchingNames()) ** GOTO lbl-1000
                    v3 = argument.getArgumentExpression();
                    if (Intrinsics.areEqual(parameter.getName().asString(), v3 != null ? v3.getText() : null)) {
                        v2 = null;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = TuplesKt.to(argument, parameter);
                    }
                }
                if (v2 == null) continue;
                it$iv$iv = v2;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            unnamedArguments = (List)destination$iv$iv;
            if (!(((Collection)unnamedArguments).isEmpty() == false)) ** GOTO lbl-1000
            $this$count$iv = unnamedArguments;
            $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                v4 = 0;
            } else {
                count$iv = 0;
                for (E element$iv : $this$count$iv) {
                    $this$forEach$iv$iv$iv = (Pair)element$iv;
                    $i$a$-count-NamedArguments$canNameArguments$1 = false;
                    argument = (KtValueArgument)$this$forEach$iv$iv$iv.component1();
                    if (!argument.isSpread() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v4 = count$iv;
            }
            if (v4 > true) ** GOTO lbl-1000
            $this$all$iv = unnamedArguments;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v5 = true;
            } else {
                for (E element$iv : $this$all$iv) {
                    var8_10 = (Pair)element$iv;
                    $i$a$-all-NamedArguments$canNameArguments$2 = false;
                    argument = (KtValueArgument)var8_10.component1();
                    parameter = (ValueParameterDescriptor)var8_10.component2();
                    if (argument.isSpread() != false || ArgumentsUtilsKt.isVararg(parameter) == false) continue;
                    v5 = false;
                    break block13;
                }
                v5 = true;
            }
        }
        if (v5) {
            v6 = true;
        } else lbl-1000:
        // 3 sources

        {
            v6 = false;
        }
        return v6;
    }

    public NamedArguments() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(NamedArguments.class, "threshold", "getThreshold()I", 0)), Reflection.property1(new PropertyReference1Impl(NamedArguments.class, "ignoreArgumentsMatchingNames", "getIgnoreArgumentsMatchingNames()Z", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

