/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.JunkKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtContainerNodeForControlStructureBody;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/NestedBlockDepth;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "threshold", "", "getThreshold$annotations", "()V", "getThreshold", "()I", "threshold$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "FunctionDepthVisitor", "detekt-rules-complexity"})
public final class NestedBlockDepth
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty threshold$delegate;

    public NestedBlockDepth(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("NestedBlockDepth", Severity.Maintainability, "Excessive nesting leads to hidden complexity. Prefer extracting code to make it easier to understand.", Debt.Companion.getTWENTY_MINS());
        this.threshold$delegate = ConfigPropertyKt.config(4);
    }

    public /* synthetic */ NestedBlockDepth(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getThreshold() {
        return ((Number)this.threshold$delegate.getValue(this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="the nested depth required to trigger rule")
    private static /* synthetic */ void getThreshold$annotations() {
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        FunctionDepthVisitor visitor2 = new FunctionDepthVisitor(this.getThreshold());
        visitor2.visitNamedFunction(function2);
        if (visitor2.isTooDeep()) {
            this.report(new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.atName(function2), new Metric("SIZE", visitor2.getMaxDepth(), this.getThreshold(), false, 0, 24, null), "Function " + function2.getName() + " is nested too deeply.", null, 16, null));
        }
    }

    public NestedBlockDepth() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(NestedBlockDepth.class, "threshold", "getThreshold()I", 0))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020!H\u0016J$\u0010\"\u001a\u00020\u00142\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00140'H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u0005R\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0007\"\u0004\b\r\u0010\u0005R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006("}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/NestedBlockDepth$FunctionDepthVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "threshold", "", "<init>", "(I)V", "getThreshold", "()I", "depth", "getDepth", "setDepth", "maxDepth", "getMaxDepth", "setMaxDepth", "isTooDeep", "", "()Z", "setTooDeep", "(Z)V", "inc", "", "dec", "visitIfExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitLoopExpression", "loopExpression", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "visitTryExpression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "insideLambdaDo", "lambdaArguments", "", "Lorg/jetbrains/kotlin/psi/KtLambdaArgument;", "function", "Lkotlin/Function0;", "detekt-rules-complexity"})
    private static final class FunctionDepthVisitor
    extends DetektVisitor {
        private final int threshold;
        private int depth;
        private int maxDepth;
        private boolean isTooDeep;

        public FunctionDepthVisitor(int threshold) {
            this.threshold = threshold;
        }

        public final int getThreshold() {
            return this.threshold;
        }

        public final int getDepth() {
            return this.depth;
        }

        public final void setDepth(int n) {
            this.depth = n;
        }

        public final int getMaxDepth() {
            return this.maxDepth;
        }

        public final void setMaxDepth(int n) {
            this.maxDepth = n;
        }

        public final boolean isTooDeep() {
            return this.isTooDeep;
        }

        public final void setTooDeep(boolean bl) {
            this.isTooDeep = bl;
        }

        private final void inc() {
            int n = this.depth;
            this.depth = n + 1;
            if (this.depth >= this.threshold) {
                this.isTooDeep = true;
                if (this.depth > this.maxDepth) {
                    this.maxDepth = this.depth;
                }
            }
        }

        private final void dec() {
            int n = this.depth;
            this.depth = n + -1;
        }

        @Override
        public void visitIfExpression(@NotNull KtIfExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            if (!(expression2.getParent() instanceof KtContainerNodeForControlStructureBody)) {
                this.inc();
                super.visitIfExpression(expression2);
                this.dec();
            } else {
                super.visitIfExpression(expression2);
            }
        }

        @Override
        public void visitLoopExpression(@NotNull KtLoopExpression loopExpression) {
            Intrinsics.checkNotNullParameter(loopExpression, "loopExpression");
            this.inc();
            super.visitLoopExpression(loopExpression);
            this.dec();
        }

        @Override
        public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            this.inc();
            super.visitWhenExpression(expression2);
            this.dec();
        }

        @Override
        public void visitTryExpression(@NotNull KtTryExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            this.inc();
            super.visitTryExpression(expression2);
            this.dec();
        }

        @Override
        public void visitCallExpression(@NotNull KtCallExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            List<KtLambdaArgument> list = expression2.getLambdaArguments();
            Intrinsics.checkNotNullExpressionValue(list, "getLambdaArguments(...)");
            List<KtLambdaArgument> lambdaArguments = list;
            if (JunkKt.isUsedForNesting(expression2)) {
                this.insideLambdaDo(lambdaArguments, () -> FunctionDepthVisitor.visitCallExpression$lambda$0(this));
                super.visitCallExpression(expression2);
                this.insideLambdaDo(lambdaArguments, () -> FunctionDepthVisitor.visitCallExpression$lambda$1(this));
            }
        }

        private final void insideLambdaDo(List<KtLambdaArgument> lambdaArguments, Function0<Unit> function2) {
            if (!((Collection)lambdaArguments).isEmpty()) {
                KtLambdaArgument lambdaArgument = lambdaArguments.get(0);
                KtLambdaExpression ktLambdaExpression = lambdaArgument.getLambdaExpression();
                if ((ktLambdaExpression != null ? ktLambdaExpression.getBodyExpression() : null) != null) {
                    function2.invoke();
                }
            }
        }

        private static final Unit visitCallExpression$lambda$0(FunctionDepthVisitor this$0) {
            this$0.inc();
            return Unit.INSTANCE;
        }

        private static final Unit visitCallExpression$lambda$1(FunctionDepthVisitor this$0) {
            this$0.dec();
            return Unit.INSTANCE;
        }
    }
}

