/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/ReplaceSafeCallChainWithRun;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitSafeQualifiedExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtSafeQualifiedExpression;", "detekt-rules-complexity"})
public final class ReplaceSafeCallChainWithRun
extends Rule {
    @NotNull
    private final Issue issue;

    public ReplaceSafeCallChainWithRun(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Maintainability, "Chains of safe calls on non-nullable types can be surrounded with `run {}`.", Debt.Companion.getTEN_MINS());
    }

    public /* synthetic */ ReplaceSafeCallChainWithRun(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitSafeQualifiedExpression(expression2);
        if (expression2.getParent() instanceof KtSafeQualifiedExpression) {
            return;
        }
        int counter = 0;
        KtExpression receiver = expression2.getReceiverExpression();
        while (receiver instanceof KtSafeQualifiedExpression) {
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(receiver, this.getBindingContext());
            if (resolvedCall2 != null && (resolvedCall2 = resolvedCall2.getResultingDescriptor()) != null && (resolvedCall2 = resolvedCall2.getReturnType()) != null ? KotlinTypeKt.isNullable((KotlinType)((Object)resolvedCall2)) : false) break;
            ++counter;
            receiver = ((KtSafeQualifiedExpression)receiver).getReceiverExpression();
        }
        if (counter >= 1) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    public ReplaceSafeCallChainWithRun() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

