/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.coroutines;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessorsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\u000f*\u00020\u0010H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/coroutines/RedundantSuspendModifier;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isValidCandidateExpression", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "hasSuspendCalls", "detekt-rules-coroutines"})
@SourceDebugExtension(value={"SMAP\nRedundantSuspendModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantSuspendModifier.kt\nio/gitlab/arturbosch/detekt/rules/coroutines/RedundantSuspendModifier\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n266#2:135\n277#2,10:136\n299#2:146\n1755#3,3:147\n1755#3,3:150\n*S KotlinDebug\n*F\n+ 1 RedundantSuspendModifier.kt\nio/gitlab/arturbosch/detekt/rules/coroutines/RedundantSuspendModifier\n*L\n76#1:135\n76#1:136,10\n76#1:146\n103#1:147,3\n112#1:150,3\n*E\n"})
public final class RedundantSuspendModifier
extends Rule {
    @NotNull
    private final Issue issue;

    public RedundantSuspendModifier(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("RedundantSuspendModifier", Severity.Minor, "The `suspend` modifier is only needed for functions that contain suspending calls.", Debt.Companion.getFIVE_MINS());
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        void $this$anyDescendantOfType$iv;
        Intrinsics.checkNotNullParameter(function2, "function");
        PsiElement psiElement = function2.getModifierList();
        if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.SUSPEND_KEYWORD)) == null) {
            return;
        }
        PsiElement suspendModifier = psiElement;
        if (!function2.hasBody()) {
            return;
        }
        if (function2.hasModifier(KtTokens.OVERRIDE_KEYWORD) || function2.hasModifier(KtTokens.ACTUAL_KEYWORD)) {
            return;
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)this.getBindingContext().get(BindingContext.FUNCTION, function2);
        if (simpleFunctionDescriptor == null) {
            return;
        }
        SimpleFunctionDescriptor descriptor2 = simpleFunctionDescriptor;
        if (descriptor2.getModality() == Modality.OPEN) {
            return;
        }
        PsiElement psiElement2 = function2;
        Function1<KtExpression, Boolean> predicate$iv = arg_0 -> RedundantSuspendModifier.visitNamedFunction$lambda$0(this, arg_0);
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtExpression && ((Boolean)this.$predicate.invoke(element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        if (!((PsiElement)result$iv$iv$iv.element != null)) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, suspendModifier, 0, 2, null), "Function has redundant `suspend` modifier.", null, null, 24, null));
        }
    }

    private final boolean isValidCandidateExpression(KtExpression $this$isValidCandidateExpression) {
        PsiElement parent2;
        KtExpression ktExpression = $this$isValidCandidateExpression;
        return ktExpression instanceof KtOperationReferenceExpression || ktExpression instanceof KtForExpression || ktExpression instanceof KtProperty || ktExpression instanceof KtNameReferenceExpression ? true : ((parent2 = $this$isValidCandidateExpression.getParent()) instanceof KtCallExpression && Intrinsics.areEqual(((KtCallExpression)parent2).getCalleeExpression(), $this$isValidCandidateExpression) ? true : $this$isValidCandidateExpression instanceof KtCallExpression && ((KtCallExpression)$this$isValidCandidateExpression).getCalleeExpression() instanceof KtCallExpression);
    }

    private final boolean hasSuspendCalls(KtExpression $this$hasSuspendCalls) {
        boolean bl;
        block16: {
            if (!this.isValidCandidateExpression($this$hasSuspendCalls)) {
                return false;
            }
            KtExpression ktExpression = $this$hasSuspendCalls;
            if (ktExpression instanceof KtForExpression) {
                ResolvedCall iteratorResolvedCall = (ResolvedCall)this.getBindingContext().get(BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, ((KtForExpression)$this$hasSuspendCalls).getLoopRange());
                ResolvedCall loopRangeHasNextResolvedCall = (ResolvedCall)this.getBindingContext().get(BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, ((KtForExpression)$this$hasSuspendCalls).getLoopRange());
                ResolvedCall loopRangeNextResolvedCall = (ResolvedCall)this.getBindingContext().get(BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, ((KtForExpression)$this$hasSuspendCalls).getLoopRange());
                ResolvedCall[] resolvedCallArray = new ResolvedCall[]{iteratorResolvedCall, loopRangeHasNextResolvedCall, loopRangeNextResolvedCall};
                Iterable $this$any$iv = CollectionsKt.listOf(resolvedCallArray);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ResolvedCall it = (ResolvedCall)element$iv;
                        boolean bl2 = false;
                        Object object = it;
                        boolean bl3 = object != null && (object = (FunctionDescriptor)object.getResultingDescriptor()) != null ? object.isSuspend() : false;
                        if (!bl3) continue;
                        bl = true;
                        break block16;
                    }
                    bl = false;
                }
            } else if (ktExpression instanceof KtProperty) {
                if (((KtProperty)$this$hasSuspendCalls).hasDelegateExpression()) {
                    VariableDescriptorWithAccessors variableDescriptor;
                    DeclarationDescriptor loopRangeHasNextResolvedCall = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, $this$hasSuspendCalls);
                    VariableDescriptorWithAccessors variableDescriptorWithAccessors = variableDescriptor = loopRangeHasNextResolvedCall instanceof VariableDescriptorWithAccessors ? (VariableDescriptorWithAccessors)loopRangeHasNextResolvedCall : null;
                    List<VariableAccessorDescriptor> list = variableDescriptorWithAccessors != null ? VariableDescriptorWithAccessorsKt.getAccessors(variableDescriptorWithAccessors) : null;
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    List<VariableAccessorDescriptor> accessors = list;
                    Iterable $this$any$iv = accessors;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FunctionDescriptor delegatedFunctionDescriptor;
                            VariableAccessorDescriptor accessor = (VariableAccessorDescriptor)element$iv;
                            boolean bl4 = false;
                            ResolvedCall resolvedCall2 = (ResolvedCall)this.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, accessor);
                            FunctionDescriptor functionDescriptor = delegatedFunctionDescriptor = resolvedCall2 != null ? (FunctionDescriptor)resolvedCall2.getResultingDescriptor() : null;
                            boolean bl5 = functionDescriptor != null ? functionDescriptor.isSuspend() : false;
                            if (!bl5) continue;
                            bl = true;
                            break block16;
                        }
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            } else {
                ResolvedCall<? extends CallableDescriptor> resolvedCall3;
                ResolvedCall<? extends CallableDescriptor> resolvedCall4 = resolvedCall3 = CallUtilKt.getResolvedCall($this$hasSuspendCalls, this.getBindingContext());
                CallableDescriptor $this$any$iv = resolvedCall4 != null ? resolvedCall4.getResultingDescriptor() : null;
                FunctionDescriptor functionDescriptor = $this$any$iv instanceof FunctionDescriptor ? (FunctionDescriptor)$this$any$iv : null;
                boolean bl6 = functionDescriptor != null ? functionDescriptor.isSuspend() : false;
                if (bl6) {
                    bl = true;
                } else {
                    String s;
                    ResolvedCall<? extends CallableDescriptor> resolvedCall5 = resolvedCall3;
                    $this$any$iv = resolvedCall5 != null ? resolvedCall5.getResultingDescriptor() : null;
                    PropertyDescriptor propertyDescriptor = $this$any$iv instanceof PropertyDescriptor ? (PropertyDescriptor)$this$any$iv : null;
                    Object object = propertyDescriptor;
                    String string2 = s = object != null && (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) != null ? ((FqName)object).asString() : null;
                    bl = (string2 != null ? StringsKt.startsWith$default(string2, "kotlin.coroutines.", false, 2, null) : false) && StringsKt.endsWith$default(s, ".coroutineContext", false, 2, null);
                }
            }
        }
        return bl;
    }

    private static final boolean visitNamedFunction$lambda$0(RedundantSuspendModifier this$0, KtExpression it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.hasSuspendCalls(it);
    }
}

