/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.documentation;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.documentation.LicenceHeaderLoaderExtensionKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.ranges.IntRange;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001aH\u0016J\f\u0010\u001e\u001a\u00020\u0013*\u00020\u001aH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\u00020\u00138BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0011\u0012\u0004\b\u0014\u0010\r\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/AbsentOrWrongFileLicense;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "licenseTemplateFile", "", "getLicenseTemplateFile$annotations", "()V", "getLicenseTemplateFile", "()Ljava/lang/String;", "licenseTemplateFile$delegate", "Lkotlin/properties/ReadOnlyProperty;", "licenseTemplateIsRegex", "", "getLicenseTemplateIsRegex$annotations", "getLicenseTemplateIsRegex", "()Z", "licenseTemplateIsRegex$delegate", "visitCondition", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitKtFile", "", "file", "hasValidLicense", "Companion", "detekt-rules-documentation"})
public final class AbsentOrWrongFileLicense
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty licenseTemplateFile$delegate;
    @NotNull
    private final ReadOnlyProperty licenseTemplateIsRegex$delegate;
    @NotNull
    public static final String PARAM_LICENSE_TEMPLATE_FILE = "licenseTemplateFile";
    @NotNull
    public static final String DEFAULT_LICENSE_TEMPLATE_FILE = "license.template";
    @NotNull
    public static final String PARAM_LICENSE_TEMPLATE_IS_REGEX = "licenseTemplateIsRegex";
    public static final boolean DEFAULT_LICENSE_TEMPLATE_IS_REGEX = false;
    @NotNull
    private static final String RULE_NAME;

    public AbsentOrWrongFileLicense(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue(RULE_NAME, Severity.Maintainability, "License text is absent or incorrect.", Debt.Companion.getFIVE_MINS());
        this.licenseTemplateFile$delegate = ConfigPropertyKt.config(DEFAULT_LICENSE_TEMPLATE_FILE);
        this.licenseTemplateIsRegex$delegate = ConfigPropertyKt.config(false);
    }

    public /* synthetic */ AbsentOrWrongFileLicense(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final String getLicenseTemplateFile() {
        return (String)this.licenseTemplateFile$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="path to file with license header template resolved relatively to config file")
    private static /* synthetic */ void getLicenseTemplateFile$annotations() {
    }

    private final boolean getLicenseTemplateIsRegex() {
        return (Boolean)this.licenseTemplateIsRegex$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Configuration(description="whether or not the license header template is a regex template")
    private static /* synthetic */ void getLicenseTemplateIsRegex$annotations() {
    }

    @Override
    public boolean visitCondition(@NotNull KtFile root) {
        Intrinsics.checkNotNullParameter(root, "root");
        return super.visitCondition(root) && (LicenceHeaderLoaderExtensionKt.hasLicenseHeader(root) || LicenceHeaderLoaderExtensionKt.hasLicenseHeaderRegex(root));
    }

    @Override
    public void visitKtFile(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        if (!this.hasValidLicense(file2)) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.atPackageOrFirstDecl(file2), "Expected license not found or incorrect in the file: " + file2.getName() + '.', null, null, 24, null));
        }
    }

    private final boolean hasValidLicense(KtFile $this$hasValidLicense) {
        boolean bl;
        if (LicenceHeaderLoaderExtensionKt.hasLicenseHeaderRegex($this$hasValidLicense)) {
            Regex regex = LicenceHeaderLoaderExtensionKt.getLicenseHeaderRegex($this$hasValidLicense);
            String string2 = $this$hasValidLicense.getText();
            Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
            Object object = Regex.find$default(regex, string2, 0, 2, null);
            bl = object != null && (object = object.getRange()) != null ? ((IntRange)object).getStart() == 0 : false;
        } else {
            String string3 = $this$hasValidLicense.getText();
            Intrinsics.checkNotNullExpressionValue(string3, "getText(...)");
            bl = StringsKt.startsWith$default(string3, LicenceHeaderLoaderExtensionKt.getLicenseHeader($this$hasValidLicense), false, 2, null);
        }
        return bl;
    }

    public AbsentOrWrongFileLicense() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(AbsentOrWrongFileLicense.class, PARAM_LICENSE_TEMPLATE_FILE, "getLicenseTemplateFile()Ljava/lang/String;", 0)), Reflection.property1(new PropertyReference1Impl(AbsentOrWrongFileLicense.class, PARAM_LICENSE_TEMPLATE_IS_REGEX, "getLicenseTemplateIsRegex()Z", 0))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        String string2 = AbsentOrWrongFileLicense.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        RULE_NAME = string2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/AbsentOrWrongFileLicense$Companion;", "", "<init>", "()V", "PARAM_LICENSE_TEMPLATE_FILE", "", "DEFAULT_LICENSE_TEMPLATE_FILE", "PARAM_LICENSE_TEMPLATE_IS_REGEX", "DEFAULT_LICENSE_TEMPLATE_IS_REGEX", "", "RULE_NAME", "getRULE_NAME", "()Ljava/lang/String;", "detekt-rules-documentation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getRULE_NAME() {
            return RULE_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

