/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.documentation;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocSection;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocTag;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/DeprecatedBlockTag;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitDeclaration", "", "dcl", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "detekt-rules-documentation"})
@SourceDebugExtension(value={"SMAP\nDeprecatedBlockTag.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeprecatedBlockTag.kt\nio/gitlab/arturbosch/detekt/rules/documentation/DeprecatedBlockTag\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1863#2:68\n1863#2,2:69\n1864#2:71\n*S KotlinDebug\n*F\n+ 1 DeprecatedBlockTag.kt\nio/gitlab/arturbosch/detekt/rules/documentation/DeprecatedBlockTag\n*L\n52#1:68\n53#1:69,2\n52#1:71\n*E\n"})
public final class DeprecatedBlockTag
extends Rule {
    @NotNull
    private final Issue issue;

    public DeprecatedBlockTag(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("DeprecatedBlockTag", Severity.Defect, "Do not use the `@deprecated` block tag, which is not supported by KDoc. Use the `@Deprecated` annotation instead.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ DeprecatedBlockTag(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitDeclaration(@NotNull KtDeclaration dcl) {
        block2: {
            Intrinsics.checkNotNullParameter(dcl, "dcl");
            super.visitDeclaration(dcl);
            Object object = dcl.getDocComment();
            if (object == null || (object = object.getAllSections()) == null) break block2;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KDocSection section2 = (KDocSection)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv2 = section2.findTagsByName("deprecated");
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    KDocTag tag = (KDocTag)element$iv2;
                    boolean bl2 = false;
                    this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, dcl, 0, 2, null), "@deprecated tag block does not properly report deprecation in Kotlin, use @Deprecated annotation instead", null, CollectionsKt.listOf(Entity.Companion.from$default(Entity.Companion, tag, 0, 2, null)), 8, null));
                }
            }
        }
    }

    public DeprecatedBlockTag() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

