/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.documentation;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.TraversingKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u001b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\u000b2\u0006\u0010/\u001a\u000200H\u0002J\f\u00102\u001a\u00020\u000b*\u00020-H\u0002J\f\u00103\u001a\u00020\u000b*\u00020)H\u0002J\f\u00104\u001a\u00020\u000b*\u00020)H\u0002J\f\u00105\u001a\u00020\u000b*\u00020)H\u0002J\f\u00106\u001a\u00020\u000b*\u000200H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0011\u0012\u0004\b\u0013\u0010\r\u001a\u0004\b\u0014\u0010\u000fR!\u0010\u0016\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0011\u0012\u0004\b\u0017\u0010\r\u001a\u0004\b\u0018\u0010\u000fR!\u0010\u001a\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u0011\u0012\u0004\b\u001b\u0010\r\u001a\u0004\b\u001c\u0010\u000fR!\u0010\u001e\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\u0011\u0012\u0004\b\u001f\u0010\r\u001a\u0004\b \u0010\u000fR!\u0010\"\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010\u0011\u0012\u0004\b#\u0010\r\u001a\u0004\b$\u0010\u000f\u00a8\u00067"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/UndocumentedPublicClass;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "searchInNestedClass", "", "getSearchInNestedClass$annotations", "()V", "getSearchInNestedClass", "()Z", "searchInNestedClass$delegate", "Lkotlin/properties/ReadOnlyProperty;", "searchInInnerClass", "getSearchInInnerClass$annotations", "getSearchInInnerClass", "searchInInnerClass$delegate", "searchInInnerObject", "getSearchInInnerObject$annotations", "getSearchInInnerObject", "searchInInnerObject$delegate", "searchInInnerInterface", "getSearchInInnerInterface$annotations", "getSearchInInnerInterface", "searchInInnerInterface$delegate", "searchInProtectedClass", "getSearchInProtectedClass$annotations", "getSearchInProtectedClass", "searchInProtectedClass$delegate", "ignoreDefaultCompanionObject", "getIgnoreDefaultCompanionObject$annotations", "getIgnoreDefaultCompanionObject", "ignoreDefaultCompanionObject$delegate", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "requiresDocumentation", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "reportIfUndocumented", "element", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "isPublicAndPublicInherited", "isDefaultCompanionObject", "isNestedClass", "isInnerClass", "isInnerInterface", "notEnumEntry", "detekt-rules-documentation"})
public final class UndocumentedPublicClass
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty searchInNestedClass$delegate;
    @NotNull
    private final ReadOnlyProperty searchInInnerClass$delegate;
    @NotNull
    private final ReadOnlyProperty searchInInnerObject$delegate;
    @NotNull
    private final ReadOnlyProperty searchInInnerInterface$delegate;
    @NotNull
    private final ReadOnlyProperty searchInProtectedClass$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreDefaultCompanionObject$delegate;

    public UndocumentedPublicClass(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Maintainability, "Public classes, interfaces and objects require documentation.", Debt.Companion.getTWENTY_MINS());
        this.searchInNestedClass$delegate = ConfigPropertyKt.config(true);
        this.searchInInnerClass$delegate = ConfigPropertyKt.config(true);
        this.searchInInnerObject$delegate = ConfigPropertyKt.config(true);
        this.searchInInnerInterface$delegate = ConfigPropertyKt.config(true);
        this.searchInProtectedClass$delegate = ConfigPropertyKt.config(false);
        this.ignoreDefaultCompanionObject$delegate = ConfigPropertyKt.config(false);
    }

    public /* synthetic */ UndocumentedPublicClass(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getSearchInNestedClass() {
        return (Boolean)this.searchInNestedClass$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="if nested classes should be searched")
    private static /* synthetic */ void getSearchInNestedClass$annotations() {
    }

    private final boolean getSearchInInnerClass() {
        return (Boolean)this.searchInInnerClass$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Configuration(description="if inner classes should be searched")
    private static /* synthetic */ void getSearchInInnerClass$annotations() {
    }

    private final boolean getSearchInInnerObject() {
        return (Boolean)this.searchInInnerObject$delegate.getValue(this, $$delegatedProperties[2]);
    }

    @Configuration(description="if inner objects should be searched")
    private static /* synthetic */ void getSearchInInnerObject$annotations() {
    }

    private final boolean getSearchInInnerInterface() {
        return (Boolean)this.searchInInnerInterface$delegate.getValue(this, $$delegatedProperties[3]);
    }

    @Configuration(description="if inner interfaces should be searched")
    private static /* synthetic */ void getSearchInInnerInterface$annotations() {
    }

    private final boolean getSearchInProtectedClass() {
        return (Boolean)this.searchInProtectedClass$delegate.getValue(this, $$delegatedProperties[4]);
    }

    @Configuration(description="if protected classes should be searched")
    private static /* synthetic */ void getSearchInProtectedClass$annotations() {
    }

    private final boolean getIgnoreDefaultCompanionObject() {
        return (Boolean)this.ignoreDefaultCompanionObject$delegate.getValue(this, $$delegatedProperties[5]);
    }

    @Configuration(description="whether default companion objects should be exempted")
    private static /* synthetic */ void getIgnoreDefaultCompanionObject$annotations() {
    }

    @Override
    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        if (this.requiresDocumentation(klass)) {
            this.reportIfUndocumented(klass);
        }
        super.visitClass(klass);
    }

    private final boolean requiresDocumentation(KtClass klass) {
        return klass.isTopLevel() || this.isInnerClass(klass) || this.isNestedClass(klass) || this.isInnerInterface(klass);
    }

    @Override
    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
        boolean isNonPublicCompanionWithoutNameOrDisabled;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        boolean bl = isNonPublicCompanionWithoutNameOrDisabled = this.isDefaultCompanionObject(declaration) && (!KtPsiUtilKt.isPublic(declaration) || this.getIgnoreDefaultCompanionObject());
        if (isNonPublicCompanionWithoutNameOrDisabled || declaration.isLocal() || !this.getSearchInInnerObject()) {
            return;
        }
        this.reportIfUndocumented(declaration);
        super.visitObjectDeclaration(declaration);
    }

    private final void reportIfUndocumented(KtClassOrObject element) {
        if (this.isPublicAndPublicInherited(element) && this.notEnumEntry(element) && element.getDocComment() == null) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.atName(element), element.getNameAsSafeName() + " is missing required documentation.", null, null, 24, null));
        }
    }

    private final boolean isPublicAndPublicInherited(KtClassOrObject element) {
        return TraversingKt.isPublicInherited(element, this.getSearchInProtectedClass()) && KtModifierListKt.isPublicNotOverridden(element, this.getSearchInProtectedClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDefaultCompanionObject(KtObjectDeclaration $this$isDefaultCompanionObject) {
        if (!$this$isDefaultCompanionObject.isCompanion()) return false;
        if (!Intrinsics.areEqual($this$isDefaultCompanionObject.getNameAsSafeName().asString(), "Companion")) return false;
        PsiElement psiElement = $this$isDefaultCompanionObject.getNameIdentifier();
        if (Intrinsics.areEqual(psiElement != null ? psiElement.getText() : null, "Companion")) return false;
        return true;
    }

    private final boolean isNestedClass(KtClass $this$isNestedClass) {
        return !$this$isNestedClass.isInterface() && !$this$isNestedClass.isTopLevel() && !$this$isNestedClass.isInner() && this.getSearchInNestedClass();
    }

    private final boolean isInnerClass(KtClass $this$isInnerClass) {
        return !$this$isInnerClass.isInterface() && $this$isInnerClass.isInner() && this.getSearchInInnerClass();
    }

    private final boolean isInnerInterface(KtClass $this$isInnerInterface) {
        return !$this$isInnerInterface.isTopLevel() && $this$isInnerInterface.isInterface() && this.getSearchInInnerInterface();
    }

    private final boolean notEnumEntry(KtClassOrObject $this$notEnumEntry) {
        return !($this$notEnumEntry instanceof KtEnumEntry);
    }

    public UndocumentedPublicClass() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(UndocumentedPublicClass.class, "searchInNestedClass", "getSearchInNestedClass()Z", 0)), Reflection.property1(new PropertyReference1Impl(UndocumentedPublicClass.class, "searchInInnerClass", "getSearchInInnerClass()Z", 0)), Reflection.property1(new PropertyReference1Impl(UndocumentedPublicClass.class, "searchInInnerObject", "getSearchInInnerObject()Z", 0)), Reflection.property1(new PropertyReference1Impl(UndocumentedPublicClass.class, "searchInInnerInterface", "getSearchInInnerInterface()Z", 0)), Reflection.property1(new PropertyReference1Impl(UndocumentedPublicClass.class, "searchInProtectedClass", "getSearchInProtectedClass()Z", 0)), Reflection.property1(new PropertyReference1Impl(UndocumentedPublicClass.class, "ignoreDefaultCompanionObject", "getIgnoreDefaultCompanionObject()Z", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

