/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.empty;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.rules.empty.EmptyRule;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\r\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/rules/empty/EmptyDefaultConstructor;", "Lio/gitlab/arturbosch/detekt/rules/empty/EmptyRule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "visitPrimaryConstructor", "", "constructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "isExpectedOrActualClass", "", "hasSuitableSignature", "hasPublicVisibility", "visibility", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "isNotCalled", "detekt-rules-empty"})
@SourceDebugExtension(value={"SMAP\nEmptyDefaultConstructor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmptyDefaultConstructor.kt\nio/gitlab/arturbosch/detekt/rules/empty/EmptyDefaultConstructor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n2632#2,3:57\n*S KotlinDebug\n*F\n+ 1 EmptyDefaultConstructor.kt\nio/gitlab/arturbosch/detekt/rules/empty/EmptyDefaultConstructor\n*L\n51#1:57,3\n*E\n"})
public final class EmptyDefaultConstructor
extends EmptyRule {
    public EmptyDefaultConstructor(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, null, 6, null);
    }

    @Override
    public void visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor) {
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        if (this.hasSuitableSignature(constructor) && this.isNotCalled(constructor) && !this.isExpectedOrActualClass(constructor)) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, constructor, 0, 2, null), "An empty default constructor can be removed.", null, null, 24, null));
        }
    }

    private final boolean isExpectedOrActualClass(KtPrimaryConstructor constructor) {
        PsiElement parent2 = constructor.getParent();
        if (parent2 instanceof KtClass) {
            return PsiUtilsKt.hasExpectModifier((KtModifierListOwner)parent2) || PsiUtilsKt.hasActualModifier((KtModifierListOwner)parent2);
        }
        return false;
    }

    private final boolean hasSuitableSignature(KtPrimaryConstructor constructor) {
        return this.hasPublicVisibility(KtPsiUtilKt.visibilityModifierType(constructor)) && constructor.getAnnotationEntries().isEmpty() && constructor.getValueParameters().isEmpty();
    }

    private final boolean hasPublicVisibility(KtModifierKeywordToken visibility) {
        return visibility == null || Intrinsics.areEqual(visibility, KtTokens.PUBLIC_KEYWORD);
    }

    private final boolean isNotCalled(KtPrimaryConstructor constructor) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = constructor.getContainingClassOrObject().getSecondaryConstructors();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    KtSecondaryConstructor it = (KtSecondaryConstructor)element$iv;
                    boolean bl2 = false;
                    if (!(it.getDelegationCall().isCallToThis() && it.getDelegationCall().getValueArguments().isEmpty())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }
}

