/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.exceptions;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/InstanceOfCheckForException;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCatchSection", "", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "isCheckForSubTypeOf", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "catchParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "detekt-rules-exceptions"})
@SourceDebugExtension(value={"SMAP\nInstanceOfCheckForException.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstanceOfCheckForException.kt\nio/gitlab/arturbosch/detekt/rules/exceptions/InstanceOfCheckForException\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,85:1\n222#2,9:86\n241#2:95\n*S KotlinDebug\n*F\n+ 1 InstanceOfCheckForException.kt\nio/gitlab/arturbosch/detekt/rules/exceptions/InstanceOfCheckForException\n*L\n61#1:86,9\n61#1:95\n*E\n"})
public final class InstanceOfCheckForException
extends Rule {
    @NotNull
    private final Issue issue;

    public InstanceOfCheckForException(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("InstanceOfCheckForException", Severity.CodeSmell, "Instead of catching for a general exception type and checking for a specific exception type, use multiple catch blocks.", Debt.Companion.getTWENTY_MINS());
    }

    public /* synthetic */ InstanceOfCheckForException(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitCatchSection(@NotNull KtCatchClause catchClause) {
        block1: {
            void $this$forEachDescendantOfType$iv;
            Intrinsics.checkNotNullParameter(catchClause, "catchClause");
            KtParameter ktParameter = catchClause.getCatchParameter();
            if (ktParameter == null) {
                return;
            }
            KtParameter catchParameter = ktParameter;
            KtExpression ktExpression = catchClause.getCatchBody();
            if (ktExpression == null) break block1;
            PsiElement psiElement = ktExpression;
            Function1<KtExpression, Unit> action$iv = arg_0 -> InstanceOfCheckForException.visitCatchSection$lambda$0(this, catchParameter, arg_0);
            boolean $i$f$forEachDescendantOfType = false;
            void $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
            boolean $i$f$forEachDescendantOfType2 = false;
            PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv);
            $this$forEachDescendantOfType$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $action;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtExpression) {
                        this.$action.invoke(element);
                    }
                }
            });
        }
    }

    private final boolean isCheckForSubTypeOf(KtExpression $this$isCheckForSubTypeOf, KtParameter catchParameter) {
        boolean bl;
        String leftText;
        KtExpression ktExpression = $this$isCheckForSubTypeOf;
        Pair<KtExpression, KtTypeReference> pair = ktExpression instanceof KtIsExpression ? TuplesKt.to(((KtIsExpression)$this$isCheckForSubTypeOf).getLeftHandSide(), ((KtIsExpression)$this$isCheckForSubTypeOf).getTypeReference()) : (ktExpression instanceof KtBinaryExpressionWithTypeRHS ? (KtPsiUtil.isUnsafeCast((KtBinaryExpressionWithTypeRHS)$this$isCheckForSubTypeOf) ? TuplesKt.to(((KtBinaryExpressionWithTypeRHS)$this$isCheckForSubTypeOf).getLeft(), ((KtBinaryExpressionWithTypeRHS)$this$isCheckForSubTypeOf).getRight()) : null) : null);
        if (pair == null) {
            return false;
        }
        Pair<KtExpression, KtTypeReference> pair2 = pair;
        KtExpression ktExpression2 = pair2.component1();
        Intrinsics.checkNotNullExpressionValue(ktExpression2, "component1(...)");
        KtExpression left = ktExpression2;
        KtTypeReference right = pair2.component2();
        KtNameReferenceExpression ktNameReferenceExpression = left instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)left : null;
        String string2 = leftText = ktNameReferenceExpression != null ? ktNameReferenceExpression.getText() : null;
        if (Intrinsics.areEqual(leftText, catchParameter.getName())) {
            KotlinType rightType = (KotlinType)this.getBindingContext().get(BindingContext.TYPE, right);
            KotlinType catchType = (KotlinType)this.getBindingContext().get(BindingContext.TYPE, catchParameter.getTypeReference());
            bl = rightType != null && catchType != null ? TypeUtilsKt.isSubtypeOf(rightType, catchType) : true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final Unit visitCatchSection$lambda$0(InstanceOfCheckForException this$0, KtParameter $catchParameter, KtExpression it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (this$0.isCheckForSubTypeOf(it, $catchParameter)) {
            this$0.report(new CodeSmell(this$0.getIssue(), Entity.Companion.from$default(Entity.Companion, it, 0, 2, null), this$0.getIssue().getDescription(), null, null, 24, null));
        }
        return Unit.INSTANCE;
    }

    public InstanceOfCheckForException() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }
}

