/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.exceptions;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0016\u0010\u001d\u001a\u00020\u000b*\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/ReturnFromFinally;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "ignoreLabeled", "", "getIgnoreLabeled$annotations", "()V", "getIgnoreLabeled", "()Z", "ignoreLabeled$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitTryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtTryExpression;", "isReturnFromTargetFunction", "blockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "returnStmts", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "canFilterLabeledExpression", "returnStmt", "typeEqualsTo", "Lorg/jetbrains/kotlin/psi/KtFinallySection;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "detekt-rules-exceptions"})
@SourceDebugExtension(value={"SMAP\nReturnFromFinally.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReturnFromFinally.kt\nio/gitlab/arturbosch/detekt/rules/exceptions/ReturnFromFinally\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n310#2,14:109\n229#2,2:123\n241#2:125\n328#2:126\n1863#3,2:127\n*S KotlinDebug\n*F\n+ 1 ReturnFromFinally.kt\nio/gitlab/arturbosch/detekt/rules/exceptions/ReturnFromFinally\n*L\n76#1:109,14\n76#1:123,2\n76#1:125\n76#1:126\n80#1:127,2\n*E\n"})
public final class ReturnFromFinally
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty ignoreLabeled$delegate;

    public ReturnFromFinally(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("ReturnFromFinally", Severity.Defect, "Do not return within a finally statement. This can discard exceptions.", Debt.Companion.getTWENTY_MINS());
        this.ignoreLabeled$delegate = ConfigPropertyKt.config(false);
    }

    public /* synthetic */ ReturnFromFinally(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getIgnoreLabeled() {
        return (Boolean)this.ignoreLabeled$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="ignores labeled return statements")
    private static /* synthetic */ void getIgnoreLabeled$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitTryExpression(@NotNull KtTryExpression expression2) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        void $this$collectDescendantsOfType$iv;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitTryExpression(expression2);
        KtFinallySection ktFinallySection = expression2.getFinallyBlock();
        if (ktFinallySection == null) {
            return;
        }
        KtFinallySection finallyBlock = ktFinallySection;
        if (BindingContextUtilsKt.isUsedAsExpression(expression2, this.getBindingContext()) && this.typeEqualsTo(finallyBlock, CallUtilKt.getType(expression2, this.getBindingContext()))) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, finallyBlock, 0, 2, null), "Contents of the finally block do not affect the result of the expression.", null, null, 24, null));
        }
        KtBlockExpression ktBlockExpression = finallyBlock.getFinalExpression();
        Intrinsics.checkNotNullExpressionValue(ktBlockExpression, "getFinalExpression(...)");
        PsiElement psiElement = ktBlockExpression;
        Function1<KtReturnExpression, Boolean> predicate$iv = arg_0 -> ReturnFromFinally.visitTryExpression$lambda$0(this, finallyBlock, arg_0);
        boolean $i$f$collectDescendantsOfType = false;
        void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        void var8_11 = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var11_15 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = new Function1<KtReturnExpression, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(PsiElement it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (((Boolean)this.$predicate.invoke(it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtReturnExpression) {
                    this.$action.invoke(element);
                }
            }
        });
        Iterable $this$forEach$iv = (List)to$iv$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtReturnExpression it = (KtReturnExpression)element$iv;
            boolean bl = false;
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, it, 0, 2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    private final boolean isReturnFromTargetFunction(KtBlockExpression blockExpression, KtReturnExpression returnStmts) {
        KtCallableDeclaration ktCallableDeclaration = BindingContextUtilsKt.getTargetFunction(returnStmts, this.getBindingContext());
        if (ktCallableDeclaration == null) {
            return false;
        }
        KtCallableDeclaration targetFunction = ktCallableDeclaration;
        Iterable<KtElement> targetFunctionBodyExpressionStatements = SequencesKt.asIterable(KtPsiUtilKt.blockExpressionsOrSingle(targetFunction));
        return PsiUtilsKt.isInsideOf(blockExpression, targetFunctionBodyExpressionStatements);
    }

    private final boolean canFilterLabeledExpression(KtReturnExpression returnStmt) {
        return !this.getIgnoreLabeled() || returnStmt.getLabeledExpression() == null;
    }

    private final boolean typeEqualsTo(KtFinallySection $this$typeEqualsTo, KotlinType type2) {
        KtBlockExpression finallyExpression = $this$typeEqualsTo.getFinalExpression();
        if (finallyExpression.getStatements().isEmpty()) {
            return false;
        }
        KtBlockExpression ktBlockExpression = $this$typeEqualsTo.getFinalExpression();
        Intrinsics.checkNotNullExpressionValue(ktBlockExpression, "getFinalExpression(...)");
        return Intrinsics.areEqual(CallUtilKt.getType(ktBlockExpression, this.getBindingContext()), type2);
    }

    private static final boolean visitTryExpression$lambda$0(ReturnFromFinally this$0, KtFinallySection $finallyBlock, KtReturnExpression returnExpression) {
        Intrinsics.checkNotNullParameter(returnExpression, "returnExpression");
        KtBlockExpression ktBlockExpression = $finallyBlock.getFinalExpression();
        Intrinsics.checkNotNullExpressionValue(ktBlockExpression, "getFinalExpression(...)");
        return this$0.isReturnFromTargetFunction(ktBlockExpression, returnExpression) && this$0.canFilterLabeledExpression(returnExpression);
    }

    public ReturnFromFinally() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(ReturnFromFinally.class, "ignoreLabeled", "getIgnoreLabeled()Z", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

