/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.exceptions;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.AllowedExceptionNamePatternKt;
import io.gitlab.arturbosch.detekt.rules.exceptions.SwallowedException;
import io.gitlab.arturbosch.detekt.rules.exceptions.SwallowedException$parameterReferences$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 )2\u00020\u0001:\u0001)B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J$\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u000b*\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\f2\u0006\u0010%\u001a\u00020\"H\u0002J(\u0010&\u001a\u0004\u0018\u00010\"*\u00020\"2\b\u0010'\u001a\u0004\u0018\u00010\f2\u0006\u0010(\u001a\u00020\f2\u0006\u0010%\u001a\u00020\"H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR'\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0013\u001a\u00020\u00148BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0012\u0012\u0004\b\u0015\u0010\u000e\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006*"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/SwallowedException;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "ignoredExceptionTypes", "", "", "getIgnoredExceptionTypes$annotations", "()V", "getIgnoredExceptionTypes", "()Ljava/util/List;", "ignoredExceptionTypes$delegate", "Lkotlin/properties/ReadOnlyProperty;", "allowedExceptionNameRegex", "Lkotlin/text/Regex;", "getAllowedExceptionNameRegex$annotations", "getAllowedExceptionNameRegex", "()Lkotlin/text/Regex;", "allowedExceptionNameRegex$delegate", "visitCatchSection", "", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "isExceptionSwallowedOrUnused", "", "isExceptionUnused", "isExceptionSwallowed", "parameterReferences", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "parameterName", "catchBody", "findReferenceInVariable", "referenceName", "variableName", "Companion", "detekt-rules-exceptions"})
@SourceDebugExtension(value={"SMAP\nSwallowedException.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwallowedException.kt\nio/gitlab/arturbosch/detekt/rules/exceptions/SwallowedException\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1755#2,3:180\n1611#2,9:226\n1863#2:235\n1864#2:237\n1620#2:238\n1557#2:240\n1628#2,3:241\n1734#2,3:244\n266#3:183\n277#3,10:184\n299#3:194\n266#3:195\n277#3,10:196\n299#3:206\n309#3,15:207\n229#3,2:222\n241#3:224\n328#3:225\n142#3:239\n277#3,10:247\n299#3:257\n142#3:259\n1#4:236\n1#4:258\n*S KotlinDebug\n*F\n+ 1 SwallowedException.kt\nio/gitlab/arturbosch/detekt/rules/exceptions/SwallowedException\n*L\n92#1:180,3\n129#1:226,9\n129#1:235\n129#1:237\n129#1:238\n83#1:240\n83#1:241,3\n118#1:244,3\n108#1:183\n108#1:184,10\n108#1:194\n116#1:195\n116#1:196,10\n116#1:206\n128#1:207,15\n128#1:222,2\n128#1:224\n128#1:225\n148#1:239\n151#1:247,10\n151#1:257\n163#1:259\n129#1:236\n*E\n"})
public final class SwallowedException
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty ignoredExceptionTypes$delegate;
    @NotNull
    private final ReadOnlyProperty allowedExceptionNameRegex$delegate;
    @NotNull
    private static final List<String> EXCEPTIONS_IGNORED_BY_DEFAULT;

    public SwallowedException(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("SwallowedException", Severity.CodeSmell, "The caught exception is swallowed. The original exception could be lost.", Debt.Companion.getTWENTY_MINS());
        this.ignoredExceptionTypes$delegate = ConfigPropertyKt.config(EXCEPTIONS_IGNORED_BY_DEFAULT, SwallowedException::ignoredExceptionTypes_delegate$lambda$1);
        this.allowedExceptionNameRegex$delegate = ConfigPropertyKt.config("_|(ignore|expected).*", allowedExceptionNameRegex.2.INSTANCE);
    }

    public /* synthetic */ SwallowedException(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<String> getIgnoredExceptionTypes() {
        return (List)this.ignoredExceptionTypes$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="exception types which should be ignored (both in the catch clause and body)")
    private static /* synthetic */ void getIgnoredExceptionTypes$annotations() {
    }

    private final Regex getAllowedExceptionNameRegex() {
        return (Regex)this.allowedExceptionNameRegex$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Configuration(description="ignores too generic exception types which match this regex")
    private static /* synthetic */ void getAllowedExceptionNameRegex$annotations() {
    }

    @Override
    public void visitCatchSection(@NotNull KtCatchClause catchClause) {
        Intrinsics.checkNotNullParameter(catchClause, "catchClause");
        KtParameter ktParameter = catchClause.getCatchParameter();
        if (ktParameter != null) {
            boolean bl;
            KtParameter catchParameter;
            block5: {
                catchParameter = ktParameter;
                boolean bl2 = false;
                KtTypeReference ktTypeReference = catchParameter.getTypeReference();
                String exceptionType = ktTypeReference != null ? ktTypeReference.getText() : null;
                Iterable $this$any$iv = this.getIgnoredExceptionTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        String string2 = exceptionType;
                        boolean bl4 = string2 != null ? StringsKt.contains((CharSequence)string2, it, true) : false;
                        if (!bl4) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl && this.isExceptionSwallowedOrUnused(catchClause) && !AllowedExceptionNamePatternKt.isAllowedExceptionName(catchClause, this.getAllowedExceptionNameRegex())) {
                this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, catchParameter, 0, 2, null), this.getIssue().getDescription(), null, null, 24, null));
            }
        }
        super.visitCatchSection(catchClause);
    }

    private final boolean isExceptionSwallowedOrUnused(KtCatchClause catchClause) {
        return this.isExceptionUnused(catchClause) || this.isExceptionSwallowed(catchClause);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isExceptionUnused(KtCatchClause catchClause) {
        void $this$anyDescendantOfType$iv;
        KtParameter ktParameter = catchClause.getCatchParameter();
        String parameterName = ktParameter != null ? ktParameter.getName() : null;
        KtExpression ktExpression = catchClause.getCatchBody();
        if (ktExpression == null) {
            return true;
        }
        KtExpression catchBody = ktExpression;
        PsiElement psiElement = catchBody;
        Function1<KtNameReferenceExpression, Boolean> predicate$iv = arg_0 -> SwallowedException.isExceptionUnused$lambda$4(this, parameterName, arg_0);
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtNameReferenceExpression && ((Boolean)this.$predicate.invoke(element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return !((PsiElement)result$iv$iv$iv.element != null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isExceptionSwallowed(KtCatchClause catchClause) {
        void $this$anyDescendantOfType$iv;
        KtParameter ktParameter = catchClause.getCatchParameter();
        String parameterName = ktParameter != null ? ktParameter.getName() : null;
        KtExpression ktExpression = catchClause.getCatchBody();
        if (ktExpression == null) {
            return false;
        }
        KtExpression catchBody = ktExpression;
        PsiElement psiElement = catchBody;
        Function1<KtThrowExpression, Boolean> predicate$iv = arg_0 -> SwallowedException.isExceptionSwallowed$lambda$6(this, parameterName, catchBody, arg_0);
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtThrowExpression && ((Boolean)this.$predicate.invoke(element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtExpression> parameterReferences(KtThrowExpression $this$parameterReferences, String parameterName, KtExpression catchBody) {
        List list;
        List list2;
        Map parameterReferencesInVariables = new LinkedHashMap();
        KtExpression ktExpression = $this$parameterReferences.getThrownExpression();
        if (ktExpression != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$forEachDescendantOfType$iv$iv$iv$iv;
            void $this$collectDescendantsOfTypeTo$iv$iv$iv;
            Iterable $this$collectDescendantsOfType_u24default$iv;
            PsiElement psiElement = ktExpression;
            Function1 predicate$iv = parameterReferences$$inlined$collectDescendantsOfType$default$1.INSTANCE;
            boolean $i$f$collectDescendantsOfType22 = false;
            void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
            boolean $i$f$collectDescendantsOfType = false;
            void var11_13 = $this$collectDescendantsOfType$iv$iv;
            Collection to$iv$iv$iv = new ArrayList();
            boolean $i$f$collectDescendantsOfTypeTo = false;
            void var14_18 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
            Function1 action$iv$iv$iv$iv = new Function1<KtNameReferenceExpression, Unit>(predicate$iv, to$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Collection $to;
                {
                    this.$predicate = $predicate;
                    this.$to = $to;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(PsiElement it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    if (((Boolean)this.$predicate.invoke(it)).booleanValue()) {
                        this.$to.add(it);
                    }
                }
            };
            boolean $i$f$forEachDescendantOfType = false;
            PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
            $this$forEachDescendantOfType$iv$iv$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $action;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtNameReferenceExpression) {
                        this.$action.invoke(element);
                    }
                }
            });
            $this$collectDescendantsOfType_u24default$iv = (List)to$iv$iv$iv;
            boolean $i$f$mapNotNull = false;
            void $i$f$collectDescendantsOfType22 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                KtExpression ktExpression2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                KtNameReferenceExpression reference2 = (KtNameReferenceExpression)element$iv$iv;
                boolean bl2 = false;
                String referenceText = reference2.getText();
                if (Intrinsics.areEqual(referenceText, parameterName)) {
                    ktExpression2 = KtPsiUtilKt.getQualifiedExpressionForReceiverOrThis(reference2);
                } else {
                    ktExpression2 = (KtExpression)parameterReferencesInVariables.get(referenceText);
                    if (ktExpression2 == null) {
                        KtExpression ktExpression3 = reference2;
                        Intrinsics.checkNotNull(referenceText);
                        if (this.findReferenceInVariable(ktExpression3, parameterName, referenceText, catchBody) != null) {
                            KtExpression ktExpression4;
                            KtExpression it = ktExpression4;
                            boolean bl3 = false;
                            parameterReferencesInVariables.put(referenceText, it);
                            ktExpression2 = ktExpression4;
                        } else {
                            ktExpression2 = null;
                        }
                    }
                }
                if (ktExpression2 == null) continue;
                KtExpression it$iv$iv = ktExpression2;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final KtExpression findReferenceInVariable(KtExpression $this$findReferenceInVariable, String referenceName, String variableName, KtExpression catchBody) {
        PsiElement $this$getStrictParentOfType$iv = $this$findReferenceInVariable;
        boolean $i$f$getStrictParentOfType = false;
        KtBlockExpression ktBlockExpression = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtBlockExpression.class, true);
        if (ktBlockExpression == null) {
            return null;
        }
        KtBlockExpression block = ktBlockExpression;
        return SwallowedException.findReferenceInVariable$find(catchBody, variableName, referenceName, block);
    }

    /*
     * WARNING - void declaration
     */
    private static final List ignoredExceptionTypes_delegate$lambda$1(List exceptions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(exceptions, "exceptions");
        Iterable $this$map$iv = exceptions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.removeSuffix(StringsKt.removePrefix((String)it, (CharSequence)"*"), (CharSequence)"*"));
        }
        return (List)destination$iv$iv;
    }

    private static final boolean isExceptionUnused$lambda$4(SwallowedException this$0, String $parameterName, KtNameReferenceExpression it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.getIgnoredExceptionTypes().contains(it.getText()) || Intrinsics.areEqual(it.getText(), $parameterName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isExceptionSwallowed$lambda$6(SwallowedException this$0, String $parameterName, KtExpression $catchBody, KtThrowExpression throwExpr) {
        boolean bl;
        Intrinsics.checkNotNullParameter(throwExpr, "throwExpr");
        List<KtExpression> refs = this$0.parameterReferences(throwExpr, $parameterName, $catchBody);
        if (((Collection)refs).isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        Iterable $this$all$iv = refs;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            KtExpression it = (KtExpression)element$iv;
            boolean bl3 = false;
            if (!(it instanceof KtDotQualifiedExpression)) return false;
            if (((KtDotQualifiedExpression)it).getParent() instanceof KtThrowExpression) return false;
            bl = true;
        } while (bl);
        return false;
    }

    private static final boolean findReferenceInVariable$find$lambda$9(String $variableName, KtProperty it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getName(), $variableName);
    }

    /*
     * WARNING - void declaration
     */
    private static final KtExpression findReferenceInVariable$find(KtExpression $catchBody, String $variableName, String $referenceName, KtBlockExpression block) {
        KtExpression ktExpression;
        void $this$findDescendantOfType$iv;
        PsiElement psiElement = block;
        Function1<KtProperty, Boolean> predicate$iv = arg_0 -> SwallowedException.findReferenceInVariable$find$lambda$9($variableName, arg_0);
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$findDescendantOfType$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv);
        Ref.ObjectRef result$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                if (element instanceof KtProperty && ((Boolean)this.$predicate.invoke(element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        KtProperty ktProperty = (KtProperty)((PsiElement)result$iv$iv.element);
        if (ktProperty != null) {
            KtExpression it;
            KtProperty property = ktProperty;
            boolean bl = false;
            KtExpression initializer = property.getInitializer();
            if (initializer instanceof KtDotQualifiedExpression) {
                KtExpression ktExpression2 = initializer;
                it = (KtDotQualifiedExpression)ktExpression2;
                boolean bl2 = false;
                ktExpression = Intrinsics.areEqual(((KtDotQualifiedExpression)it).getReceiverExpression().getText(), $referenceName) ? ktExpression2 : null;
            } else {
                KtExpression ktExpression3;
                it = ktExpression3 = initializer;
                boolean bl3 = false;
                KtExpression ktExpression4 = it;
                ktExpression = Intrinsics.areEqual(ktExpression4 != null ? ktExpression4.getText() : null, $referenceName) ? ktExpression3 : null;
            }
        } else {
            ktExpression = null;
        }
        KtExpression reference2 = ktExpression;
        KtExpression ktExpression5 = reference2;
        if (ktExpression5 == null) {
            if (Intrinsics.areEqual(block, $catchBody)) {
                ktExpression5 = null;
            } else {
                PsiElement $this$getStrictParentOfType$iv = block;
                boolean $i$f$getStrictParentOfType = false;
                KtBlockExpression ktBlockExpression = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtBlockExpression.class, true);
                if (ktBlockExpression != null) {
                    KtBlockExpression it = ktBlockExpression;
                    boolean bl = false;
                    ktExpression5 = SwallowedException.findReferenceInVariable$find($catchBody, $variableName, $referenceName, it);
                } else {
                    ktExpression5 = null;
                }
            }
        }
        return ktExpression5;
    }

    public SwallowedException() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    @NotNull
    public static final List<String> getEXCEPTIONS_IGNORED_BY_DEFAULT() {
        return Companion.getEXCEPTIONS_IGNORED_BY_DEFAULT();
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(SwallowedException.class, "ignoredExceptionTypes", "getIgnoredExceptionTypes()Ljava/util/List;", 0)), Reflection.property1(new PropertyReference1Impl(SwallowedException.class, "allowedExceptionNameRegex", "getAllowedExceptionNameRegex()Lkotlin/text/Regex;", 0))};
        $$delegatedProperties = objectArray;
        Companion = new Companion(null);
        objectArray = new String[]{"InterruptedException", "MalformedURLException", "NumberFormatException", "ParseException"};
        EXCEPTIONS_IGNORED_BY_DEFAULT = CollectionsKt.listOf(objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/SwallowedException$Companion;", "", "<init>", "()V", "EXCEPTIONS_IGNORED_BY_DEFAULT", "", "", "getEXCEPTIONS_IGNORED_BY_DEFAULT$annotations", "getEXCEPTIONS_IGNORED_BY_DEFAULT", "()Ljava/util/List;", "detekt-rules-exceptions"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getEXCEPTIONS_IGNORED_BY_DEFAULT() {
            return EXCEPTIONS_IGNORED_BY_DEFAULT;
        }

        @JvmStatic
        public static /* synthetic */ void getEXCEPTIONS_IGNORED_BY_DEFAULT$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

