/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.IdentifierNameKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import io.gitlab.arturbosch.detekt.rules.naming.BooleanPropertyNaming;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBinding;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBindingKt;
import org.jetbrains.kotlin.types.KotlinType;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020!H\u0002R!\u0010\u0006\u001a\u00020\u00078BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR!\u0010\u000e\u001a\u00020\u000f8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\r\u0012\u0004\b\u0010\u0010\t\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006("}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/BooleanPropertyNaming;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "allowedPattern", "Lkotlin/text/Regex;", "getAllowedPattern$annotations", "()V", "getAllowedPattern", "()Lkotlin/text/Regex;", "allowedPattern$delegate", "Lkotlin/properties/ReadOnlyProperty;", "ignoreOverridden", "", "getIgnoreOverridden$annotations", "getIgnoreOverridden", "()Z", "ignoreOverridden$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitParameter", "", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "validateDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "reportCodeSmell", "Lio/gitlab/arturbosch/detekt/api/CodeSmell;", "name", "", "getTypeName", "Companion", "detekt-rules-naming"})
public final class BooleanPropertyNaming
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty allowedPattern$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreOverridden$delegate;
    @NotNull
    private final Issue issue;
    @NotNull
    public static final String KOTLIN_BOOLEAN_TYPE_NAME = "kotlin.Boolean";
    @NotNull
    public static final String JAVA_BOOLEAN_TYPE_NAME = "java.lang.Boolean";

    public BooleanPropertyNaming(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.allowedPattern$delegate = ConfigPropertyKt.config("^(is|has|are)", allowedPattern.2.INSTANCE);
        this.ignoreOverridden$delegate = ConfigPropertyKt.config(true);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.CodeSmell, "Boolean property name should follow the naming convention set in the projects configuration.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ BooleanPropertyNaming(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    private final Regex getAllowedPattern() {
        return (Regex)this.allowedPattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="naming pattern")
    private static /* synthetic */ void getAllowedPattern$annotations() {
    }

    private final boolean getIgnoreOverridden() {
        return (Boolean)this.ignoreOverridden$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Configuration(description="ignores properties that have the override modifier")
    @Deprecated(message="This configuration is ignored and will be removed in the future")
    private static /* synthetic */ void getIgnoreOverridden$annotations() {
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        super.visitParameter(parameter);
        if (parameter.hasValOrVar()) {
            this.validateDeclaration(parameter);
        }
    }

    @Override
    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter(property, "property");
        super.visitProperty(property);
        this.validateDeclaration(property);
    }

    private final void validateDeclaration(KtCallableDeclaration declaration) {
        boolean isNonConstantBooleanType;
        String name2 = IdentifierNameKt.identifierName(declaration);
        String typeName = this.getTypeName(declaration);
        boolean isBooleanType = Intrinsics.areEqual(typeName, KOTLIN_BOOLEAN_TYPE_NAME) || Intrinsics.areEqual(typeName, JAVA_BOOLEAN_TYPE_NAME);
        boolean bl = isNonConstantBooleanType = isBooleanType && !KtModifierListKt.isConstant(declaration);
        if (isNonConstantBooleanType) {
            CharSequence charSequence = name2;
            if (!this.getAllowedPattern().containsMatchIn(charSequence) && !KtModifierListKt.isOverride(declaration)) {
                this.report(this.reportCodeSmell(declaration, name2));
            }
        }
    }

    private final CodeSmell reportCodeSmell(KtCallableDeclaration declaration, String name2) {
        String description = "Boolean property name should match a " + this.getAllowedPattern() + " pattern.";
        return new CodeSmell(this.getIssue(), Entity.Companion.atName(declaration), description + " Actual name is " + name2, null, null, 24, null);
    }

    private final String getTypeName(KtCallableDeclaration parameter) {
        KotlinType kotlinType;
        TypeBinding<PsiElement> typeBinding = TypeBindingKt.createTypeBindingForReturnType(parameter, this.getBindingContext());
        return String.valueOf(typeBinding != null && (kotlinType = typeBinding.getType()) != null ? TypeUtilsKt.fqNameOrNull(kotlinType) : null);
    }

    public BooleanPropertyNaming() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(BooleanPropertyNaming.class, "allowedPattern", "getAllowedPattern()Lkotlin/text/Regex;", 0)), Reflection.property1(new PropertyReference1Impl(BooleanPropertyNaming.class, "ignoreOverridden", "getIgnoreOverridden()Z", 0))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/BooleanPropertyNaming$Companion;", "", "<init>", "()V", "KOTLIN_BOOLEAN_TYPE_NAME", "", "JAVA_BOOLEAN_TYPE_NAME", "detekt-rules-naming"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

