/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.Iterator;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u000bH\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\r\u001a\u00020\u000e8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0015\u001a\u00020\u000e8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0014\u0012\u0004\b\u0016\u0010\u0010\u001a\u0004\b\u0017\u0010\u0012\u00a8\u0006*"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/MemberNameEqualsClassName;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "classMessage", "", "objectMessage", "ignoreOverriddenFunction", "", "getIgnoreOverriddenFunction$annotations", "()V", "getIgnoreOverriddenFunction", "()Z", "ignoreOverriddenFunction$delegate", "Lkotlin/properties/ReadOnlyProperty;", "ignoreOverridden", "getIgnoreOverridden$annotations", "getIgnoreOverridden", "ignoreOverridden$delegate", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "getMisnamedMembers", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "klassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "name", "getMisnamedCompanionObjectMembers", "isFactoryMethod", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "detekt-rules-naming"})
@SourceDebugExtension(value={"SMAP\nMemberNameEqualsClassName.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemberNameEqualsClassName.kt\nio/gitlab/arturbosch/detekt/rules/naming/MemberNameEqualsClassName\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,127:1\n1317#2,2:128\n1317#2,2:130\n*S KotlinDebug\n*F\n+ 1 MemberNameEqualsClassName.kt\nio/gitlab/arturbosch/detekt/rules/naming/MemberNameEqualsClassName\n*L\n83#1:128,2\n91#1:130,2\n*E\n"})
public final class MemberNameEqualsClassName
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final String classMessage;
    @NotNull
    private final String objectMessage;
    @NotNull
    private final ReadOnlyProperty ignoreOverriddenFunction$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreOverridden$delegate;

    public MemberNameEqualsClassName(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "A member should not be given the same name as its parent class or object.", Debt.Companion.getFIVE_MINS());
        this.classMessage = "A member is named after the class. This might result in confusion. Either rename the member or change it to a constructor.";
        this.objectMessage = "A member is named after the object. This might result in confusion. Please rename the member.";
        this.ignoreOverriddenFunction$delegate = ConfigPropertyKt.config(true);
        this.ignoreOverridden$delegate = ConfigPropertyKt.configWithFallback(new PropertyReference0Impl(this){

            public Object get() {
                return MemberNameEqualsClassName.access$getIgnoreOverriddenFunction((MemberNameEqualsClassName)this.receiver);
            }
        }, true);
    }

    public /* synthetic */ MemberNameEqualsClassName(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getIgnoreOverriddenFunction() {
        return (Boolean)this.ignoreOverriddenFunction$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="if overridden functions and properties should be ignored")
    @Deprecated(message="Use `ignoreOverridden` instead")
    private static /* synthetic */ void getIgnoreOverriddenFunction$annotations() {
    }

    private final boolean getIgnoreOverridden() {
        return (Boolean)this.ignoreOverridden$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Configuration(description="if overridden functions and properties should be ignored")
    private static /* synthetic */ void getIgnoreOverridden$annotations() {
    }

    @Override
    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        if (!klass.isInterface()) {
            Sequence<KtNamedDeclaration> $this$forEach$iv = SequencesKt.plus(this.getMisnamedMembers(klass, klass.getName()), this.getMisnamedCompanionObjectMembers(klass));
            boolean $i$f$forEach = false;
            Iterator<KtNamedDeclaration> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                KtNamedDeclaration element$iv;
                KtNamedDeclaration it = element$iv = iterator2.next();
                boolean bl = false;
                this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, it, 0, 2, null), this.classMessage, null, null, 24, null));
            }
        }
        super.visitClass(klass);
    }

    @Override
    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (!declaration.isCompanion()) {
            Sequence<KtNamedDeclaration> $this$forEach$iv = this.getMisnamedMembers(declaration, declaration.getName());
            boolean $i$f$forEach = false;
            Iterator<KtNamedDeclaration> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                KtNamedDeclaration element$iv;
                KtNamedDeclaration it = element$iv = iterator2.next();
                boolean bl = false;
                this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, it, 0, 2, null), this.objectMessage, null, null, 24, null));
            }
        }
        super.visitObjectDeclaration(declaration);
    }

    private final Sequence<KtNamedDeclaration> getMisnamedMembers(KtClassOrObject klassOrObject, String name2) {
        KtClassBody ktClassBody = klassOrObject.getBody();
        if (ktClassBody == null) {
            return SequencesKt.emptySequence();
        }
        KtClassBody body2 = ktClassBody;
        Sequence sequence2 = CollectionsKt.asSequence((Iterable)body2.getFunctions());
        Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<org.jetbrains.kotlin.psi.KtNamedDeclaration>");
        return SequencesKt.filter(SequencesKt.filterNot(SequencesKt.plus(sequence2, (Iterable)body2.getProperties()), arg_0 -> MemberNameEqualsClassName.getMisnamedMembers$lambda$2(this, arg_0)), arg_0 -> MemberNameEqualsClassName.getMisnamedMembers$lambda$3(name2, arg_0));
    }

    private final Sequence<KtNamedDeclaration> getMisnamedCompanionObjectMembers(KtClass klass) {
        return SequencesKt.filterNot(SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)klass.getCompanionObjects()), arg_0 -> MemberNameEqualsClassName.getMisnamedCompanionObjectMembers$lambda$4(this, klass, arg_0)), arg_0 -> MemberNameEqualsClassName.getMisnamedCompanionObjectMembers$lambda$5(this, klass, arg_0));
    }

    private final boolean isFactoryMethod(KtNamedFunction function2, KtClass klass) {
        boolean bl;
        KtTypeReference typeReference = function2.getTypeReference();
        if (typeReference != null) {
            KtTypeElement ktTypeElement = typeReference.getTypeElement();
            Object object = ktTypeElement instanceof KtUserType ? (KtUserType)ktTypeElement : null;
            if (object == null || (object = ((KtUserType)object).getReferencedName()) == null) {
                object = typeReference.getText();
            }
            Object refName = object;
            bl = Intrinsics.areEqual(refName, klass.getName());
        } else if (function2.getBodyExpression() instanceof KtBlockExpression) {
            bl = false;
        } else if (!(function2.getBodyExpression() instanceof KtBlockExpression) && !Intrinsics.areEqual(this.getBindingContext(), BindingContext.EMPTY)) {
            SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)this.getBindingContext().get(BindingContext.FUNCTION, function2);
            DeclarationDescriptor classDescriptor = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, klass);
            Object object = functionDescriptor;
            bl = Intrinsics.areEqual(object != null && (object = object.getReturnType()) != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : null, classDescriptor);
        } else {
            bl = true;
        }
        return bl;
    }

    private static final boolean getMisnamedMembers$lambda$2(MemberNameEqualsClassName this$0, KtNamedDeclaration it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.getIgnoreOverridden() && KtModifierListKt.isOverride(it);
    }

    private static final boolean getMisnamedMembers$lambda$3(String $name, KtNamedDeclaration it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string2 = it.getName();
        return string2 != null ? StringsKt.equals(string2, $name, true) : false;
    }

    private static final Sequence getMisnamedCompanionObjectMembers$lambda$4(MemberNameEqualsClassName this$0, KtClass $klass, KtObjectDeclaration it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.getMisnamedMembers(it, $klass.getName());
    }

    private static final boolean getMisnamedCompanionObjectMembers$lambda$5(MemberNameEqualsClassName this$0, KtClass $klass, KtNamedDeclaration it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it instanceof KtNamedFunction && this$0.isFactoryMethod((KtNamedFunction)it, $klass);
    }

    public MemberNameEqualsClassName() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    public static final /* synthetic */ boolean access$getIgnoreOverriddenFunction(MemberNameEqualsClassName $this) {
        return $this.getIgnoreOverriddenFunction();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(MemberNameEqualsClassName.class, "ignoreOverriddenFunction", "getIgnoreOverriddenFunction()Z", 0)), Reflection.property1(new PropertyReference1Impl(MemberNameEqualsClassName.class, "ignoreOverridden", "getIgnoreOverridden()Z", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

