/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.IdentifierNameKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/VariableMaxLength;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "maximumVariableNameLength", "", "getMaximumVariableNameLength$annotations", "()V", "getMaximumVariableNameLength", "()I", "maximumVariableNameLength$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitProperty", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Companion", "detekt-rules-naming"})
public final class VariableMaxLength
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty maximumVariableNameLength$delegate;
    private static final int DEFAULT_MAXIMUM_VARIABLE_NAME_LENGTH = 64;

    public VariableMaxLength(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Variable names should not be longer than the maximum set in the configuration.", Debt.Companion.getFIVE_MINS());
        this.maximumVariableNameLength$delegate = ConfigPropertyKt.config(64);
    }

    public /* synthetic */ VariableMaxLength(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getMaximumVariableNameLength() {
        return ((Number)this.maximumVariableNameLength$delegate.getValue(this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="maximum name length")
    private static /* synthetic */ void getMaximumVariableNameLength$annotations() {
    }

    @Override
    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter(property, "property");
        if (KtModifierListKt.isOverride(property)) {
            return;
        }
        if (IdentifierNameKt.identifierName(property).length() > this.getMaximumVariableNameLength()) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.atName(property), "Variable names should be at most " + this.getMaximumVariableNameLength() + " characters long.", null, null, 24, null));
        }
    }

    public VariableMaxLength() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(VariableMaxLength.class, "maximumVariableNameLength", "getMaximumVariableNameLength()I", 0))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/VariableMaxLength$Companion;", "", "<init>", "()V", "DEFAULT_MAXIMUM_VARIABLE_NAME_LENGTH", "", "detekt-rules-naming"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

