/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.IdentifierNameKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.naming.VariableNaming;
import io.gitlab.arturbosch.detekt.rules.naming.util.ExcludeClassKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\f\u0010$\u001a\u00020\u001b*\u00020#H\u0002J\u0018\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0011\u0012\u0004\b\u0013\u0010\r\u001a\u0004\b\u0014\u0010\u000fR!\u0010\u0016\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0011\u0012\u0004\b\u0017\u0010\r\u001a\u0004\b\u0018\u0010\u000fR!\u0010\u001a\u001a\u00020\u001b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\u0011\u0012\u0004\b\u001c\u0010\r\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006)"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/VariableNaming;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "variablePattern", "Lkotlin/text/Regex;", "getVariablePattern$annotations", "()V", "getVariablePattern", "()Lkotlin/text/Regex;", "variablePattern$delegate", "Lkotlin/properties/ReadOnlyProperty;", "privateVariablePattern", "getPrivateVariablePattern$annotations", "getPrivateVariablePattern", "privateVariablePattern$delegate", "excludeClassPattern", "getExcludeClassPattern$annotations", "getExcludeClassPattern", "excludeClassPattern$delegate", "ignoreOverridden", "", "getIgnoreOverridden$annotations", "getIgnoreOverridden", "()Z", "ignoreOverridden$delegate", "visitProperty", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "isPropertyTopLevelOrInCompanion", "report", "message", "", "Companion", "detekt-rules-naming"})
@SourceDebugExtension(value={"SMAP\nVariableNaming.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VariableNaming.kt\nio/gitlab/arturbosch/detekt/rules/naming/VariableNaming\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,94:1\n146#2:95\n*S KotlinDebug\n*F\n+ 1 VariableNaming.kt\nio/gitlab/arturbosch/detekt/rules/naming/VariableNaming\n*L\n75#1:95\n*E\n"})
public final class VariableNaming
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty variablePattern$delegate;
    @NotNull
    private final ReadOnlyProperty privateVariablePattern$delegate;
    @NotNull
    private final ReadOnlyProperty excludeClassPattern$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreOverridden$delegate;
    @NotNull
    public static final String EXCLUDE_CLASS_PATTERN = "excludeClassPattern";

    public VariableNaming(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Variable names should follow the naming convention set in the projects configuration.", Debt.Companion.getFIVE_MINS());
        this.variablePattern$delegate = ConfigPropertyKt.config("[a-z][A-Za-z0-9]*", variablePattern.2.INSTANCE);
        this.privateVariablePattern$delegate = ConfigPropertyKt.config("(_)?[a-z][A-Za-z0-9]*", privateVariablePattern.2.INSTANCE);
        this.excludeClassPattern$delegate = ConfigPropertyKt.config("$^", excludeClassPattern.2.INSTANCE);
        this.ignoreOverridden$delegate = ConfigPropertyKt.config(true);
    }

    public /* synthetic */ VariableNaming(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Regex getVariablePattern() {
        return (Regex)this.variablePattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="naming pattern")
    private static /* synthetic */ void getVariablePattern$annotations() {
    }

    private final Regex getPrivateVariablePattern() {
        return (Regex)this.privateVariablePattern$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Configuration(description="naming pattern")
    private static /* synthetic */ void getPrivateVariablePattern$annotations() {
    }

    private final Regex getExcludeClassPattern() {
        return (Regex)this.excludeClassPattern$delegate.getValue(this, $$delegatedProperties[2]);
    }

    @Configuration(description="ignores variables in classes which match this regex")
    private static /* synthetic */ void getExcludeClassPattern$annotations() {
    }

    private final boolean getIgnoreOverridden() {
        return (Boolean)this.ignoreOverridden$delegate.getValue(this, $$delegatedProperties[3]);
    }

    @Configuration(description="ignores member properties that have the override modifier")
    @Deprecated(message="This configuration is ignored and will be removed in the future")
    private static /* synthetic */ void getIgnoreOverridden$annotations() {
    }

    @Override
    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter(property, "property");
        if (this.isPropertyTopLevelOrInCompanion(property)) {
            return;
        }
        if (UnderscoreUtilKt.isSingleUnderscore(property) || ExcludeClassKt.isContainingExcludedClassOrObject(property, this.getExcludeClassPattern())) {
            return;
        }
        if (KtModifierListKt.isOverride(property)) {
            return;
        }
        String identifier = IdentifierNameKt.identifierName(property);
        if (KtPsiUtilKt.isPrivate(property)) {
            CharSequence charSequence = identifier;
            if (!this.getPrivateVariablePattern().matches(charSequence)) {
                this.report(property, "Private variable names should match the pattern: " + this.getPrivateVariablePattern());
            }
        } else {
            CharSequence charSequence = identifier;
            if (!this.getVariablePattern().matches(charSequence)) {
                this.report(property, "Variable names should match the pattern: " + this.getVariablePattern());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPropertyTopLevelOrInCompanion(KtProperty $this$isPropertyTopLevelOrInCompanion) {
        if ($this$isPropertyTopLevelOrInCompanion.getNameAsSafeName().isSpecial()) return true;
        PsiElement $this$getNonStrictParentOfType$iv = $this$isPropertyTopLevelOrInCompanion;
        boolean $i$f$getNonStrictParentOfType = false;
        if (PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv, KtObjectDeclaration.class, false) != null) return true;
        if ($this$isPropertyTopLevelOrInCompanion.isTopLevel()) return true;
        PsiElement psiElement = $this$isPropertyTopLevelOrInCompanion.getNameIdentifier();
        PsiElement psiElement2 = psiElement;
        if (psiElement == null) return true;
        PsiElement psiElement3 = psiElement2.getParent();
        psiElement2 = psiElement3;
        if (psiElement3 == null) return true;
        Class<?> clazz = psiElement2.getClass();
        if (clazz != null) return false;
        return true;
    }

    private final void report(KtProperty property, String message) {
        this.report(new CodeSmell(this.getIssue(), Entity.Companion.atName(property), message, null, null, 24, null));
    }

    public VariableNaming() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(VariableNaming.class, "variablePattern", "getVariablePattern()Lkotlin/text/Regex;", 0)), Reflection.property1(new PropertyReference1Impl(VariableNaming.class, "privateVariablePattern", "getPrivateVariablePattern()Lkotlin/text/Regex;", 0)), Reflection.property1(new PropertyReference1Impl(VariableNaming.class, EXCLUDE_CLASS_PATTERN, "getExcludeClassPattern()Lkotlin/text/Regex;", 0)), Reflection.property1(new PropertyReference1Impl(VariableNaming.class, "ignoreOverridden", "getIgnoreOverridden()Z", 0))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/VariableNaming$Companion;", "", "<init>", "()V", "EXCLUDE_CLASS_PATTERN", "", "detekt-rules-naming"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

