/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.performance;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u0004\u0018\u00010\u0014*\u00020\u0014H\u0002J\u001a\u0010\u001a\u001a\u00020\u001b*\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/gitlab/arturbosch/detekt/rules/performance/CouldBeSequence;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "threshold", "", "getThreshold$annotations", "()V", "getThreshold", "()I", "threshold$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitedCallExpressions", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "nextChainedCall", "isCalling", "", "fqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "Companion", "detekt-rules-performance"})
@SourceDebugExtension(value={"SMAP\nCouldBeSequence.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CouldBeSequence.kt\nio/gitlab/arturbosch/detekt/rules/performance/CouldBeSequence\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n774#2:100\n865#2,2:101\n*S KotlinDebug\n*F\n+ 1 CouldBeSequence.kt\nio/gitlab/arturbosch/detekt/rules/performance/CouldBeSequence\n*L\n81#1:100\n81#1:101,2\n*E\n"})
public final class CouldBeSequence
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty threshold$delegate;
    @NotNull
    private final List<KtExpression> visitedCallExpressions;
    @NotNull
    private static final List<FqName> operationsFqNames;

    public CouldBeSequence(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("CouldBeSequence", Severity.Performance, "Several chained collection operations that should be a sequence.", Debt.Companion.getFIVE_MINS());
        this.threshold$delegate = ConfigPropertyKt.config(3);
        this.visitedCallExpressions = new ArrayList();
    }

    public /* synthetic */ CouldBeSequence(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getThreshold() {
        return ((Number)this.threshold$delegate.getValue(this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="the number of chained collection operations required to trigger rule")
    private static /* synthetic */ void getThreshold$annotations() {
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        int counter;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitCallExpression(expression2);
        if (this.visitedCallExpressions.contains(expression2)) {
            return;
        }
        if (!this.isCalling(expression2, operationsFqNames)) {
            return;
        }
        KtExpression nextCall = this.nextChainedCall(expression2);
        for (counter = 1; counter < this.getThreshold() && nextCall != null; ++counter) {
            ((Collection)this.visitedCallExpressions).add(nextCall);
            if (!this.isCalling(nextCall, operationsFqNames)) break;
            nextCall = this.nextChainedCall(nextCall);
        }
        if (counter >= this.getThreshold()) {
            String message = expression2.getText() + " could be .asSequence()." + expression2.getText();
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), message, null, null, 24, null));
        }
    }

    private final KtExpression nextChainedCall(KtExpression $this$nextChainedCall) {
        KtExpression expression2 = KtPsiUtilKt.getQualifiedExpressionForSelectorOrThis($this$nextChainedCall);
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForReceiver(expression2);
        return ktQualifiedExpression != null ? ktQualifiedExpression.getSelectorExpression() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCalling(KtExpression $this$isCalling, List<FqName> fqNames) {
        void $this$filterTo$iv$iv;
        Object object = $this$isCalling instanceof KtCallExpression ? (KtCallExpression)$this$isCalling : null;
        if (object == null || (object = ((KtCallExpression)object).getCalleeExpression()) == null || (object = object.getText()) == null) {
            object = $this$isCalling.getText();
        }
        Object calleeText = object;
        Iterable $this$filter$iv = fqNames;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FqName it = (FqName)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.shortName().asString(), calleeText)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List targetFqNames = (List)destination$iv$iv;
        if (targetFqNames.isEmpty()) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($this$isCalling, this.getBindingContext());
        return CollectionsKt.contains(targetFqNames, resolvedCall2 != null && (resolvedCall2 = resolvedCall2.getResultingDescriptor()) != null ? DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((Object)resolvedCall2)) : null);
    }

    public CouldBeSequence() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(CouldBeSequence.class, "threshold", "getThreshold()I", 0))};
        $$delegatedProperties = objectArray;
        Companion = new Companion(null);
        objectArray = new FqName[]{new FqName("kotlin.collections.filter"), new FqName("kotlin.collections.filterIndexed"), new FqName("kotlin.collections.map"), new FqName("kotlin.collections.mapIndexed"), new FqName("kotlin.collections.flatMap"), new FqName("kotlin.collections.flatMapIndexed"), new FqName("kotlin.collections.reduce"), new FqName("kotlin.collections.zip")};
        operationsFqNames = CollectionsKt.listOf(objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/performance/CouldBeSequence$Companion;", "", "<init>", "()V", "operationsFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "detekt-rules-performance"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

