/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001'B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0018\u001a\u00020\u001cH\u0002J\u001e\u0010\u001d\u001a\u00020\u00172\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J\u0018\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J\u000e\u0010\"\u001a\u0004\u0018\u00010#*\u00020\u001cH\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0018\u001a\u00020\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u001cH\u0002J\u0010\u0010&\u001a\u00020%2\u0006\u0010\u0018\u001a\u00020\u001cH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0011\u0012\u0004\b\u0013\u0010\r\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006("}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "singleLine", "Lio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements$BracePolicy;", "getSingleLine$annotations", "()V", "getSingleLine", "()Lio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements$BracePolicy;", "singleLine$delegate", "Lkotlin/properties/ReadOnlyProperty;", "multiLine", "getMultiLine$annotations", "getMultiLine", "multiLine$delegate", "visitIfExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "walk", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "validate", "list", "policy", "report", "violator", "parentIfCandidate", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "isMultiStatement", "", "hasBraces", "BracePolicy", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nBracesOnIfStatements.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BracesOnIfStatements.kt\nio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,279:1\n1#2:280\n774#3:281\n865#3,2:282\n774#3:284\n865#3,2:285\n774#3:287\n865#3,2:288\n1782#3,4:290\n1782#3,4:294\n1863#3,2:298\n*S KotlinDebug\n*F\n+ 1 BracesOnIfStatements.kt\nio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements\n*L\n198#1:281\n198#1:282,2\n202#1:284\n202#1:285,2\n206#1:287\n206#1:288,2\n210#1:290,4\n211#1:294,4\n219#1:298,2\n*E\n"})
public final class BracesOnIfStatements
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty singleLine$delegate;
    @NotNull
    private final ReadOnlyProperty multiLine$delegate;

    public BracesOnIfStatements(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Braces do not comply with the specified policy", Debt.Companion.getFIVE_MINS());
        this.singleLine$delegate = ConfigPropertyKt.config("never", BracesOnIfStatements::singleLine_delegate$lambda$0);
        this.multiLine$delegate = ConfigPropertyKt.config("always", BracesOnIfStatements::multiLine_delegate$lambda$1);
    }

    public /* synthetic */ BracesOnIfStatements(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final BracePolicy getSingleLine() {
        return (BracePolicy)((Object)this.singleLine$delegate.getValue(this, $$delegatedProperties[0]));
    }

    @Configuration(description="single-line braces policy")
    private static /* synthetic */ void getSingleLine$annotations() {
    }

    private final BracePolicy getMultiLine() {
        return (BracePolicy)((Object)this.multiLine$delegate.getValue(this, $$delegatedProperties[1]));
    }

    @Configuration(description="multi-line braces policy")
    private static /* synthetic */ void getMultiLine$annotations() {
    }

    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitIfExpression(expression2);
        PsiElement parent2 = this.parentIfCandidate(expression2);
        if (parent2 instanceof KtIfExpression && ((KtIfExpression)parent2).getElse() == expression2) {
            return;
        }
        List<KtExpression> branches = this.walk(expression2);
        this.validate(branches, this.policy(expression2));
    }

    private final List<KtExpression> walk(KtExpression expression2) {
        List list = new ArrayList();
        KtExpression current = expression2;
        while (current instanceof KtIfExpression) {
            if (((KtIfExpression)current).getThen() != null) {
                KtExpression it;
                boolean bl = false;
                list.add(it);
            }
            KtExpression ktExpression = ((KtIfExpression)current).getElse();
            if (ktExpression != null) {
                KtExpression ktExpression2;
                KtExpression ktExpression3;
                KtExpression it = ktExpression3 = ktExpression;
                boolean bl = false;
                KtExpression ktExpression4 = ktExpression2 = !(it instanceof KtIfExpression) && !(it instanceof KtQualifiedExpression) && !(it instanceof KtBinaryExpression) ? ktExpression3 : null;
                if (ktExpression2 != null) {
                    it = ktExpression2;
                    boolean bl2 = false;
                    list.add(it);
                }
            }
            current = ((KtIfExpression)current).getElse();
        }
        return list;
    }

    private final void validate(List<? extends KtExpression> list, BracePolicy policy) {
        List list2;
        switch (WhenMappings.$EnumSwitchMapping$0[policy.ordinal()]) {
            case 1: {
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KtExpression it = (KtExpression)element$iv$iv;
                    boolean bl = false;
                    if (!(!this.hasBraces(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
                break;
            }
            case 2: {
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KtExpression it = (KtExpression)element$iv$iv;
                    boolean bl = false;
                    if (!(!this.isMultiStatement(it) && this.hasBraces(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
                break;
            }
            case 3: {
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KtExpression it = (KtExpression)element$iv$iv;
                    boolean bl = false;
                    if (!this.hasBraces(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
                break;
            }
            case 4: {
                int noBraces;
                int n;
                int n2;
                Iterable $this$count$iv = list;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n2 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        KtExpression it = (KtExpression)element$iv;
                        boolean bl = false;
                        if (!this.hasBraces(it) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n2 = count$iv;
                }
                int braces = n2;
                Iterable $this$count$iv2 = list;
                boolean $i$f$count2 = false;
                if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv2) {
                        KtExpression it = (KtExpression)element$iv;
                        boolean bl = false;
                        if (!(!this.hasBraces(it)) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = noBraces = count$iv;
                }
                if (braces != 0 && noBraces != 0) {
                    list2 = CollectionsKt.take((Iterable)list, 1);
                    break;
                }
                list2 = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List violators = list2;
        Iterable $this$forEach$iv = violators;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtExpression it = (KtExpression)element$iv;
            boolean bl = false;
            this.report(it, policy);
        }
    }

    private final void report(KtExpression violator, BracePolicy policy) {
        String string2;
        PsiElement psiElement;
        PsiElement psiElement2 = this.parentIfCandidate(violator);
        Intrinsics.checkNotNull(psiElement2, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
        KtIfExpression iff = (KtIfExpression)psiElement2;
        if (iff.getThen() == violator) {
            psiElement = iff.getIfKeyword();
        } else if (iff.getElse() == violator) {
            psiElement = iff.getElseKeyword();
        } else {
            throw new IllegalStateException(("Violating element (" + violator.getText() + ") is not part of this if (" + iff.getText() + ')').toString());
        }
        PsiElement reported = psiElement;
        switch (WhenMappings.$EnumSwitchMapping$0[policy.ordinal()]) {
            case 1: {
                string2 = "Missing braces on this branch, add them.";
                break;
            }
            case 4: {
                string2 = "Inconsistent braces, make sure all branches either have or don't have braces.";
                break;
            }
            case 2: {
                string2 = "Extra braces exist on this branch, remove them (ignore multi-statement).";
                break;
            }
            case 3: {
                string2 = "Extra braces exist on this branch, remove them.";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String message = string2;
        Issue issue = this.getIssue();
        PsiElement psiElement3 = reported;
        if (psiElement3 == null) {
            psiElement3 = violator;
        }
        this.report(new CodeSmell(issue, Entity.Companion.from$default(Entity.Companion, psiElement3, 0, 2, null), message, null, null, 24, null));
    }

    private final PsiElement parentIfCandidate(KtExpression $this$parentIfCandidate) {
        return $this$parentIfCandidate.getParent().getParent();
    }

    private final boolean isMultiStatement(KtExpression expression2) {
        return expression2 instanceof KtBlockExpression && ((KtBlockExpression)expression2).getStatements().size() > 1;
    }

    private final BracePolicy policy(KtExpression expression2) {
        return expression2.textContains('\n') ? this.getMultiLine() : this.getSingleLine();
    }

    private final boolean hasBraces(KtExpression expression2) {
        return expression2 instanceof KtBlockExpression;
    }

    private static final BracePolicy singleLine_delegate$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return BracePolicy.Companion.getValue(it);
    }

    private static final BracePolicy multiLine_delegate$lambda$1(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return BracePolicy.Companion.getValue(it);
    }

    public BracesOnIfStatements() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(BracesOnIfStatements.class, "singleLine", "getSingleLine()Lio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements$BracePolicy;", 0)), Reflection.property1(new PropertyReference1Impl(BracesOnIfStatements.class, "multiLine", "getMultiLine()Lio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements$BracePolicy;", 0))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements$BracePolicy;", "", "config", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getConfig", "()Ljava/lang/String;", "Always", "Consistent", "Necessary", "Never", "Companion", "detekt-rules-style"})
    public static final class BracePolicy
    extends Enum<BracePolicy> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String config;
        public static final /* enum */ BracePolicy Always;
        public static final /* enum */ BracePolicy Consistent;
        public static final /* enum */ BracePolicy Necessary;
        public static final /* enum */ BracePolicy Never;
        private static final /* synthetic */ BracePolicy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private BracePolicy(String config) {
            this.config = config;
        }

        @NotNull
        public final String getConfig() {
            return this.config;
        }

        public static BracePolicy[] values() {
            return (BracePolicy[])$VALUES.clone();
        }

        public static BracePolicy valueOf(String value2) {
            return Enum.valueOf(BracePolicy.class, value2);
        }

        @NotNull
        public static EnumEntries<BracePolicy> getEntries() {
            return $ENTRIES;
        }

        static {
            Always = new BracePolicy("always");
            Consistent = new BracePolicy("consistent");
            Necessary = new BracePolicy("necessary");
            Never = new BracePolicy("never");
            $VALUES = bracePolicyArray = new BracePolicy[]{BracePolicy.Always, BracePolicy.Consistent, BracePolicy.Necessary, BracePolicy.Never};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements$BracePolicy$Companion;", "", "<init>", "()V", "getValue", "Lio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements$BracePolicy;", "arg", "", "detekt-rules-style"})
        @SourceDebugExtension(value={"SMAP\nBracesOnIfStatements.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BracesOnIfStatements.kt\nio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements$BracePolicy$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,279:1\n3170#2,11:280\n*S KotlinDebug\n*F\n+ 1 BracesOnIfStatements.kt\nio/gitlab/arturbosch/detekt/rules/style/BracesOnIfStatements$BracePolicy$Companion\n*L\n274#1:280,11\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BracePolicy getValue(@NotNull String arg) {
                BracePolicy bracePolicy;
                block3: {
                    Intrinsics.checkNotNullParameter(arg, "arg");
                    BracePolicy[] $this$singleOrNull$iv = BracePolicy.values();
                    boolean $i$f$singleOrNull = false;
                    BracePolicy single$iv = null;
                    boolean found$iv = false;
                    int n = $this$singleOrNull$iv.length;
                    for (int j = 0; j < n; ++j) {
                        BracePolicy element$iv;
                        BracePolicy it = element$iv = $this$singleOrNull$iv[j];
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getConfig(), arg)) continue;
                        if (found$iv) {
                            bracePolicy = null;
                            break block3;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    bracePolicy = !found$iv ? null : single$iv;
                }
                if (bracePolicy == null) {
                    throw new IllegalStateException(("Unknown value " + arg + ", allowed values are: " + ArraysKt.joinToString$default((Object[])BracePolicy.values(), (CharSequence)"|", null, null, 0, null, null, 62, null)).toString());
                }
                return bracePolicy;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BracePolicy.values().length];
            try {
                nArray[BracePolicy.Always.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BracePolicy.Necessary.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BracePolicy.Never.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BracePolicy.Consistent.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

