/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001%B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001e\u0010\u001a\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\f\u0010\u001f\u001a\u00020 *\u00020\u001dH\u0002J\f\u0010!\u001a\u00020 *\u00020\u001dH\u0002J\f\u0010\"\u001a\u00020 *\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0011\u0012\u0004\b\u0013\u0010\r\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006&"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "singleLine", "Lio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements$BracePolicy;", "getSingleLine$annotations", "()V", "getSingleLine", "()Lio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements$BracePolicy;", "singleLine$delegate", "Lkotlin/properties/ReadOnlyProperty;", "multiLine", "getMultiLine$annotations", "getMultiLine", "multiLine$delegate", "visitWhenExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "validate", "branches", "", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "policy", "hasNoBraces", "", "hasUnnecessaryBraces", "isMultiStatement", "report", "violator", "BracePolicy", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nBracesOnWhenStatements.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BracesOnWhenStatements.kt\nio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,255:1\n774#2:256\n865#2,2:257\n774#2:259\n865#2,2:260\n774#2:262\n865#2,2:263\n1782#2,4:265\n1782#2,4:269\n1863#2,2:273\n1755#2,2:276\n1757#2:280\n1#3:275\n1251#4,2:278\n*S KotlinDebug\n*F\n+ 1 BracesOnWhenStatements.kt\nio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements\n*L\n183#1:256\n183#1:257,2\n187#1:259\n187#1:260,2\n191#1:262\n191#1:263,2\n195#1:265,4\n196#1:269,4\n204#1:273,2\n224#1:276,2\n224#1:280\n227#1:278,2\n*E\n"})
public final class BracesOnWhenStatements
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty singleLine$delegate;
    @NotNull
    private final ReadOnlyProperty multiLine$delegate;

    public BracesOnWhenStatements(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Braces do not comply with the specified policy", Debt.Companion.getFIVE_MINS());
        this.singleLine$delegate = ConfigPropertyKt.config("necessary", BracesOnWhenStatements::singleLine_delegate$lambda$0);
        this.multiLine$delegate = ConfigPropertyKt.config("consistent", BracesOnWhenStatements::multiLine_delegate$lambda$1);
    }

    public /* synthetic */ BracesOnWhenStatements(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final BracePolicy getSingleLine() {
        return (BracePolicy)((Object)this.singleLine$delegate.getValue(this, $$delegatedProperties[0]));
    }

    @Configuration(description="single-line braces policy")
    private static /* synthetic */ void getSingleLine$annotations() {
    }

    private final BracePolicy getMultiLine() {
        return (BracePolicy)((Object)this.multiLine$delegate.getValue(this, $$delegatedProperties[1]));
    }

    @Configuration(description="multi-line braces policy")
    private static /* synthetic */ void getMultiLine$annotations() {
    }

    @Override
    public void visitWhenExpression(@NotNull KtWhenExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitWhenExpression(expression2);
        List<KtWhenEntry> list = expression2.getEntries();
        Intrinsics.checkNotNullExpressionValue(list, "getEntries(...)");
        this.validate(list, this.policy(expression2));
    }

    private final void validate(List<? extends KtWhenEntry> branches, BracePolicy policy) {
        List list;
        switch (WhenMappings.$EnumSwitchMapping$0[policy.ordinal()]) {
            case 1: {
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv = branches;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KtWhenEntry it = (KtWhenEntry)element$iv$iv;
                    boolean bl = false;
                    if (!this.hasNoBraces(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                break;
            }
            case 2: {
                Iterable $this$filter$iv = branches;
                boolean $i$f$filter = false;
                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KtWhenEntry it = (KtWhenEntry)element$iv$iv;
                    boolean bl = false;
                    if (!(!this.isMultiStatement(it) && this.hasUnnecessaryBraces(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                break;
            }
            case 3: {
                Iterable $this$filter$iv = branches;
                boolean $i$f$filter = false;
                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KtWhenEntry it = (KtWhenEntry)element$iv$iv;
                    boolean bl = false;
                    if (!this.hasUnnecessaryBraces(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                break;
            }
            case 4: {
                int noBraces;
                int n;
                int n2;
                Iterable $this$count$iv = branches;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n2 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        KtWhenEntry it = (KtWhenEntry)element$iv;
                        boolean bl = false;
                        if (!this.hasUnnecessaryBraces(it) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n2 = count$iv;
                }
                int braces = n2;
                Iterable $this$count$iv2 = branches;
                boolean $i$f$count2 = false;
                if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv2) {
                        KtWhenEntry it = (KtWhenEntry)element$iv;
                        boolean bl = false;
                        if (!this.hasNoBraces(it) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = noBraces = count$iv;
                }
                if (braces != 0 && noBraces != 0) {
                    list = CollectionsKt.take((Iterable)branches, 1);
                    break;
                }
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List violators = list;
        Iterable $this$forEach$iv = violators;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtWhenEntry it = (KtWhenEntry)element$iv;
            boolean bl = false;
            this.report(it, policy);
        }
    }

    private final boolean hasNoBraces(KtWhenEntry $this$hasNoBraces) {
        return !($this$hasNoBraces.getExpression() instanceof KtBlockExpression);
    }

    private final boolean hasUnnecessaryBraces(KtWhenEntry $this$hasUnnecessaryBraces) {
        KtExpression expression2 = $this$hasUnnecessaryBraces.getExpression();
        if (!(expression2 instanceof KtBlockExpression)) {
            return false;
        }
        Collection<Object> collection = ((KtBlockExpression)expression2).getStatements();
        if (collection.isEmpty()) {
            boolean bl = false;
            return false;
        }
        Collection collection2 = collection;
        Intrinsics.checkNotNullExpressionValue(collection2, "ifEmpty(...)");
        List statements = (List)collection2;
        collection = CollectionsKt.singleOrNull(statements);
        KtLambdaExpression singleLambda = collection instanceof KtLambdaExpression ? (KtLambdaExpression)((Object)collection) : null;
        return singleLambda == null || singleLambda.getFunctionLiteral().getArrow() != null;
    }

    private final boolean isMultiStatement(KtWhenEntry $this$isMultiStatement) {
        KtExpression it = $this$isMultiStatement.getExpression();
        boolean bl = false;
        return it instanceof KtBlockExpression && ((KtBlockExpression)it).getStatements().size() > 1;
    }

    /*
     * WARNING - void declaration
     */
    private final BracePolicy policy(KtWhenExpression expression2) {
        boolean bl;
        block6: {
            List<KtWhenEntry> list = expression2.getEntries();
            Intrinsics.checkNotNullExpressionValue(list, "getEntries(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block5: {
                        void $this$any$iv2;
                        KtWhenEntry branch = (KtWhenEntry)element$iv;
                        boolean bl3 = false;
                        PsiElement psiElement = branch.getArrow();
                        if (psiElement == null) {
                            boolean $i$a$-requireNotNull-BracesOnWhenStatements$policy$isMultiLine$1$22 = false;
                            String $i$a$-requireNotNull-BracesOnWhenStatements$policy$isMultiLine$1$22 = "When branch " + branch.getText() + " has no arrow!";
                            throw new IllegalArgumentException($i$a$-requireNotNull-BracesOnWhenStatements$policy$isMultiLine$1$22.toString());
                        }
                        Sequence<PsiElement> sequence2 = PsiUtilsKt.siblings(psiElement, true, false);
                        boolean $i$f$any2 = false;
                        for (Object element$iv2 : $this$any$iv2) {
                            PsiElement it = (PsiElement)element$iv2;
                            boolean bl4 = false;
                            if (!it.textContains('\n')) continue;
                            bl2 = true;
                            break block5;
                        }
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean isMultiLine = bl;
        return isMultiLine ? this.getMultiLine() : this.getSingleLine();
    }

    private final void report(KtWhenEntry violator, BracePolicy policy) {
        PsiElement psiElement;
        switch (WhenMappings.$EnumSwitchMapping$0[policy.ordinal()]) {
            case 4: {
                PsiElement psiElement2 = violator.getParent();
                Intrinsics.checkNotNull(psiElement2, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenExpression");
                psiElement = ((KtWhenExpression)psiElement2).getWhenKeyword();
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                psiElement = violator.getArrow();
                if (psiElement != null) break;
                boolean bl = false;
                String string2 = "When branch " + violator.getText() + " has no arrow!";
                throw new IllegalArgumentException(string2.toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        PsiElement psiElement3 = psiElement;
        Intrinsics.checkNotNull(psiElement3);
        PsiElement reported = psiElement3;
        this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, reported, 0, 2, null), policy.getMessage(), null, null, 24, null));
    }

    private static final BracePolicy singleLine_delegate$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return BracePolicy.Companion.getValue(it);
    }

    private static final BracePolicy multiLine_delegate$lambda$1(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return BracePolicy.Companion.getValue(it);
    }

    public BracesOnWhenStatements() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(BracesOnWhenStatements.class, "singleLine", "getSingleLine()Lio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements$BracePolicy;", 0)), Reflection.property1(new PropertyReference1Impl(BracesOnWhenStatements.class, "multiLine", "getMultiLine()Lio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements$BracePolicy;", 0))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements$BracePolicy;", "", "config", "", "message", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getConfig", "()Ljava/lang/String;", "getMessage", "Always", "Consistent", "Necessary", "Never", "Companion", "detekt-rules-style"})
    public static final class BracePolicy
    extends Enum<BracePolicy> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String config;
        @NotNull
        private final String message;
        public static final /* enum */ BracePolicy Always;
        public static final /* enum */ BracePolicy Consistent;
        public static final /* enum */ BracePolicy Necessary;
        public static final /* enum */ BracePolicy Never;
        private static final /* synthetic */ BracePolicy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private BracePolicy(String config, String message) {
            this.config = config;
            this.message = message;
        }

        @NotNull
        public final String getConfig() {
            return this.config;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public static BracePolicy[] values() {
            return (BracePolicy[])$VALUES.clone();
        }

        public static BracePolicy valueOf(String value2) {
            return Enum.valueOf(BracePolicy.class, value2);
        }

        @NotNull
        public static EnumEntries<BracePolicy> getEntries() {
            return $ENTRIES;
        }

        static {
            Always = new BracePolicy("always", "Missing braces on this branch, add them.");
            Consistent = new BracePolicy("consistent", "Inconsistent braces, make sure all branches either have or don't have braces.");
            Necessary = new BracePolicy("necessary", "Extra braces exist on this branch, remove them.");
            Never = new BracePolicy("never", "Extra braces exist on this branch, remove them.");
            $VALUES = bracePolicyArray = new BracePolicy[]{BracePolicy.Always, BracePolicy.Consistent, BracePolicy.Necessary, BracePolicy.Never};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements$BracePolicy$Companion;", "", "<init>", "()V", "getValue", "Lio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements$BracePolicy;", "arg", "", "detekt-rules-style"})
        @SourceDebugExtension(value={"SMAP\nBracesOnWhenStatements.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BracesOnWhenStatements.kt\nio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements$BracePolicy$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,255:1\n3170#2,11:256\n*S KotlinDebug\n*F\n+ 1 BracesOnWhenStatements.kt\nio/gitlab/arturbosch/detekt/rules/style/BracesOnWhenStatements$BracePolicy$Companion\n*L\n250#1:256,11\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BracePolicy getValue(@NotNull String arg) {
                BracePolicy bracePolicy;
                block3: {
                    Intrinsics.checkNotNullParameter(arg, "arg");
                    BracePolicy[] $this$singleOrNull$iv = BracePolicy.values();
                    boolean $i$f$singleOrNull = false;
                    BracePolicy single$iv = null;
                    boolean found$iv = false;
                    int n = $this$singleOrNull$iv.length;
                    for (int j = 0; j < n; ++j) {
                        BracePolicy element$iv;
                        BracePolicy it = element$iv = $this$singleOrNull$iv[j];
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getConfig(), arg)) continue;
                        if (found$iv) {
                            bracePolicy = null;
                            break block3;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    bracePolicy = !found$iv ? null : single$iv;
                }
                if (bracePolicy == null) {
                    throw new IllegalStateException(("Unknown value " + arg + ", allowed values are: " + ArraysKt.joinToString$default((Object[])BracePolicy.values(), (CharSequence)"|", null, null, 0, null, null, 62, null)).toString());
                }
                return bracePolicy;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BracePolicy.values().length];
            try {
                nArray[BracePolicy.Always.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BracePolicy.Necessary.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BracePolicy.Never.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BracePolicy.Consistent.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

