/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/EqualsOnSignatureLine;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Companion", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nEqualsOnSignatureLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EqualsOnSignatureLine.kt\nio/gitlab/arturbosch/detekt/rules/style/EqualsOnSignatureLine\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,55:1\n1251#2,2:56\n*S KotlinDebug\n*F\n+ 1 EqualsOnSignatureLine.kt\nio/gitlab/arturbosch/detekt/rules/style/EqualsOnSignatureLine\n*L\n45#1:56,2\n*E\n"})
public final class EqualsOnSignatureLine
extends Rule {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @Deprecated
    @NotNull
    public static final String MESSAGE = "Equals signs for expression style functions should be on the same line as the signature.";

    public EqualsOnSignatureLine(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, MESSAGE, Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ EqualsOnSignatureLine(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        boolean hasLineBreakBeforeEqualsToken;
        PsiElement equalsToken;
        block3: {
            boolean bl;
            void $this$any$iv;
            Intrinsics.checkNotNullParameter(function2, "function");
            PsiElement psiElement = function2.getEqualsToken();
            if (psiElement == null) {
                return;
            }
            equalsToken = psiElement;
            Sequence<PsiElement> sequence2 = SequencesKt.takeWhile(PsiUtilsKt.siblings(equalsToken, false, false), EqualsOnSignatureLine::visitNamedFunction$lambda$0);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!(it instanceof PsiWhiteSpace && it.textContains('\n'))) continue;
                bl = true;
                break block3;
            }
            bl = hasLineBreakBeforeEqualsToken = false;
        }
        if (hasLineBreakBeforeEqualsToken) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, equalsToken, 0, 2, null), MESSAGE, null, null, 24, null));
        }
    }

    private static final boolean visitNamedFunction$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it instanceof PsiWhiteSpace || it instanceof PsiComment;
    }

    public EqualsOnSignatureLine() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/EqualsOnSignatureLine$Companion;", "", "<init>", "()V", "MESSAGE", "", "detekt-rules-style"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

