/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Location;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.TextLocation;
import io.gitlab.arturbosch.detekt.api.ValueWithReason;
import io.gitlab.arturbosch.detekt.api.ValuesWithReason;
import io.gitlab.arturbosch.detekt.api.ValuesWithReasonKt;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010 \u001a\u0004\u0018\u00010\u001f*\u00020!H\u0002J\u000e\u0010\"\u001a\u0004\u0018\u00010#*\u00020\u001aH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR-\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006$"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenAnnotation;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "annotations", "", "", "Lio/gitlab/arturbosch/detekt/api/ValueWithReason;", "getAnnotations$annotations", "()V", "getAnnotations", "()Ljava/util/Map;", "annotations$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitAnnotationEntry", "", "annotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "visitExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "check", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "fqNameOrNull", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "expressionTypeOrNull", "Lorg/jetbrains/kotlin/types/KotlinType;", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nForbiddenAnnotation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForbiddenAnnotation.kt\nio/gitlab/arturbosch/detekt/rules/style/ForbiddenAnnotation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1202#2,2:112\n1230#2,4:114\n*S KotlinDebug\n*F\n+ 1 ForbiddenAnnotation.kt\nio/gitlab/arturbosch/detekt/rules/style/ForbiddenAnnotation\n*L\n66#1:112,2\n66#1:114,4\n*E\n"})
public final class ForbiddenAnnotation
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty annotations$delegate;

    public ForbiddenAnnotation(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Avoid using this annotation.", Debt.Companion.getFIVE_MINS());
        Pair[] pairArray = new Pair[]{TuplesKt.to("java.lang.SuppressWarnings", "it is a java annotation. Use `Suppress` instead."), TuplesKt.to("java.lang.Deprecated", "it is a java annotation. Use `kotlin.Deprecated` instead."), TuplesKt.to("java.lang.annotation.Documented", "it is a java annotation. Use `kotlin.annotation.MustBeDocumented` instead."), TuplesKt.to("java.lang.annotation.Target", "it is a java annotation. Use `kotlin.annotation.Target` instead."), TuplesKt.to("java.lang.annotation.Retention", "it is a java annotation. Use `kotlin.annotation.Retention` instead."), TuplesKt.to("java.lang.annotation.Repeatable", "it is a java annotation. Use `kotlin.annotation.Repeatable` instead."), TuplesKt.to("java.lang.annotation.Inherited", "Kotlin does not support @Inherited annotation, see https://youtrack.jetbrains.com/issue/KT-22265")};
        this.annotations$delegate = ConfigPropertyKt.config(ValuesWithReasonKt.valuesWithReason(pairArray), ForbiddenAnnotation::annotations_delegate$lambda$1);
    }

    public /* synthetic */ ForbiddenAnnotation(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Map<String, ValueWithReason> getAnnotations() {
        return (Map)this.annotations$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="List of fully qualified annotation classes which are forbidden.")
    private static /* synthetic */ void getAnnotations$annotations() {
    }

    @Override
    public void visitAnnotationEntry(@NotNull KtAnnotationEntry annotation) {
        block0: {
            Intrinsics.checkNotNullParameter(annotation, "annotation");
            super.visitAnnotationEntry(annotation);
            Object object = annotation.getTypeReference();
            if (object == null || (object = this.fqNameOrNull((KtTypeReference)object)) == null) break block0;
            Object it = object;
            boolean bl = false;
            this.check(annotation, (FqName)it);
        }
    }

    @Override
    public void visitExpression(@NotNull KtExpression expression2) {
        block0: {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            super.visitExpression(expression2);
            Object object = this.expressionTypeOrNull(expression2);
            if (object == null || (object = TypeUtilsKt.fqNameOrNull((KotlinType)object)) == null) break block0;
            Object it = object;
            boolean bl = false;
            this.check(expression2, (FqName)it);
        }
    }

    private final void check(KtElement element, FqName fqName) {
        ValueWithReason forbidden = this.getAnnotations().get(fqName.asString());
        if (forbidden != null) {
            String message = forbidden.getReason() != null ? "The annotation `" + forbidden.getValue() + "` has been forbidden: " + forbidden.getReason() : "The annotation `" + forbidden.getValue() + "` has been forbidden in the detekt config.";
            Location location = Location.Companion.from$default(Location.Companion, element, 0, 2, null);
            boolean bl = false;
            TextLocation textLocation = location.getText();
            PsiElement[] psiElementArray = element.getChildren();
            Intrinsics.checkNotNullExpressionValue(psiElementArray, "getChildren(...)");
            PsiElement psiElement = (PsiElement)ArraysKt.firstOrNull((Object[])psiElementArray);
            Location location2 = Location.copy$default(location, null, TextLocation.copy$default(textLocation, 0, psiElement != null ? PsiUtilsKt.getEndOffset(psiElement) : location.getText().getEnd(), 1, null), null, null, 13, null);
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from((PsiElement)element, location2), message, null, null, 24, null));
        }
    }

    private final FqName fqNameOrNull(KtTypeReference $this$fqNameOrNull) {
        KotlinType kotlinType = (KotlinType)this.getBindingContext().get(BindingContext.TYPE, $this$fqNameOrNull);
        return kotlinType != null ? TypeUtilsKt.fqNameOrNull(kotlinType) : null;
    }

    private final KotlinType expressionTypeOrNull(KtExpression $this$expressionTypeOrNull) {
        KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)this.getBindingContext().get(BindingContext.EXPRESSION_TYPE_INFO, $this$expressionTypeOrNull);
        return kotlinTypeInfo != null ? kotlinTypeInfo.getType() : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map annotations_delegate$lambda$1(ValuesWithReason list) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(list, "list");
        Iterable $this$associateBy$iv = list;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ValueWithReason valueWithReason = (ValueWithReason)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getValue(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    public ForbiddenAnnotation() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(ForbiddenAnnotation.class, "annotations", "getAnnotations()Ljava/util/Map;", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

