/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\f\u0010\u001a\u001a\u00020\u000b*\u00020\u0019H\u0002J\f\u0010\u001b\u001a\u00020\u000b*\u00020\u0019H\u0002J\f\u0010\u001c\u001a\u00020\u000b*\u00020\u0019H\u0002J\f\u0010\u001d\u001a\u00020\u000b*\u00020\u0019H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0011\u0012\u0004\b\u0013\u0010\r\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenVoid;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "ignoreOverridden", "", "getIgnoreOverridden$annotations", "()V", "getIgnoreOverridden", "()Z", "ignoreOverridden$delegate", "Lkotlin/properties/ReadOnlyProperty;", "ignoreUsageInGenerics", "getIgnoreUsageInGenerics$annotations", "getIgnoreUsageInGenerics", "ignoreUsageInGenerics$delegate", "visitTypeReference", "", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "isPartOfOverriddenSignature", "isPartOfReturnTypeOfFunction", "isParameterTypeOfFunction", "isGenericArgument", "Companion", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nForbiddenVoid.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForbiddenVoid.kt\nio/gitlab/arturbosch/detekt/rules/style/ForbiddenVoid\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,93:1\n142#2:94\n142#2:95\n266#2:96\n277#2,10:97\n299#2:107\n142#2:108\n142#2:109\n*S KotlinDebug\n*F\n+ 1 ForbiddenVoid.kt\nio/gitlab/arturbosch/detekt/rules/style/ForbiddenVoid\n*L\n75#1:94\n78#1:95\n80#1:96\n80#1:97,10\n80#1:107\n84#1:108\n87#1:109\n*E\n"})
public final class ForbiddenVoid
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty ignoreOverridden$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreUsageInGenerics$delegate;
    @NotNull
    private static final FqName VOID_FQ_NAME;

    public ForbiddenVoid(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "`Unit` should be used instead of `Void`.", Debt.Companion.getFIVE_MINS());
        this.ignoreOverridden$delegate = ConfigPropertyKt.config(false);
        this.ignoreUsageInGenerics$delegate = ConfigPropertyKt.config(false);
    }

    public /* synthetic */ ForbiddenVoid(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getIgnoreOverridden() {
        return (Boolean)this.ignoreOverridden$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="ignores void types in signatures of overridden functions")
    private static /* synthetic */ void getIgnoreOverridden$annotations() {
    }

    private final boolean getIgnoreUsageInGenerics() {
        return (Boolean)this.ignoreUsageInGenerics$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Configuration(description="ignore void types as generic arguments")
    private static /* synthetic */ void getIgnoreUsageInGenerics$annotations() {
    }

    @Override
    public void visitTypeReference(@NotNull KtTypeReference typeReference) {
        Intrinsics.checkNotNullParameter(typeReference, "typeReference");
        KotlinType kotlinType = BindingContextUtilsKt.getAbbreviatedTypeOrType(typeReference, this.getBindingContext());
        if (kotlinType == null) {
            return;
        }
        KotlinType kotlinType2 = kotlinType;
        if (Intrinsics.areEqual(TypeUtilsKt.fqNameOrNull(kotlinType2), VOID_FQ_NAME)) {
            if (this.getIgnoreOverridden() && this.isPartOfOverriddenSignature(typeReference)) {
                return;
            }
            if (this.getIgnoreUsageInGenerics() && this.isGenericArgument(typeReference)) {
                return;
            }
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, typeReference, 0, 2, null), "'Void' should be replaced with 'Unit'.", null, null, 24, null));
        }
        super.visitTypeReference(typeReference);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPartOfOverriddenSignature(KtTypeReference $this$isPartOfOverriddenSignature) {
        if (!this.isPartOfReturnTypeOfFunction($this$isPartOfOverriddenSignature)) {
            if (!this.isParameterTypeOfFunction($this$isPartOfOverriddenSignature)) return false;
        }
        PsiElement $this$getStrictParentOfType$iv = $this$isPartOfOverriddenSignature;
        boolean $i$f$getStrictParentOfType = false;
        KtNamedFunction ktNamedFunction = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtNamedFunction.class, true);
        if (ktNamedFunction == null) return false;
        if (!KtModifierListKt.isOverride(ktNamedFunction)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isPartOfReturnTypeOfFunction(KtTypeReference $this$isPartOfReturnTypeOfFunction) {
        boolean bl;
        KtTypeReference ktTypeReference;
        PsiElement $this$getStrictParentOfType$iv = $this$isPartOfReturnTypeOfFunction;
        boolean $i$f$getStrictParentOfType = false;
        KtNamedFunction ktNamedFunction = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtNamedFunction.class, true);
        if (ktNamedFunction != null && (ktTypeReference = ktNamedFunction.getTypeReference()) != null) {
            void $this$anyDescendantOfType$iv;
            PsiElement psiElement = ktTypeReference;
            Function1<KtTypeReference, Boolean> predicate$iv = arg_0 -> ForbiddenVoid.isPartOfReturnTypeOfFunction$lambda$0($this$isPartOfReturnTypeOfFunction, arg_0);
            boolean $i$f$anyDescendantOfType = false;
            void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
            boolean $i$f$findDescendantOfType = false;
            void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
            boolean $i$f$findDescendantOfType2 = false;
            PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
            Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
            $this$findDescendantOfType$iv$iv$iv.accept(new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Ref.ObjectRef $result;
                {
                    this.$predicate = $predicate;
                    this.$result = $result;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    if (element instanceof KtTypeReference && ((Boolean)this.$predicate.invoke(element)).booleanValue()) {
                        this.$result.element = element;
                        this.stopWalking();
                        return;
                    }
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                }
            });
            bl = (PsiElement)result$iv$iv$iv.element != null;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isParameterTypeOfFunction(KtTypeReference $this$isParameterTypeOfFunction) {
        PsiElement $this$getStrictParentOfType$iv = $this$isParameterTypeOfFunction;
        boolean $i$f$getStrictParentOfType = false;
        return PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtParameter.class, true) != null;
    }

    private final boolean isGenericArgument(KtTypeReference $this$isGenericArgument) {
        PsiElement $this$getStrictParentOfType$iv = $this$isGenericArgument;
        boolean $i$f$getStrictParentOfType = false;
        return PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtTypeArgumentList.class, true) != null;
    }

    private static final boolean isPartOfReturnTypeOfFunction$lambda$0(KtTypeReference $this_isPartOfReturnTypeOfFunction, KtTypeReference it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it, $this_isPartOfReturnTypeOfFunction);
    }

    public ForbiddenVoid() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(ForbiddenVoid.class, "ignoreOverridden", "getIgnoreOverridden()Z", 0)), Reflection.property1(new PropertyReference1Impl(ForbiddenVoid.class, "ignoreUsageInGenerics", "getIgnoreUsageInGenerics()Z", 0))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        VOID_FQ_NAME = new FqName("java.lang.Void");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenVoid$Companion;", "", "<init>", "()V", "VOID_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

