/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.MethodSignatureKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b)\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 W2\u00020\u0001:\u0001WB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020\u00142\u0006\u0010?\u001a\u00020@H\u0002J\u0017\u0010B\u001a\u0004\u0018\u00010\f2\u0006\u0010C\u001a\u00020DH\u0002\u00a2\u0006\u0002\u0010EJ\u0010\u0010F\u001a\u00020\f2\u0006\u0010G\u001a\u00020DH\u0002J\u0010\u0010H\u001a\u00020D2\u0006\u0010I\u001a\u00020DH\u0002J\f\u0010J\u001a\u00020\u0014*\u00020@H\u0002J\f\u0010K\u001a\u00020\u0014*\u00020@H\u0002J\f\u0010L\u001a\u00020\u0014*\u00020@H\u0002J\f\u0010M\u001a\u00020\u0014*\u00020@H\u0002J\f\u0010N\u001a\u00020\u0014*\u00020@H\u0002J\f\u0010O\u001a\u00020\u0014*\u00020@H\u0002J\f\u0010P\u001a\u00020\u0014*\u00020@H\u0002J\f\u0010Q\u001a\u00020\u0014*\u00020@H\u0002J\f\u0010R\u001a\u00020\u0014*\u00020@H\u0002J\f\u0010S\u001a\u00020\u0014*\u00020@H\u0002J\f\u0010T\u001a\u00020\u0014*\u00020@H\u0002J\f\u0010U\u001a\u00020\u0014*\u00020VH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR'\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0013\u001a\u00020\u00148BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0012\u0012\u0004\b\u0015\u0010\u000e\u001a\u0004\b\u0016\u0010\u0017R!\u0010\u0019\u001a\u00020\u00148BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u0012\u0012\u0004\b\u001a\u0010\u000e\u001a\u0004\b\u001b\u0010\u0017R!\u0010\u001d\u001a\u00020\u00148BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b \u0010\u0012\u0012\u0004\b\u001e\u0010\u000e\u001a\u0004\b\u001f\u0010\u0017R!\u0010!\u001a\u00020\u00148BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b$\u0010\u0012\u0012\u0004\b\"\u0010\u000e\u001a\u0004\b#\u0010\u0017R!\u0010%\u001a\u00020\u00148BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b(\u0010\u0012\u0012\u0004\b&\u0010\u000e\u001a\u0004\b'\u0010\u0017R!\u0010)\u001a\u00020\u00148BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b,\u0010\u0012\u0012\u0004\b*\u0010\u000e\u001a\u0004\b+\u0010\u0017R!\u0010-\u001a\u00020\u00148BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b0\u0010\u0012\u0012\u0004\b.\u0010\u000e\u001a\u0004\b/\u0010\u0017R!\u00101\u001a\u00020\u00148BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b4\u0010\u0012\u0012\u0004\b2\u0010\u000e\u001a\u0004\b3\u0010\u0017R!\u00105\u001a\u00020\u00148BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b8\u0010\u0012\u0012\u0004\b6\u0010\u000e\u001a\u0004\b7\u0010\u0017R!\u00109\u001a\u00020\u00148BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b<\u0010\u0012\u0012\u0004\b:\u0010\u000e\u001a\u0004\b;\u0010\u0017\u00a8\u0006X"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MagicNumber;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "ignoreNumbers", "", "", "getIgnoreNumbers$annotations", "()V", "getIgnoreNumbers", "()Ljava/util/List;", "ignoreNumbers$delegate", "Lkotlin/properties/ReadOnlyProperty;", "ignoreHashCodeFunction", "", "getIgnoreHashCodeFunction$annotations", "getIgnoreHashCodeFunction", "()Z", "ignoreHashCodeFunction$delegate", "ignorePropertyDeclaration", "getIgnorePropertyDeclaration$annotations", "getIgnorePropertyDeclaration", "ignorePropertyDeclaration$delegate", "ignoreLocalVariableDeclaration", "getIgnoreLocalVariableDeclaration$annotations", "getIgnoreLocalVariableDeclaration", "ignoreLocalVariableDeclaration$delegate", "ignoreConstantDeclaration", "getIgnoreConstantDeclaration$annotations", "getIgnoreConstantDeclaration", "ignoreConstantDeclaration$delegate", "ignoreCompanionObjectPropertyDeclaration", "getIgnoreCompanionObjectPropertyDeclaration$annotations", "getIgnoreCompanionObjectPropertyDeclaration", "ignoreCompanionObjectPropertyDeclaration$delegate", "ignoreAnnotation", "getIgnoreAnnotation$annotations", "getIgnoreAnnotation", "ignoreAnnotation$delegate", "ignoreNamedArgument", "getIgnoreNamedArgument$annotations", "getIgnoreNamedArgument", "ignoreNamedArgument$delegate", "ignoreEnums", "getIgnoreEnums$annotations", "getIgnoreEnums", "ignoreEnums$delegate", "ignoreRanges", "getIgnoreRanges$annotations", "getIgnoreRanges", "ignoreRanges$delegate", "ignoreExtensionFunctions", "getIgnoreExtensionFunctions$annotations", "getIgnoreExtensionFunctions", "ignoreExtensionFunctions$delegate", "visitConstantExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "isIgnoredByConfig", "parseAsDoubleOrNull", "rawToken", "", "(Ljava/lang/String;)Ljava/lang/Double;", "parseAsDouble", "rawNumber", "normalizeForParsingAsDouble", "text", "isNamedArgument", "isPartOfFunctionReturnConstant", "isPartOfConstructorOrFunctionConstant", "isPartOfRange", "isSubjectOfExtensionFunction", "isPartOfHashCode", "isLocalProperty", "isProperty", "isCompanionObjectProperty", "isInCompanionObject", "isConstantProperty", "hasUnaryMinusPrefix", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "Companion", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nMagicNumber.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MagicNumber.kt\nio/gitlab/arturbosch/detekt/rules/style/MagicNumber\n+ 2 IsPartOfUtils.kt\nio/gitlab/arturbosch/detekt/rules/IsPartOfUtilsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,246:1\n10#2:247\n10#2:249\n10#2:252\n146#3:248\n146#3:250\n146#3:251\n146#3:253\n146#3:254\n146#3:255\n146#3:256\n146#3:258\n146#3:259\n1#4:257\n1557#5:260\n1628#5,3:261\n*S KotlinDebug\n*F\n+ 1 MagicNumber.kt\nio/gitlab/arturbosch/detekt/rules/style/MagicNumber\n*L\n155#1:247\n157#1:249\n190#1:252\n155#1:248\n157#1:250\n189#1:251\n190#1:253\n220#1:254\n225#1:255\n228#1:256\n233#1:258\n236#1:259\n87#1:260\n87#1:261,3\n*E\n"})
public final class MagicNumber
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty ignoreNumbers$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreHashCodeFunction$delegate;
    @NotNull
    private final ReadOnlyProperty ignorePropertyDeclaration$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreLocalVariableDeclaration$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreConstantDeclaration$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreCompanionObjectPropertyDeclaration$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreAnnotation$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreNamedArgument$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreEnums$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreRanges$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreExtensionFunctions$delegate;
    private static final int HEX_RADIX = 16;
    private static final int BINARY_RADIX = 2;

    public MagicNumber(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Report magic numbers. Magic number is a numeric literal that is not defined as a constant and hence it's unclear what the purpose of this number is. It's better to declare such numbers as constants and give them a proper name. By default, -1, 0, 1, and 2 are not considered to be magic numbers.", Debt.Companion.getTEN_MINS());
        String[] stringArray = new String[]{"-1", "0", "1", "2"};
        this.ignoreNumbers$delegate = ConfigPropertyKt.config(CollectionsKt.listOf(stringArray), arg_0 -> MagicNumber.ignoreNumbers_delegate$lambda$0(this, arg_0));
        this.ignoreHashCodeFunction$delegate = ConfigPropertyKt.config(true);
        this.ignorePropertyDeclaration$delegate = ConfigPropertyKt.config(false);
        this.ignoreLocalVariableDeclaration$delegate = ConfigPropertyKt.config(false);
        this.ignoreConstantDeclaration$delegate = ConfigPropertyKt.config(true);
        this.ignoreCompanionObjectPropertyDeclaration$delegate = ConfigPropertyKt.config(true);
        this.ignoreAnnotation$delegate = ConfigPropertyKt.config(false);
        this.ignoreNamedArgument$delegate = ConfigPropertyKt.config(true);
        this.ignoreEnums$delegate = ConfigPropertyKt.config(false);
        this.ignoreRanges$delegate = ConfigPropertyKt.config(false);
        this.ignoreExtensionFunctions$delegate = ConfigPropertyKt.config(true);
    }

    public /* synthetic */ MagicNumber(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<Double> getIgnoreNumbers() {
        return (List)this.ignoreNumbers$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="numbers which do not count as magic numbers")
    private static /* synthetic */ void getIgnoreNumbers$annotations() {
    }

    private final boolean getIgnoreHashCodeFunction() {
        return (Boolean)this.ignoreHashCodeFunction$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Configuration(description="whether magic numbers in hashCode functions should be ignored")
    private static /* synthetic */ void getIgnoreHashCodeFunction$annotations() {
    }

    private final boolean getIgnorePropertyDeclaration() {
        return (Boolean)this.ignorePropertyDeclaration$delegate.getValue(this, $$delegatedProperties[2]);
    }

    @Configuration(description="whether magic numbers in property declarations should be ignored")
    private static /* synthetic */ void getIgnorePropertyDeclaration$annotations() {
    }

    private final boolean getIgnoreLocalVariableDeclaration() {
        return (Boolean)this.ignoreLocalVariableDeclaration$delegate.getValue(this, $$delegatedProperties[3]);
    }

    @Configuration(description="whether magic numbers in local variable declarations should be ignored")
    private static /* synthetic */ void getIgnoreLocalVariableDeclaration$annotations() {
    }

    private final boolean getIgnoreConstantDeclaration() {
        return (Boolean)this.ignoreConstantDeclaration$delegate.getValue(this, $$delegatedProperties[4]);
    }

    @Configuration(description="whether magic numbers in constant declarations should be ignored")
    private static /* synthetic */ void getIgnoreConstantDeclaration$annotations() {
    }

    private final boolean getIgnoreCompanionObjectPropertyDeclaration() {
        return (Boolean)this.ignoreCompanionObjectPropertyDeclaration$delegate.getValue(this, $$delegatedProperties[5]);
    }

    @Configuration(description="whether magic numbers in companion object declarations should be ignored")
    private static /* synthetic */ void getIgnoreCompanionObjectPropertyDeclaration$annotations() {
    }

    private final boolean getIgnoreAnnotation() {
        return (Boolean)this.ignoreAnnotation$delegate.getValue(this, $$delegatedProperties[6]);
    }

    @Configuration(description="whether magic numbers in annotations should be ignored")
    private static /* synthetic */ void getIgnoreAnnotation$annotations() {
    }

    private final boolean getIgnoreNamedArgument() {
        return (Boolean)this.ignoreNamedArgument$delegate.getValue(this, $$delegatedProperties[7]);
    }

    @Configuration(description="whether magic numbers in named arguments should be ignored")
    private static /* synthetic */ void getIgnoreNamedArgument$annotations() {
    }

    private final boolean getIgnoreEnums() {
        return (Boolean)this.ignoreEnums$delegate.getValue(this, $$delegatedProperties[8]);
    }

    @Configuration(description="whether magic numbers in enums should be ignored")
    private static /* synthetic */ void getIgnoreEnums$annotations() {
    }

    private final boolean getIgnoreRanges() {
        return (Boolean)this.ignoreRanges$delegate.getValue(this, $$delegatedProperties[9]);
    }

    @Configuration(description="whether magic numbers in ranges should be ignored")
    private static /* synthetic */ void getIgnoreRanges$annotations() {
    }

    private final boolean getIgnoreExtensionFunctions() {
        return (Boolean)this.ignoreExtensionFunctions$delegate.getValue(this, $$delegatedProperties[10]);
    }

    @Configuration(description="whether magic numbers as subject of an extension function should be ignored")
    private static /* synthetic */ void getIgnoreExtensionFunctions$annotations() {
    }

    @Override
    public void visitConstantExpression(@NotNull KtConstantExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IStubElementType iStubElementType = expression2.getElementType();
        Intrinsics.checkNotNullExpressionValue(iStubElementType, "getElementType(...)");
        IStubElementType elementType = iStubElementType;
        if (!Intrinsics.areEqual(elementType, KtNodeTypes.INTEGER_CONSTANT) && !Intrinsics.areEqual(elementType, KtNodeTypes.FLOAT_CONSTANT)) {
            return;
        }
        if (this.isIgnoredByConfig(expression2) || this.isPartOfFunctionReturnConstant(expression2) || this.isPartOfConstructorOrFunctionConstant(expression2)) {
            return;
        }
        PsiElement parent2 = expression2.getParent();
        Intrinsics.checkNotNull(parent2);
        String rawNumber = this.hasUnaryMinusPrefix(parent2) ? parent2.getText() : expression2.getText();
        Intrinsics.checkNotNull(rawNumber);
        Double number = this.parseAsDoubleOrNull(rawNumber);
        if (number != null && !this.getIgnoreNumbers().contains(number)) {
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), "This expression contains a magic number. Consider defining it to a well named constant.", null, null, 24, null));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIgnoredByConfig(KtConstantExpression expression2) {
        boolean $i$f$getNonStrictParentOfType;
        PsiElement $this$getNonStrictParentOfType$iv$iv;
        boolean $i$f$isPartOf;
        PsiElement $this$isPartOf$iv;
        if (this.getIgnorePropertyDeclaration() && this.isProperty(expression2)) {
            return true;
        }
        if (this.getIgnoreLocalVariableDeclaration() && this.isLocalProperty(expression2)) {
            return true;
        }
        if (this.getIgnoreConstantDeclaration() && this.isConstantProperty(expression2)) {
            return true;
        }
        if (this.getIgnoreCompanionObjectPropertyDeclaration() && this.isCompanionObjectProperty(expression2)) {
            return true;
        }
        if (this.getIgnoreAnnotation()) {
            $this$isPartOf$iv = expression2;
            $i$f$isPartOf = false;
            $this$getNonStrictParentOfType$iv$iv = $this$isPartOf$iv;
            $i$f$getNonStrictParentOfType = false;
            if (PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv$iv, KtAnnotationEntry.class, false) != null) {
                return true;
            }
            boolean bl = false;
            if (bl) {
                return true;
            }
        }
        if (this.getIgnoreHashCodeFunction() && this.isPartOfHashCode(expression2)) {
            return true;
        }
        if (this.getIgnoreEnums()) {
            $this$isPartOf$iv = expression2;
            $i$f$isPartOf = false;
            $this$getNonStrictParentOfType$iv$iv = $this$isPartOf$iv;
            $i$f$getNonStrictParentOfType = false;
            if (PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv$iv, KtEnumEntry.class, false) != null) {
                return true;
            }
            boolean bl = false;
            if (bl) {
                return true;
            }
        }
        if (this.getIgnoreNamedArgument() && this.isNamedArgument(expression2)) {
            return true;
        }
        if (this.getIgnoreRanges() && this.isPartOfRange(expression2)) {
            return true;
        }
        if (!this.getIgnoreExtensionFunctions()) return false;
        if (!this.isSubjectOfExtensionFunction(expression2)) return false;
        return true;
    }

    private final Double parseAsDoubleOrNull(String rawToken) {
        Double d;
        try {
            d = this.parseAsDouble(rawToken);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        return d;
    }

    private final double parseAsDouble(String rawNumber) {
        double d;
        String normalizedText = this.normalizeForParsingAsDouble(rawNumber);
        if (StringsKt.startsWith$default(normalizedText, "0x", false, 2, null)) {
            String string2 = normalizedText.substring(2);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            d = Long.parseLong(string2, CharsKt.checkRadix(16));
        } else if (StringsKt.startsWith$default(normalizedText, "0b", false, 2, null)) {
            String string3 = normalizedText.substring(2);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            d = Long.parseLong(string3, CharsKt.checkRadix(2));
        } else {
            d = Double.parseDouble(normalizedText);
        }
        return d;
    }

    private final String normalizeForParsingAsDouble(String text) {
        String string2 = ((Object)StringsKt.trim((CharSequence)text)).toString();
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue(locale, "US");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        return StringsKt.removeSuffix(StringsKt.removeSuffix(StringsKt.removeSuffix(StringsKt.replace$default(string3, "_", "", false, 4, null), (CharSequence)"l"), (CharSequence)"d"), (CharSequence)"f");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNamedArgument(KtConstantExpression $this$isNamedArgument) {
        KtValueArgument valueArgument;
        PsiElement $this$getNonStrictParentOfType$iv = $this$isNamedArgument;
        boolean $i$f$getNonStrictParentOfType = false;
        KtValueArgument ktValueArgument = valueArgument = PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv, KtValueArgument.class, false);
        if (ktValueArgument == null) return false;
        if (!ktValueArgument.isNamed()) return false;
        boolean bl = true;
        if (!bl) return false;
        PsiElement $this$isPartOf$iv = $this$isNamedArgument;
        boolean $i$f$isPartOf = false;
        PsiElement $this$getNonStrictParentOfType$iv$iv = $this$isPartOf$iv;
        boolean $i$f$getNonStrictParentOfType2 = false;
        if (PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv$iv, KtCallElement.class, false) == null) return false;
        return true;
    }

    private final boolean isPartOfFunctionReturnConstant(KtConstantExpression $this$isPartOfFunctionReturnConstant) {
        return $this$isPartOfFunctionReturnConstant.getParent() instanceof KtNamedFunction || $this$isPartOfFunctionReturnConstant.getParent() instanceof KtReturnExpression && $this$isPartOfFunctionReturnConstant.getParent().getParent().getChildren().length == 1;
    }

    private final boolean isPartOfConstructorOrFunctionConstant(KtConstantExpression $this$isPartOfConstructorOrFunctionConstant) {
        PsiElement psiElement;
        return $this$isPartOfConstructorOrFunctionConstant.getParent() instanceof KtParameter && ((psiElement = $this$isPartOfConstructorOrFunctionConstant.getParent().getParent().getParent()) instanceof KtNamedFunction || psiElement instanceof KtPrimaryConstructor || psiElement instanceof KtSecondaryConstructor);
    }

    private final boolean isPartOfRange(KtConstantExpression $this$isPartOfRange) {
        PsiElement theParent = $this$isPartOfRange.getParent();
        String[] stringArray = new String[]{"downTo", "until", "step"};
        Set<String> rangeOperators = SetsKt.setOf(stringArray);
        return theParent instanceof KtBinaryExpression ? Intrinsics.areEqual(((KtBinaryExpression)theParent).getOperationToken(), KtTokens.RANGE) || rangeOperators.contains(((KtBinaryExpression)theParent).getOperationReference().getReferencedName()) : false;
    }

    private final boolean isSubjectOfExtensionFunction(KtConstantExpression $this$isSubjectOfExtensionFunction) {
        return $this$isSubjectOfExtensionFunction.getParent() instanceof KtDotQualifiedExpression;
    }

    private final boolean isPartOfHashCode(KtConstantExpression $this$isPartOfHashCode) {
        KtNamedFunction containingFunction;
        PsiElement $this$getNonStrictParentOfType$iv = $this$isPartOfHashCode;
        boolean $i$f$getNonStrictParentOfType = false;
        KtNamedFunction ktNamedFunction = containingFunction = PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv, KtNamedFunction.class, false);
        return ktNamedFunction != null ? MethodSignatureKt.isHashCodeFunction(ktNamedFunction) : false;
    }

    private final boolean isLocalProperty(KtConstantExpression $this$isLocalProperty) {
        PsiElement $this$getNonStrictParentOfType$iv = $this$isLocalProperty;
        boolean $i$f$getNonStrictParentOfType = false;
        KtProperty ktProperty = PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv, KtProperty.class, false);
        return ktProperty != null ? ktProperty.isLocal() : false;
    }

    private final boolean isProperty(KtConstantExpression $this$isProperty) {
        boolean bl;
        PsiElement $this$getNonStrictParentOfType$iv = $this$isProperty;
        boolean $i$f$getNonStrictParentOfType = false;
        KtProperty ktProperty = PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv, KtProperty.class, false);
        if (ktProperty != null) {
            KtProperty it = ktProperty;
            boolean bl2 = false;
            bl = !it.isLocal();
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isCompanionObjectProperty(KtConstantExpression $this$isCompanionObjectProperty) {
        return this.isProperty($this$isCompanionObjectProperty) && this.isInCompanionObject($this$isCompanionObjectProperty);
    }

    private final boolean isInCompanionObject(KtConstantExpression $this$isInCompanionObject) {
        PsiElement $this$getNonStrictParentOfType$iv = $this$isInCompanionObject;
        boolean $i$f$getNonStrictParentOfType = false;
        KtObjectDeclaration ktObjectDeclaration = PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv, KtObjectDeclaration.class, false);
        return ktObjectDeclaration != null ? ktObjectDeclaration.isCompanion() : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isConstantProperty(KtConstantExpression $this$isConstantProperty) {
        if (!this.isProperty($this$isConstantProperty)) return false;
        PsiElement $this$getNonStrictParentOfType$iv = $this$isConstantProperty;
        boolean $i$f$getNonStrictParentOfType = false;
        KtProperty ktProperty = PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv, KtProperty.class, false);
        if (ktProperty == null) return false;
        boolean bl = KtModifierListKt.isConstant(ktProperty);
        if (!bl) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasUnaryMinusPrefix(PsiElement $this$hasUnaryMinusPrefix) {
        if (!($this$hasUnaryMinusPrefix instanceof KtPrefixExpression)) return false;
        PsiElement psiElement = ((KtPrefixExpression)$this$hasUnaryMinusPrefix).getFirstChild();
        KtOperationReferenceExpression ktOperationReferenceExpression = psiElement instanceof KtOperationReferenceExpression ? (KtOperationReferenceExpression)psiElement : null;
        if (!Intrinsics.areEqual(ktOperationReferenceExpression != null ? ktOperationReferenceExpression.getOperationSignTokenType() : null, KtTokens.MINUS)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final List ignoreNumbers_delegate$lambda$0(MagicNumber this$0, List numbers) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(numbers, "numbers");
        Iterable $this$map$iv = numbers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            boolean $i$f$ignoreNumbers_delegate$lambda$0$stub_for_inlining = false;
            collection.add(this$0.parseAsDouble((String)p0));
        }
        return CollectionsKt.sorted((List)destination$iv$iv);
    }

    public MagicNumber() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(MagicNumber.class, "ignoreNumbers", "getIgnoreNumbers()Ljava/util/List;", 0)), Reflection.property1(new PropertyReference1Impl(MagicNumber.class, "ignoreHashCodeFunction", "getIgnoreHashCodeFunction()Z", 0)), Reflection.property1(new PropertyReference1Impl(MagicNumber.class, "ignorePropertyDeclaration", "getIgnorePropertyDeclaration()Z", 0)), Reflection.property1(new PropertyReference1Impl(MagicNumber.class, "ignoreLocalVariableDeclaration", "getIgnoreLocalVariableDeclaration()Z", 0)), Reflection.property1(new PropertyReference1Impl(MagicNumber.class, "ignoreConstantDeclaration", "getIgnoreConstantDeclaration()Z", 0)), Reflection.property1(new PropertyReference1Impl(MagicNumber.class, "ignoreCompanionObjectPropertyDeclaration", "getIgnoreCompanionObjectPropertyDeclaration()Z", 0)), Reflection.property1(new PropertyReference1Impl(MagicNumber.class, "ignoreAnnotation", "getIgnoreAnnotation()Z", 0)), Reflection.property1(new PropertyReference1Impl(MagicNumber.class, "ignoreNamedArgument", "getIgnoreNamedArgument()Z", 0)), Reflection.property1(new PropertyReference1Impl(MagicNumber.class, "ignoreEnums", "getIgnoreEnums()Z", 0)), Reflection.property1(new PropertyReference1Impl(MagicNumber.class, "ignoreRanges", "getIgnoreRanges()Z", 0)), Reflection.property1(new PropertyReference1Impl(MagicNumber.class, "ignoreExtensionFunctions", "getIgnoreExtensionFunctions()Z", 0))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MagicNumber$Companion;", "", "<init>", "()V", "HEX_RADIX", "", "BINARY_RADIX", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

