/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Location;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SourceLocation;
import io.gitlab.arturbosch.detekt.api.TextLocation;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.StringExtensionsKt;
import io.gitlab.arturbosch.detekt.rules.style.JunkKt;
import io.gitlab.arturbosch.detekt.rules.style.KtFileContent;
import io.gitlab.arturbosch.detekt.rules.style.KtFileContentKt;
import io.gitlab.arturbosch.detekt.rules.style.MaxLineLengthKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 42\u00020\u0001:\u00014B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0002J \u0010+\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'2\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020.H\u0002J \u0010/\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'2\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020.H\u0002J \u00100\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'2\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00101\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00102\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00103\u001a\u00020\u00132\u0006\u0010-\u001a\u00020.H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\u00020\u00138BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0011\u0012\u0004\b\u0014\u0010\r\u001a\u0004\b\u0015\u0010\u0016R!\u0010\u0018\u001a\u00020\u00138BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u0011\u0012\u0004\b\u0019\u0010\r\u001a\u0004\b\u001a\u0010\u0016R!\u0010\u001c\u001a\u00020\u00138BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\u0011\u0012\u0004\b\u001d\u0010\r\u001a\u0004\b\u001e\u0010\u0016R!\u0010 \u001a\u00020\u00138BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b#\u0010\u0011\u0012\u0004\b!\u0010\r\u001a\u0004\b\"\u0010\u0016\u00a8\u00065"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MaxLineLength;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "maxLineLength", "", "getMaxLineLength$annotations", "()V", "getMaxLineLength", "()I", "maxLineLength$delegate", "Lkotlin/properties/ReadOnlyProperty;", "excludePackageStatements", "", "getExcludePackageStatements$annotations", "getExcludePackageStatements", "()Z", "excludePackageStatements$delegate", "excludeImportStatements", "getExcludeImportStatements$annotations", "getExcludeImportStatements", "excludeImportStatements$delegate", "excludeCommentStatements", "getExcludeCommentStatements$annotations", "getExcludeCommentStatements", "excludeCommentStatements$delegate", "excludeRawStrings", "getExcludeRawStrings$annotations", "getExcludeRawStrings", "excludeRawStrings$delegate", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visit", "element", "Lio/gitlab/arturbosch/detekt/rules/style/KtFileContent;", "isValidLine", "offset", "line", "", "isIgnoredStatement", "containsIgnoredRawString", "containsIgnoredPackageStatement", "containsIgnoredImportStatement", "containsIgnoredCommentStatement", "Companion", "detekt-rules-style"})
public final class MaxLineLength
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty maxLineLength$delegate;
    @NotNull
    private final ReadOnlyProperty excludePackageStatements$delegate;
    @NotNull
    private final ReadOnlyProperty excludeImportStatements$delegate;
    @NotNull
    private final ReadOnlyProperty excludeCommentStatements$delegate;
    @NotNull
    private final ReadOnlyProperty excludeRawStrings$delegate;
    private static final int DEFAULT_IDEA_LINE_LENGTH = 120;
    @NotNull
    private static final Regex BLANK_OR_QUOTES;

    public MaxLineLength(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        this.issue = new Issue(string2, Severity.Style, "Line detected, which is longer than the defined maximum line length in the code style.", Debt.Companion.getFIVE_MINS());
        this.maxLineLength$delegate = ConfigPropertyKt.config(120);
        this.excludePackageStatements$delegate = ConfigPropertyKt.config(true);
        this.excludeImportStatements$delegate = ConfigPropertyKt.config(true);
        this.excludeCommentStatements$delegate = ConfigPropertyKt.config(false);
        this.excludeRawStrings$delegate = ConfigPropertyKt.config(true);
    }

    public /* synthetic */ MaxLineLength(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getMaxLineLength() {
        return ((Number)this.maxLineLength$delegate.getValue(this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="maximum line length")
    private static /* synthetic */ void getMaxLineLength$annotations() {
    }

    private final boolean getExcludePackageStatements() {
        return (Boolean)this.excludePackageStatements$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @Configuration(description="if package statements should be ignored")
    private static /* synthetic */ void getExcludePackageStatements$annotations() {
    }

    private final boolean getExcludeImportStatements() {
        return (Boolean)this.excludeImportStatements$delegate.getValue(this, $$delegatedProperties[2]);
    }

    @Configuration(description="if import statements should be ignored")
    private static /* synthetic */ void getExcludeImportStatements$annotations() {
    }

    private final boolean getExcludeCommentStatements() {
        return (Boolean)this.excludeCommentStatements$delegate.getValue(this, $$delegatedProperties[3]);
    }

    @Configuration(description="if comment statements should be ignored")
    private static /* synthetic */ void getExcludeCommentStatements$annotations() {
    }

    private final boolean getExcludeRawStrings() {
        return (Boolean)this.excludeRawStrings$delegate.getValue(this, $$delegatedProperties[4]);
    }

    @Configuration(description="if raw strings should be ignored")
    private static /* synthetic */ void getExcludeRawStrings$annotations() {
    }

    @Override
    public void visitKtFile(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        super.visitKtFile(file2);
        this.visit(KtFileContentKt.toFileContent(file2));
    }

    private final void visit(KtFileContent element) {
        int offset2 = 0;
        Sequence<String> lines = element.getContent();
        KtFile file2 = element.getFile();
        Iterator<String> iterator2 = lines.iterator();
        while (iterator2.hasNext()) {
            String line = iterator2.next();
            if (!this.isValidLine(file2, offset2 += line.length(), line)) {
                PsiElement psiElement = MaxLineLength.Companion.findFirstMeaningfulKtElementInParents(file2, offset2, line);
                if (psiElement == null) {
                    psiElement = file2;
                }
                PsiElement ktElement = psiElement;
                Location location = Location.Companion.from(file2, offset2 - line.length());
                boolean bl = false;
                Location location2 = new Location(location.getSource(), new SourceLocation(location.getSource().getLine(), line.length() + 1), new TextLocation(offset2 - line.length(), offset2), location.getFilePath());
                this.report(new CodeSmell(this.getIssue(), Entity.Companion.from(ktElement, location2), this.getIssue().getDescription(), null, null, 24, null));
            }
            ++offset2;
        }
    }

    private final boolean isValidLine(KtFile file2, int offset2, String line) {
        boolean isUrl = StringExtensionsKt.lastArgumentMatchesUrl(line);
        boolean isMarkdownOrRefUrl = StringExtensionsKt.lastArgumentMatchesMarkdownUrlSyntax(line) || StringExtensionsKt.lastArgumentMatchesKotlinReferenceUrlSyntax(line);
        return line.length() <= this.getMaxLineLength() || this.isIgnoredStatement(file2, offset2, line) || isUrl || isMarkdownOrRefUrl;
    }

    private final boolean isIgnoredStatement(KtFile file2, int offset2, String line) {
        return this.containsIgnoredPackageStatement(line) || this.containsIgnoredImportStatement(line) || this.containsIgnoredCommentStatement(line) || this.containsIgnoredRawString(file2, offset2, line);
    }

    private final boolean containsIgnoredRawString(KtFile file2, int offset2, String line) {
        if (!this.getExcludeRawStrings()) {
            return false;
        }
        PsiElement psiElement = SequencesKt.lastOrNull(JunkKt.findKtElementInParents(file2, offset2, line));
        return psiElement != null ? MaxLineLengthKt.access$isInsideRawString(psiElement) : false;
    }

    private final boolean containsIgnoredPackageStatement(String line) {
        if (!this.getExcludePackageStatements()) {
            return false;
        }
        return StringsKt.startsWith$default(((Object)StringsKt.trimStart((CharSequence)line)).toString(), "package ", false, 2, null);
    }

    private final boolean containsIgnoredImportStatement(String line) {
        if (!this.getExcludeImportStatements()) {
            return false;
        }
        return StringsKt.startsWith$default(((Object)StringsKt.trimStart((CharSequence)line)).toString(), "import ", false, 2, null);
    }

    private final boolean containsIgnoredCommentStatement(String line) {
        if (!this.getExcludeCommentStatements()) {
            return false;
        }
        return StringsKt.startsWith$default(((Object)StringsKt.trimStart((CharSequence)line)).toString(), "//", false, 2, null) || StringsKt.startsWith$default(((Object)StringsKt.trimStart((CharSequence)line)).toString(), "/*", false, 2, null) || StringsKt.startsWith$default(((Object)StringsKt.trimStart((CharSequence)line)).toString(), "*", false, 2, null);
    }

    public MaxLineLength() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(MaxLineLength.class, "maxLineLength", "getMaxLineLength()I", 0)), Reflection.property1(new PropertyReference1Impl(MaxLineLength.class, "excludePackageStatements", "getExcludePackageStatements()Z", 0)), Reflection.property1(new PropertyReference1Impl(MaxLineLength.class, "excludeImportStatements", "getExcludeImportStatements()Z", 0)), Reflection.property1(new PropertyReference1Impl(MaxLineLength.class, "excludeCommentStatements", "getExcludeCommentStatements()Z", 0)), Reflection.property1(new PropertyReference1Impl(MaxLineLength.class, "excludeRawStrings", "getExcludeRawStrings()Z", 0))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        BLANK_OR_QUOTES = new Regex("[\\s\"]*");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MaxLineLength$Companion;", "", "<init>", "()V", "DEFAULT_IDEA_LINE_LENGTH", "", "BLANK_OR_QUOTES", "Lkotlin/text/Regex;", "findFirstMeaningfulKtElementInParents", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "offset", "line", "", "detekt-rules-style"})
    @SourceDebugExtension(value={"SMAP\nMaxLineLength.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MaxLineLength.kt\nio/gitlab/arturbosch/detekt/rules/style/MaxLineLength$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,140:1\n183#2,2:141\n*S KotlinDebug\n*F\n+ 1 MaxLineLength.kt\nio/gitlab/arturbosch/detekt/rules/style/MaxLineLength$Companion\n*L\n132#1:141,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final PsiElement findFirstMeaningfulKtElementInParents(KtFile file2, int offset2, String line) {
            Object v2;
            block1: {
                void $this$firstOrNull$iv;
                Sequence<PsiElement> sequence2 = JunkKt.findKtElementInParents(file2, offset2, line);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    Regex regex = BLANK_OR_QUOTES;
                    String string2 = it.getText();
                    Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
                    if (!(!regex.matches(string2))) continue;
                    v2 = element$iv;
                    break block1;
                }
                v2 = null;
            }
            return v2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

